/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Set;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.CommandsHelp;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.NONE)
public class SetDDLSettings
extends CommandListener
implements IHelp,
IShowCommand,
IShowPrefixNameNewline {
    private static final Object DDL = "ddl";
    private static final Object ON = "on";
    private static final Object OFF = "off";

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String getCommand() {
        return "DDL";
    }

    @Override
    public String getHelp() {
        return CommandsHelp.getString(this.getCommand());
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"DDL"};
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("setddl")) {
            String[] cmds = cmd.getSQLOrig().toLowerCase().split("\\s+");
            int length = cmds.length;
            if (conn == null) {
                ctx.write(Messages.getString("SetDDLSettings.11"));
                return true;
            }
            if (length == 3 && cmds[1].toLowerCase().equals(DDL) && cmds[2].toLowerCase().equals(OFF)) {
                String defaultsql = "begin dbms_metadata.set_transform_param(dbms_metadata.session_transform,'DEFAULT',true); end;";
                DBUtil dbUtil = DBUtil.getInstance(conn);
                dbUtil.execute("begin dbms_metadata.set_transform_param(dbms_metadata.session_transform,'DEFAULT',true); end;");
                ctx.setDDLOptions("DEFAULT", "ON");
                ctx.write(Messages.getString("SetDDLSettings.15"));
                return true;
            }
            if (length == 4) {
                if (cmds[1].toLowerCase().equals(DDL) && (cmds[3].toLowerCase().equals(ON) || cmds[3].toLowerCase().equals(OFF)) || ctx.enumContains(ScriptRunnerContext.COLLATION.class, cmds[3].toUpperCase())) {
                    String option = cmds[2].toUpperCase();
                    String value = cmds[2].toUpperCase().equals("COLLATION_CLAUSE") ? cmds[3].toUpperCase() : (cmds[3].toLowerCase().equals(ON) ? "true" : "false");
                    String optionSQL = "begin dbms_metadata.set_transform_param(dbms_metadata.session_transform,:OPTION,:VALUE); end;";
                    HashMap<String, String> binds = new HashMap<String, String>();
                    binds.put("OPTION", option);
                    binds.put("VALUE", value);
                    try {
                        DBUtil dbUtil = DBUtil.getInstance(conn);
                        dbUtil.execute("begin dbms_metadata.set_transform_param(dbms_metadata.session_transform,:OPTION,:VALUE); end;", binds);
                        ctx.write(MessageFormat.format(Messages.getString("SetDDLSettings.0"), option, cmds[3].toUpperCase()));
                        ctx.setDDLOptions(option, cmds[3].toUpperCase());
                        if (cmds[3].toUpperCase().equals("OFF") || cmds[3].toUpperCase().equals("ALWAYS") || cmds[3].toUpperCase().equals("NON_DEFAULT")) {
                            ctx.setDDLOptions("DEFAULT", "OFF");
                        }
                    }
                    catch (Exception e) {
                        ctx.write(Messages.getString("SetDDLSettings.27"));
                    }
                } else {
                    ctx.write(Messages.getString("SetDDLSettings.27"));
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getDDLOptions() != null) {
            Set<String> options = ctx.getDDLOptions().keySet();
            if (ctx.getDDLOptions().get("DEFAULT").equals("ON")) {
                ctx.write("DEFAULT : ON\n");
            } else {
                for (String option : options) {
                    if (option.equals("DEFAULT")) continue;
                    ctx.write(MessageFormat.format("{0} : {1}\n", option, ctx.getDDLOptions().get(option)));
                }
            }
        }
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }
}

