/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.alias;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Alias;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Aliases;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class MetricsParser {
    private static final String ID = "id";
    private static final String MINVERSION = "minversion";
    private static final String QUERYTYPE = "querytype";
    private static final String QUERIES = "queries";
    private static final String QUERY = "query";
    private static final int MIN_VERSION_DEFAULT = 8;
    private static final String NULLDEFAULTS = "nulldefaults";
    private static final String GROUP = "group";
    protected static Logger LOGGER = Logger.getLogger(MetricsParser.class.getName());
    private XMLDocument _document;
    private DOMParser parser;
    ArrayList<Alias> aliases = new ArrayList();

    public MetricsParser() {
    }

    public MetricsParser(URL u) {
        try {
            this.parser.parse(u.openStream());
            this._document = this.parser.getDocument();
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
        }
    }

    public ArrayList<Alias> processXML(URL u) throws Exception {
        return this.processXML(u.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Alias> processXML(InputStream is) throws Exception {
        try {
            if (this.parser == null) {
                this.parser = new DOMParser();
            } else {
                this.parser.reset();
            }
            this.parser.setPreserveWhitespace(false);
            this.parser.parse(is);
            this._document = this.parser.getDocument();
            NodeList rootNodes = this._document.getChildNodes();
            for (int i = 0; i < rootNodes.getLength(); ++i) {
                this.processNodes(rootNodes.item(i));
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return this.aliases;
    }

    private void processNodes(Node item) {
        NodeList children = item.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (!childName.equalsIgnoreCase(QUERYTYPE)) continue;
            this.newItem(child);
        }
    }

    private void newItem(Node child) {
        String aliasname = XMLHelper.getAttributeNode(child, ID);
        HashMap<String, String> map = XMLHelper.getAttributeNodes(child);
        String description = "";
        String query = "";
        String minVersionString = "";
        HashMap<Integer, String> queries = new HashMap<Integer, String>();
        NodeList items = child.getChildNodes();
        for (int i = 0; i < items.getLength(); ++i) {
            Node x = items.item(i);
            if (!x.getNodeName().equalsIgnoreCase(QUERIES)) continue;
            NodeList ql = x.getChildNodes();
            for (int j = 0; j < ql.getLength(); ++j) {
                Node y = ql.item(j);
                if (!y.getLocalName().equalsIgnoreCase(QUERY)) continue;
                minVersionString = XMLHelper.getAttributeNode(y, MINVERSION);
                int version = 8;
                if (minVersionString != null && !minVersionString.equals("")) {
                    try {
                        version = Integer.parseInt(minVersionString);
                    }
                    catch (NumberFormatException e) {
                        try {
                            Float minVersionFloat = Float.valueOf(Float.parseFloat(minVersionString));
                            version = minVersionFloat.intValue();
                        }
                        catch (Exception minVersionFloat) {
                            // empty catch block
                        }
                    }
                }
                NodeList sqls = y.getChildNodes();
                for (int k = 0; k < sqls.getLength(); ++k) {
                    Node z = sqls.item(k);
                    Node n1 = z.getFirstChild();
                    if (!(n1 instanceof Text)) continue;
                    query = ((Text)n1).getTextContent();
                    queries.put(version, query);
                }
            }
        }
        this.aliases.add(new Alias(aliasname, description, queries, true, map));
    }

    public static void main(String[] args) {
        MetricsParser mp = new MetricsParser();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        List<Path> paths = FileUtils.getFilesInPackage("oracle/dbtools/raptor/metrics/", "xml");
        URL u = cl.getResource("oracle/dbtools/raptor/metrics/sysjob/OsStat.xml");
        try {
            for (Path p : paths) {
                ArrayList<Alias> aliases = mp.processXML(p.toUri().toURL());
                Aliases.getInstance().add(aliases);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

