/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.NONE)
public class ShowEscape
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWESCAPE = new String[]{"esc", "esca", "escap", "escape"};

    @Override
    public String[] getShowAliases() {
        return SHOWESCAPE;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getCurrentConnection() == null || ctx.getCurrentConnection() instanceof OracleConnection) {
            return this.doShowEscape(conn, ctx, cmd);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowEscape(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx.getEscape()) {
            String message = "escape \"{0}\" (hex {1})";
            ctx.write(MessageFormat.format(message, Character.valueOf(ctx.getEscapeChar()), String.format("%x", ctx.getEscapeChar())) + "\n");
        } else {
            ctx.write("escape OFF\n");
        }
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        if (ctx.getEscape()) {
            return StoreRegistry.getCommand("escape", String.valueOf(ctx.getEscapeChar()));
        }
        return StoreRegistry.getCommand("escape", "OFF");
    }
}

