/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.parameterparser.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.ParmResources;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parser.ArgumentTokenizer;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.service.ValidatorRegistry;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.validators.ValidatorInterface;

public class CoreParameterParser {
    public static void loadParams(String setName, String parmString, ScriptRunnerContext ctx, ArrayList<String> commands, HashMap<String, String> options) throws InvalidParameterException {
        CoreParameterParser.loadParams(setName, parmString, ctx, commands, options, true);
    }

    public static void loadParams(String setName, String parmString, ScriptRunnerContext ctx, ArrayList<String> commands, HashMap<String, String> options, boolean escapeBackSlashes) throws InvalidParameterException {
        HashMap<String, String> params = ctx.resetParams(setName);
        List<String> rawArgs = ArgumentTokenizer.tokenize(parmString, false, escapeBackSlashes);
        String[] _args = rawArgs.toArray(new String[0]);
        params.put("baseCommand", _args[0]);
        for (int i = 1; i < _args.length; ++i) {
            String option;
            if (!_args[i].startsWith("-")) {
                CoreParameterParser.validateCommand(_args[i], commands);
                if (_args[i].equalsIgnoreCase("help")) {
                    params.put("help", "true");
                }
                if (params.get("command") != null) {
                    params.put("command", params.get("command") + "," + _args[i].toLowerCase());
                    continue;
                }
                params.put("command", _args[i].toLowerCase());
                continue;
            }
            if (_args.length > i + 1) {
                option = _args[i].substring(1);
                String value = _args[i + 1].length() > 1 && _args[i + 1].startsWith("-") ? null : _args[++i];
                CoreParameterParser.validateOption(option, value, options);
                params.put(option, value);
                continue;
            }
            option = _args[i].substring(1);
            CoreParameterParser.validateOption(option, null, options);
            params.put(option, null);
        }
        if (ctx.getBoolParam(setName, "debug")) {
            ctx.printArgs(setName);
        }
    }

    private static void validateOption(String param, String value, HashMap<String, String> options) throws InvalidParameterException {
        if (!options.containsKey(param)) {
            throw new InvalidParameterException(ParmResources.format("UNKNOWN_OPTION", param) + "\n");
        }
        String validatorName = options.get(param);
        ValidatorInterface validator = ValidatorRegistry.getValidator(validatorName);
        if (validator == null) {
            throw new InvalidParameterException("Validator not found " + param + "\n");
        }
        Boolean valid = validator.validate(value);
        if (!valid.booleanValue()) {
            throw new InvalidParameterException(ParmResources.format("INV_VALUE", param, value) + "\n");
        }
    }

    private static void validateCommand(String param, ArrayList<String> commands) throws InvalidParameterException {
        if (commands.contains(param)) {
            return;
        }
        throw new InvalidParameterException(ParmResources.format("UNKNOWN_COMMAND", param) + "\n");
    }
}

