/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.swagger;

import java.io.Reader;
import java.io.StringReader;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.swagger.OpenAPIParser;
import oracle.dbtools.rest.swagger.ParserBase;
import oracle.dbtools.rest.swagger.SwaggerParser;

public class SwaggerReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestModule read(String rawJSON) {
        JsonReader reader = this.toJSON(rawJSON);
        JsonObject root = reader.readObject();
        ParserBase parser = new SwaggerParser();
        if (this.isOpenAPI(root)) {
            parser = new OpenAPIParser();
        } else if (this.isSwagger(root)) {
            parser = new SwaggerParser();
        }
        RestModule module = null;
        try {
            module = parser.read(root);
        }
        finally {
            reader.close();
        }
        return module;
    }

    private JsonReader toJSON(String json) {
        JsonReader reader = Json.createReader((Reader)new StringReader(json));
        return reader;
    }

    private boolean isSwagger(JsonObject node) {
        return node.containsKey((Object)"swagger");
    }

    private boolean isOpenAPI(JsonObject node) {
        return node.containsKey((Object)"openapi");
    }
}

