/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.util.ArrayList;
import java.util.List;

public class HtmlTreeTableWidget {
    public String[] columnNames;
    private List<Row> data = new ArrayList<Row>();
    private List<Integer> levels = new ArrayList<Integer>();
    private List<String> images = new ArrayList<String>();
    public String formName;
    private static final String defaultName = "";
    public String widgetName = "";
    static final String tableBgColor = "#ffffff";
    static final String yellowBgColor = "#ffffdf";
    static final String grayBgColor = "#dfdfdf";
    static final String yellowBgColor1 = "#ffffd2";
    static final String grayBgColor1 = "#dfd5d1";

    public void append(String longLabel, String[] row, int level, String img) {
        this.append(longLabel, row, level, img, null);
    }

    public void append(String longLabel, String[] row, int level, String img, String color) {
        this.data.add(new Row(longLabel, row, color));
        this.levels.add(level);
        this.images.add(img);
    }

    public void concat(String moreLabel, String[] moreRow) {
        int idx = this.data.size();
        Row last = this.data.get(idx - 1);
        if (moreLabel != null) {
            last.label = last.label + moreLabel;
        }
        for (int i = 0; i < last.fields.length; ++i) {
            int n = i;
            last.fields[n] = last.fields[n] + moreRow[i];
        }
    }

    public String dataAt(int row, int col) {
        Row rowObj = this.data.get(row);
        if (rowObj.label != null) {
            return rowObj.label;
        }
        return rowObj.fields[col];
    }

    public String render() {
        StringBuilder ret = new StringBuilder();
        if (this.columnNames.length == 0) {
            return defaultName;
        }
        ret.append("<TABLE class=\"TreeTableWidget\" border=0 cellpadding=0 cellspacing=0 width=100% bgcolor=#efefef><tr><td> \n");
        ret.append(this.renderData());
        ret.append("</td></tr></TABLE> \n");
        return ret.toString();
    }

    public String renderData() {
        StringBuilder ret = new StringBuilder();
        ret.append("\n <!-- ..........................data begin...........................  -->\n");
        ret.append("\n    <TABLE class=TreeTableWidget border=0 cellspacing=0 cellpadding=1 align=center width=100%\"  bgcolor=#ffffff> \n");
        ret.append("    <tr class=\"TableCell\">\n");
        boolean isEvenCol = true;
        for (int i = 0; i < this.columnNames.length; ++i) {
            ret.append("\n       <td valign=top bgcolor=" + (isEvenCol ? "#bbbbbb" : "#aaaaaa") + ">&nbsp;<font color=#444477>");
            ret.append(this.columnNames[i]);
            ret.append("</font>&nbsp;</td>\n");
            isEvenCol = !isEvenCol;
        }
        ret.append("\n    </tr>\n");
        boolean evenRow = true;
        for (int row = 0; row < this.data.size(); ++row) {
            boolean rowSpans;
            ret.append("\n   <tr>");
            boolean bl = rowSpans = this.data.get((int)row).label != null;
            if (!rowSpans) {
                evenRow = !evenRow;
            }
            boolean evenCol = true;
            int width0 = 45;
            int decrFontSize1 = this.columnNames.length > 6 ? -1 : 0;
            boolean firstCol = true;
            for (int col = 0; col < this.columnNames.length; ++col) {
                boolean isHtml;
                String cell;
                if (rowSpans && !firstCol) continue;
                evenCol = !evenCol;
                ret.append("\n      <td width=" + (firstCol ? width0 : (100 - width0) / this.columnNames.length) + "% valign=top bgcolor=" + (firstCol ? tableBgColor : (evenRow ? (evenCol ? yellowBgColor : yellowBgColor1) : (evenCol ? grayBgColor : grayBgColor1))) + (String)(rowSpans && firstCol ? " colspan=" + this.columnNames.length : " ") + ">");
                boolean closeFontTag = false;
                if (!rowSpans && this.dataAt(row, col) != null) {
                    int decrFontSize2;
                    int n = decrFontSize2 = this.dataAt(row, col).length() > 9 ? -1 : 0;
                    if (decrFontSize1 + decrFontSize2 < 0) {
                        ret.append("<font size=" + (decrFontSize1 + decrFontSize2) + ">");
                    }
                    closeFontTag = true;
                }
                if (firstCol) {
                    ret.append("<table width=100% border=0 cellspacing=0 cellpadding=0><tr><td width=1%><table CELLSPACING=0 cellpadding=0><tr><td>");
                    for (int i = 0; i < this.levels.get(row); ++i) {
                        ret.append("&nbsp;&nbsp;&nbsp;&nbsp;</td><td>");
                    }
                    String nodeCtrlImg = "minus";
                    ret.append("<IMG SRC=\"images/" + nodeCtrlImg + ".gif\" wWIDTH=16 hHEIGHT=16 BORDER=0>");
                    if (this.images.get(row) != null) {
                        ret.append("<IMG SRC=\"images/" + this.images.get(row) + "\" wWIDTH=16 hHEIGHT=16 BORDER=0>");
                    }
                    ret.append("</td><tr></table></td>  <td width=99%>");
                    if (this.data.get((int)row).color != null) {
                        ret.append("<font color=" + this.data.get((int)row).color + ">");
                        closeFontTag = true;
                    }
                }
                if ((cell = this.dataAt(row, rowSpans ? 0 : col)) == null) {
                    cell = "&nbsp";
                }
                ret.append(((isHtml = cell.startsWith("<")) ? defaultName : "&nbsp;") + cell + (isHtml ? defaultName : "&nbsp;"));
                if (firstCol) {
                    ret.append("</td></tr></table>");
                }
                if (closeFontTag) {
                    ret.append("</font>");
                }
                ret.append("</td>");
                firstCol = false;
            }
            ret.append("\n   </tr>");
        }
        ret.append("\n</table>\n");
        ret.append("\n <!-- ..........................data end...........................  -->\n\n");
        return ret.toString();
    }

    private static class Row {
        String label = null;
        String color = null;
        String[] fields;

        public Row(String longLabel, String[] row, String color) {
            this.label = longLabel;
            this.fields = row;
            this.color = color;
        }
    }
}

