/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.commands;

import java.sql.Connection;
import oracle.dbtools.DataPumpResources;
import oracle.dbtools.common.DataPumpArguments;
import oracle.dbtools.common.DataPumpModel;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.exceptions.ProcessFailedException;
import oracle.dbtools.executors.DataPumpExecutor;
import oracle.dbtools.executors.DataPumpTransfer;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.generators.DataPumpGenerator;
import oracle.dbtools.generators.DataPumpPreprocessor;
import oracle.dbtools.parser.DataPumpParser;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.raptor.utils.ToolLogger;
import oracle.dbtools.raptor.utils.ToolLoggerResources;
import oracle.dbtools.util.Logger;

public class DataPumpCommand
extends CommandListener
implements SQLCLService,
IHelp,
Connected {
    private static final String NAME = "DataPump Command";
    private static final String EXPORT = "export";
    private static final String IMPORT = "import";
    private static final String HELP = "help";
    private static final String DQUOTE = "\"";
    private static final String NL = "\n";
    private static final String SPACE = " ";
    private static final String SQUOTE = "'";
    private DataPumpModel _model;

    public String getCommand() {
        return "DATAPUMP";
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        return "Datapump Commands";
    }

    public String getExtensionName() {
        return NAME;
    }

    public String getExtensionVersion() {
        return "1";
    }

    public String getHelp() {
        return DataPumpResources.getString("DP_HELP");
    }

    public boolean isSqlPlus() {
        return false;
    }

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!cmd.getLoweredTrimmedSQL().startsWith("dp") && !cmd.getLoweredTrimmedSQL().startsWith("datapump")) {
            return false;
        }
        cmd.setSql(SQLPLUS.removeDashNewline((ISQLCommand)cmd, (String)cmd.getSql()));
        long start = System.currentTimeMillis();
        DataPumpArguments args = (DataPumpArguments)ctx.getProperty("data.pump");
        args = args == null ? new DataPumpArguments() : args.deepClone();
        this._model = new DataPumpModel(conn, ctx, cmd, args);
        this._model.getToolLogger().flushLog();
        String helpArg = null;
        try {
            DataPumpParser parser = new DataPumpParser(this._model);
            parser.parse();
            this._model.getToolLogger().flushLog();
            helpArg = (String)args.get(HELP);
            if (helpArg != null) {
                if (helpArg.equalsIgnoreCase(HELP)) {
                    this._model.getToolLogger().log(DataPumpResources.getString("DP_HELP"));
                } else if (helpArg.endsWith("examples")) {
                    this._model.getToolLogger().log(DataPumpResources.getString("DP_HELP_EXAMPLES"));
                } else if (helpArg.endsWith("syntax")) {
                    this._model.getToolLogger().log(DataPumpResources.getString("DP_HELP_SYNTAX"));
                } else {
                    this._model.getToolLogger().log(DataPumpResources.getString("DP_HELP"));
                }
            } else {
                this._model.getToolLogger().logToolStart(DataPumpResources.getString("DP"));
                if (this._model.isDebug()) {
                    this._model.getToolLogger().log("debug on");
                }
                if (this._model.getConn() != null) {
                    String connName = ConnectionResolver.getConnectionName((Connection)this._model.getConn());
                    DataPumpPreprocessor preprocessor = new DataPumpPreprocessor(this._model);
                    if (preprocessor.check()) {
                        this._model.getToolLogger().flushLog();
                        if (preprocessor.handleSupport()) {
                            this._model.getToolLogger().flushLog();
                            DataPumpGenerator generator = new DataPumpGenerator(this._model);
                            generator.genSQL();
                            this._model.getToolLogger().flushLog();
                            if (this._model.isNoExec()) {
                                ctx.write(DataPumpResources.getString("NO_EXEC") + NL);
                            } else {
                                if (this._model.isImport() && this._model.isArgTrue("copycloud")) {
                                    DataPumpTransfer transfer = new DataPumpTransfer(this._model);
                                    transfer.transferFromCloud();
                                    this._model.getToolLogger().flushLog();
                                }
                                DataPumpExecutor executor = new DataPumpExecutor(this._model);
                                boolean isExec = executor.execSql();
                                this._model.getToolLogger().flushLog();
                                if (isExec & this._model.isExport() && this._model.isArgTrue("copycloud")) {
                                    DataPumpTransfer transfer = new DataPumpTransfer(this._model);
                                    transfer.transferToCloud();
                                    this._model.getToolLogger().flushLog();
                                }
                            }
                        }
                    }
                } else {
                    this._model.getToolLogger().logError(DataPumpResources.format("DPCMPD_CONN", (String)this._model.getArgs().get("operation")));
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                Exception e1 = ((ProcessFailedException)e).getOriginalException();
                this._model.getToolLogger().logError(e1.getLocalizedMessage());
            }
            this._model.getToolLogger().logException((Throwable)e);
            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)e);
        }
        if (helpArg == null) {
            this._model.getToolLogger().logToolEnd();
        }
        if (ctx.getTiming()) {
            this._model.getToolLogger().log(ToolLoggerResources.format((String)"TIMINGELAPSEDTOTAL", (Object[])new Object[]{ToolLogger.getElapsedTime((long)start)}) + NL);
        }
        this._model.getToolLogger().flushLog();
        return true;
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public boolean needsConnection() {
        return true;
    }
}

