/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.commands;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import oracle.dbtools.common.DataPumpArguments;
import oracle.dbtools.common.DataPumpModel;
import oracle.dbtools.exceptions.ProcessFailedException;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.parser.DataPumpParser;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.dbtools.util.Logger;

public class SetDataPump
extends CommandListener
implements SQLCLService,
IStoreCommand,
IShowCommand,
IShowPrefixNameNewline {
    private static final String DEFAULT = "default";
    private static final String NL = System.lineSeparator();
    private DataPumpModel _model;

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        return null;
    }

    public String getExtensionName() {
        return null;
    }

    public String getExtensionVersion() {
        return null;
    }

    public String[] getShowAliases() {
        return new String[]{"datapump"};
    }

    public String getStoreCommand(ScriptRunnerContext ctx) {
        StringBuilder sb = new StringBuilder();
        DataPumpArguments dpArgs = (DataPumpArguments)ctx.getProperty("data.pump");
        if (dpArgs != null) {
            ArrayList al = new ArrayList(dpArgs.keySet());
            Collections.sort(al);
            for (String key : al) {
                if (key.equals("encryptionpassword")) {
                    sb.append("set datapump -" + key + " ********" + NL);
                    continue;
                }
                sb.append("set datapump -" + key + " " + dpArgs.get(key) + NL);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("setdatapump") && !cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("setdp")) {
            return false;
        }
        DataPumpArguments dpArgs = (DataPumpArguments)ctx.getProperty("data.pump");
        String[] cmdArgs = cmd.getLoweredTrimmedSQL().split("\\s+");
        if (dpArgs == null || cmdArgs.length > 2 && cmdArgs[2].equalsIgnoreCase(DEFAULT)) {
            dpArgs = new DataPumpArguments();
            ctx.putProperty("data.pump", (Object)dpArgs);
            if (cmdArgs.length > 2 && cmdArgs[2].equalsIgnoreCase(DEFAULT)) {
                return true;
            }
        }
        this._model = new DataPumpModel(conn, ctx, cmd, dpArgs);
        this._model.isSetCommand(true);
        try {
            DataPumpParser parser = new DataPumpParser(this._model);
            parser.parse();
            String helpArg = (String)dpArgs.get("help");
            if (helpArg != null) {
                if (helpArg.equalsIgnoreCase("help")) {
                    this._model.getToolLogger().log(HelpMessages.getString((String)"SETDATAPUMP"));
                } else if (helpArg.endsWith("examples")) {
                    this._model.getToolLogger().log(HelpMessages.getString((String)"SETDATAPUMPEXAMPLES"));
                } else if (helpArg.endsWith("syntax")) {
                    this._model.getToolLogger().log(HelpMessages.getString((String)"SETDATAPUMPSYNTAX"));
                } else {
                    this._model.getToolLogger().log(HelpMessages.getString((String)"SETDATAPUMP"));
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ProcessFailedException) {
                Exception e1 = ((ProcessFailedException)e).getOriginalException();
                this._model.getToolLogger().logError(e1.getLocalizedMessage());
            } else {
                this._model.getToolLogger().logException((Throwable)e);
                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)e);
            }
        }
        finally {
            dpArgs.remove("help");
        }
        this._model.getToolLogger().flushLog();
        return true;
    }

    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        DataPumpArguments dpArgs = (DataPumpArguments)ctx.getProperty("data.pump");
        if (dpArgs != null) {
            ArrayList al = new ArrayList(dpArgs.keySet());
            Collections.sort(al);
            for (String key : al) {
                if (key.equals("encryptionpassword")) {
                    ctx.write(key + " ********" + NL);
                    continue;
                }
                ctx.write(key + " " + dpArgs.get(key) + NL);
            }
        }
        return true;
    }

    public boolean inShowAll() {
        return false;
    }

    public boolean needsDatabase() {
        return false;
    }
}

