/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.DataPumpResources;
import oracle.dbtools.common.DataPumpModel;
import oracle.dbtools.common.DataPumpOption;
import oracle.dbtools.common.DataPumpOptions;
import oracle.dbtools.exceptions.ProcessFailedException;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parser.CoreParameterParser;

public class DataPumpParser {
    final String DATAPUMP_PARMS = "sqlcl.datapump.parms";
    private static final String EXPORT = "export";
    private static final String IMPORT = "import";
    private static final String HELP = "help";
    private static final String NL = "\n";
    private DataPumpModel _model;

    public DataPumpParser(DataPumpModel model) {
        this._model = model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean parse() throws ProcessFailedException {
        try {
            DataPumpOption opt;
            String value;
            String key;
            ScriptRunnerContext ctx = this._model.getCtx();
            CoreParameterParser.loadParams((String)"sqlcl.datapump.parms", (String)this._model.getSQLCommand().getSql(), (ScriptRunnerContext)ctx, this._model.isSetCommand() ? DataPumpOptions.setSubCommands : DataPumpOptions.subCommands, DataPumpOptions.coreOptions);
            HashMap coreArgs = ctx.getParams("sqlcl.datapump.parms");
            String arg = null;
            for (Map.Entry coreArg : coreArgs.entrySet()) {
                key = (String)coreArg.getKey();
                value = (String)coreArg.getValue();
                arg = DataPumpOptions.getName(key);
                if (key.equalsIgnoreCase("basecommand")) continue;
                if (key.equalsIgnoreCase("command")) {
                    if (!this._model.isSetCommand()) {
                        if (value.equalsIgnoreCase(EXPORT)) {
                            this._model.isExport(true);
                            this._model.getArgs().put("operation", value.toUpperCase());
                            continue;
                        }
                        if (value.equalsIgnoreCase(IMPORT.toUpperCase())) {
                            this._model.isImport(true);
                            this._model.getArgs().put("operation", value);
                            continue;
                        }
                        if (!value.startsWith(HELP)) throw new InvalidParameterException(DataPumpResources.format("DPPAR_INVALID_CMD", value));
                        this._model.getArgs().put(HELP, value.toLowerCase());
                        continue;
                    }
                    if (!value.contains(HELP)) continue;
                    String[] helpVals = value.split(",");
                    Object help = HELP;
                    if (helpVals.length > 2) {
                        if (helpVals[2].equalsIgnoreCase("examples")) {
                            help = (String)help + "examples";
                        } else if (helpVals[2].equalsIgnoreCase("syntax")) {
                            help = (String)help + "syntax";
                        }
                    }
                    this._model.getArgs().put(HELP, help);
                    continue;
                }
                opt = DataPumpOptions.getOption(arg);
                if (opt == null) {
                    throw new InvalidParameterException(DataPumpResources.format("DPPAR_INVALID_OPT", key));
                }
                boolean isValid = opt.isValidValue(value);
                if (!isValid) {
                    if (value != null) throw new InvalidParameterException(DataPumpResources.format("DPPAR_INVALID_OPT_VALUE", arg, value));
                    if (!DataPumpOptions.coreOptions.get(key).equals("StringOrNullValidator")) {
                        throw new InvalidParameterException(DataPumpResources.format("DPPAR_INVALID_OPT_VALUE", arg, value != null ? value : ""));
                    }
                } else if (value == null && DataPumpOptions.coreOptions.get(key).equals("BooleanFlagValidator")) {
                    value = "true";
                }
                if (arg.equalsIgnoreCase(HELP)) continue;
                this._model.getArgs().put(arg, value);
            }
            for (Map.Entry coreArg : coreArgs.entrySet()) {
                key = (String)coreArg.getKey();
                value = (String)coreArg.getValue();
                arg = DataPumpOptions.getName(key);
                if (arg == null || (opt = DataPumpOptions.getOption(arg)) == null) continue;
                DataPumpOption.Operation operation = opt.getOperation();
                if ((!this._model.isExport() || operation != DataPumpOption.Operation.IMPORT) && (!this._model.isImport() || operation != DataPumpOption.Operation.EXPORT)) continue;
                throw new InvalidParameterException(DataPumpResources.format("DPPAR_INVALID_OPT_OPERATION", key, this._model.isExport() ? EXPORT : IMPORT));
            }
            return this._model.isValid();
        }
        catch (InvalidParameterException e) {
            this._model.isValid(false);
            throw new ProcessFailedException((Exception)((Object)e), DataPumpResources.getString("DP_PARSE"));
        }
    }
}

