/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.metadata;

import java.util.List;
import oracle.security.xmlsec.saml2.metadata.AssertionConsumerService;
import oracle.security.xmlsec.saml2.metadata.AttributeConsumingService;
import oracle.security.xmlsec.saml2.metadata.SSODescriptor;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SPSSODescriptor
extends SSODescriptor {
    private static final String[] tagList = new String[]{"Signature", "Extensions", "KeyDescriptor", "Organization", "ContactPerson", "ArtifactResolutionService", "SingleLogoutService", "ManageNameIDService", "NameIDFormat", "AssertionConsumerService", "AttributeConsumingService"};
    private static final String[] nsList = new String[]{"http://www.w3.org/2000/09/xmldsig#", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata"};

    public SPSSODescriptor(Element element) throws DOMException {
        super(element);
    }

    public SPSSODescriptor(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public SPSSODescriptor(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:metadata", "SPSSODescriptor");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:metadata");
    }

    public void setAuthnRequestsSigned(boolean signed) {
        this.setAttribute("AuthnRequestsSigned", String.valueOf(signed));
    }

    public boolean getAuthnRequestsSigned() {
        String str;
        return this.hasAttribute("AuthnRequestsSigned") && ("true".equals(str = this.getAttribute("AuthnRequestsSigned")) || "1".equals(str));
    }

    public void setWantAssertionsSigned(boolean signed) {
        this.setAttribute("WantAssertionsSigned", String.valueOf(signed));
    }

    public boolean getWantAssertionsSigned() {
        String str;
        return this.hasAttribute("WantAssertionsSigned") && ("true".equals(str = this.getAttribute("WantAssertionsSigned")) || "1".equals(str));
    }

    public void addAssertionConsumerService(AssertionConsumerService acs) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)acs, (String[])nsList, (String[])tagList);
    }

    public List getAssertionConsumerServices() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "AssertionConsumerService");
    }

    public void addAttributeConsumingService(AttributeConsumingService acs) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)acs, (String[])nsList, (String[])tagList);
    }

    public List getAttributeConsumingServices() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "AttributeConsumingService");
    }
}

