/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.protocol;

import oracle.security.xmlsec.saml2.core.EncryptedID;
import oracle.security.xmlsec.saml2.core.NameID;
import oracle.security.xmlsec.saml2.core.SAML2NameIdentifier;
import oracle.security.xmlsec.saml2.protocol.NewEncryptedID;
import oracle.security.xmlsec.saml2.protocol.NewID;
import oracle.security.xmlsec.saml2.protocol.RequestAbstract;
import oracle.security.xmlsec.saml2.protocol.Terminate;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ManageNameIDRequest
extends RequestAbstract {
    private static final String[] nsList = new String[]{"urn:oasis:names:tc:SAML:2.0:assertion", "http://www.w3.org/2000/09/xmldsig#", "urn:oasis:names:tc:SAML:2.0:protocol", "urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:protocol", "urn:oasis:names:tc:SAML:2.0:protocol", "urn:oasis:names:tc:SAML:2.0:protocol"};
    private static final String[] tagList = new String[]{"Issuer", "Signature", "Extensions", "NameID", "EncryptedID", "NewID", "NewEncryptedID", "Terminate"};

    public ManageNameIDRequest(Element element) throws DOMException {
        super(element);
    }

    public ManageNameIDRequest(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public ManageNameIDRequest(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:protocol", "ManageNameIDRequest");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:protocol");
    }

    public void setPrincipalNameIdentifier(SAML2NameIdentifier nid) {
        if (nid instanceof NameID || nid instanceof EncryptedID) {
            XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"NameID");
            XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"EncryptedID");
            XMLUtils.insertChild((XMLElement)this, (XMLElement)((XMLElement)nid), (String[])nsList, (String[])tagList);
        }
    }

    public SAML2NameIdentifier getPrincipalNameIdentifier() {
        XMLElement nid = null;
        nid = (NameID)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "NameID");
        if (nid != null) {
            return nid;
        }
        nid = (EncryptedID)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "EncryptedID");
        if (nid != null) {
            return nid;
        }
        return null;
    }

    public void setNewIdentifier(XMLElement obj) {
        if (obj instanceof NewID || obj instanceof NewEncryptedID || obj instanceof Terminate) {
            XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:protocol", (String)"NewID");
            XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:protocol", (String)"NewEncryptedID");
            XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:protocol", (String)"Terminate");
            XMLUtils.insertChild((XMLElement)this, (XMLElement)obj, (String[])nsList, (String[])tagList);
        }
    }

    public XMLElement getNewIdentifier() {
        XMLElement obj = null;
        obj = (NewID)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:protocol", "NewID");
        if (obj != null) {
            return obj;
        }
        obj = (NewEncryptedID)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:protocol", "NewEncryptedID");
        if (obj != null) {
            return obj;
        }
        obj = (Terminate)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:protocol", "Terminate");
        if (obj != null) {
            return obj;
        }
        return null;
    }
}

