/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.protocol;

import java.util.List;
import oracle.security.xmlsec.saml2.core.Assertion;
import oracle.security.xmlsec.saml2.core.EncryptedAssertion;
import oracle.security.xmlsec.saml2.protocol.StatusResponseType;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Response
extends StatusResponseType {
    private static final String[] nsList = new String[]{"urn:oasis:names:tc:SAML:2.0:assertion", "http://www.w3.org/2000/09/xmldsig#", "urn:oasis:names:tc:SAML:2.0:protocol", "urn:oasis:names:tc:SAML:2.0:protocol", "urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:assertion"};
    private static final String[] tagList = new String[]{"Issuer", "Signature", "Extensions", "Status", "Assertion", "EncryptedAssertion"};

    public Response(Element element) throws DOMException {
        super(element);
    }

    public Response(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public Response(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:protocol", "Response");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:protocol");
    }

    public void addAssertion(Assertion assertion) {
        this.appendChild((XMLNode)assertion);
    }

    public void addEncryptedAssertion(EncryptedAssertion encAssertion) {
        this.appendChild((XMLNode)encAssertion);
    }

    public List getAssertions() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
    }

    public List getEncryptedAssertions() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:assertion", "EncryptedAssertion");
    }

    public List getAllAssertions() {
        List a = this.getAssertions();
        List b = this.getEncryptedAssertions();
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        a.addAll(b);
        return a;
    }
}

