/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.breakpoint;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.HoverProvider;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.peek.Peek;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.jdevimpl.debugger.breakpoint.BreakpointHoverBuilder;
import oracle.jdevimpl.debugger.breakpoint.CoreBreakpoint;
import oracle.jdevimpl.debugger.breakpoint.SourceIconRuntimeCallback;
import oracle.jdevimpl.debugger.breakpoint.res.BreakpointArb;

public final class SourceIcon
implements HoverProvider {
    private static SourceIconRuntimeCallback runtimeCallback;
    static HighlightStyle disabledBPStyle;
    static HighlightStyle enabledBPStyle;
    public static HighlightStyle ipStyle;
    static final int TYPE_BREAKPOINT = 0;
    static final int TYPE_WATCHPOINT = 1;
    public static final int TYPE_IP = 2;
    private static final String[] columnNames;
    private static final int[] markOrder;
    private static final int[] markOptions;
    private static Object semaphore;
    private static Map<CodeEditorGutter, CodeEditor> mapGutterToCodeEditor;
    private static List<SourceIcon> shownIcons;
    private final URL workspaceURL;
    private final URL projectURL;
    private final String pkg;
    private final String filename;
    private final URL url;
    private int line;
    private final String className;
    private final String fieldName;
    private final String fqMethodName;
    private final int offset;
    private final Node nodeToMatch;
    private Icon icon;
    private HighlightStyle style;
    private final int type;
    private final CoreBreakpoint breakpoint;
    private Map<CodeEditor, GutterMark<SourceIcon>> gutterMarks;
    private static final Map<String, String> mapStyleToCategory;

    public SourceIcon(URL workspaceURL, URL projectURL, String pkg, String filename, int line, Node nodeToMatch, Icon icon, HighlightStyle style, int type, CoreBreakpoint breakpoint) {
        this.workspaceURL = workspaceURL;
        this.projectURL = projectURL;
        this.pkg = pkg;
        this.filename = filename;
        this.url = null;
        this.line = line;
        this.className = null;
        this.fieldName = null;
        this.fqMethodName = null;
        this.offset = -1;
        this.nodeToMatch = nodeToMatch;
        this.icon = icon;
        this.style = style;
        this.type = type;
        this.breakpoint = breakpoint;
        this.show();
    }

    public SourceIcon(URL workspaceURL, URL projectURL, URL url, int line, Node nodeToMatch, Icon icon, HighlightStyle style, int type, CoreBreakpoint breakpoint) {
        this.workspaceURL = workspaceURL;
        this.projectURL = projectURL;
        this.pkg = null;
        this.filename = null;
        this.url = url;
        this.line = line;
        this.className = null;
        this.fieldName = null;
        this.fqMethodName = null;
        this.offset = -1;
        this.nodeToMatch = nodeToMatch;
        this.icon = icon;
        this.style = style;
        this.type = type;
        this.breakpoint = breakpoint;
        this.show();
    }

    public SourceIcon(URL workspaceURL, URL projectURL, String className, String fieldName, Node nodeToMatch, Icon icon, HighlightStyle style, int type, CoreBreakpoint breakpoint) {
        this.workspaceURL = workspaceURL;
        this.projectURL = projectURL;
        this.pkg = null;
        this.filename = null;
        this.url = null;
        this.line = 0;
        this.className = className;
        this.fieldName = fieldName;
        this.fqMethodName = null;
        this.offset = -1;
        this.nodeToMatch = nodeToMatch;
        this.icon = icon;
        this.style = style;
        this.type = type;
        this.breakpoint = breakpoint;
        this.show();
    }

    public SourceIcon(URL workspaceURL, URL projectURL, String fqMethodName, int offset, Node nodeToMatch, Icon icon, HighlightStyle style, int type, CoreBreakpoint breakpoint) {
        this.workspaceURL = workspaceURL;
        this.projectURL = projectURL;
        this.pkg = null;
        this.filename = null;
        this.url = null;
        this.line = 0;
        this.className = null;
        this.fieldName = null;
        this.fqMethodName = fqMethodName;
        this.offset = offset;
        this.nodeToMatch = nodeToMatch;
        this.icon = icon;
        this.style = style;
        this.type = type;
        this.breakpoint = breakpoint;
        this.show();
    }

    public static void setRuntimeCallback(SourceIconRuntimeCallback runtimeCallback) {
        SourceIcon.runtimeCallback = runtimeCallback;
    }

    public CoreBreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void show() {
        Object object = semaphore;
        synchronized (object) {
            Assert.check((this.gutterMarks == null ? 1 : 0) != 0, (String)"SourceIcon.show called when already showing");
            this.gutterMarks = new HashMap<CodeEditor, GutterMark<SourceIcon>>();
            for (CodeEditorGutter gutter : mapGutterToCodeEditor.keySet()) {
                CodeEditor codeEditor = mapGutterToCodeEditor.get(gutter);
                if (!this.matchesGutter(gutter)) continue;
                this.makeMark(codeEditor, gutter);
            }
            shownIcons.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide() {
        Object object = semaphore;
        synchronized (object) {
            Assert.check((this.gutterMarks != null ? 1 : 0) != 0, (String)"SourceIcon.hide called when already hidden");
            shownIcons.remove(this);
            for (CodeEditor codeEditor : this.gutterMarks.keySet()) {
                GutterMark<SourceIcon> gutterMark = this.gutterMarks.get(codeEditor);
                this.removeMark(codeEditor, gutterMark, false);
            }
            this.gutterMarks.clear();
            this.gutterMarks = null;
        }
    }

    private void removedDuringEdit(CodeEditor codeEditor) {
        this.gutterMarks.remove(codeEditor);
    }

    private void removeMark(CodeEditor codeEditor, GutterMark gutterMark, boolean removeFromMap) {
        gutterMark.getGutterColumn().removeGutterMark(gutterMark);
        if (removeFromMap) {
            this.gutterMarks.remove(codeEditor);
        }
    }

    private void makeMark(CodeEditor codeEditor, CodeEditorGutter gutter) {
        GutterColumn<GutterMark<SourceIcon>> gutterColumn = SourceIcon.createGutterColumn(gutter, this.type);
        int[] lineAndOffset = this.getLineAndOffset(codeEditor);
        int line = lineAndOffset[0];
        int offset = lineAndOffset[1];
        try {
            GutterMark gutterMark = gutterColumn.addGutterMark(line, this.icon, this.style, markOrder[this.type] + offset, markOptions[this.type]);
            if (gutterMark != null) {
                gutterMark.setUserData((Object)this);
                this.gutterMarks.put(codeEditor, (GutterMark<SourceIcon>)gutterMark);
            }
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            // empty catch block
        }
    }

    private static GutterColumn<GutterMark<SourceIcon>> createGutterColumn(CodeEditorGutter gutter, int type) {
        String columnName = columnNames[type];
        GutterColumn gutterColumn = gutter.lookupGutterColumn(columnName);
        if (gutterColumn == null) {
            SourceIconGutterColumnListener gutterColumnListener = new SourceIconGutterColumnListener();
            gutterColumn = gutter.createGutterColumn(columnName, (GutterColumnListener)gutterColumnListener);
            switch (type) {
                default: {
                    throw new IllegalArgumentException("type is invalid");
                }
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    gutterColumn.setLayoutConstraint("lightbulb", 2);
                }
            }
        }
        return gutterColumn;
    }

    public Hover hover(JComponent gutterComponent, Point p, List<HoverFlavor> flavors) {
        if (this.breakpoint == null) {
            return null;
        }
        if (flavors.contains(HoverFlavor.getFlavor((String)"info"))) {
            BreakpointHoverBuilder breakpointHoverBuilder = new BreakpointHoverBuilder(this.breakpoint, this.getCodeEditor(), gutterComponent);
            Peek peek = breakpointHoverBuilder.getPeek();
            return peek;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGutterDestroyed(CodeEditor codeEditor) {
        Object object = semaphore;
        synchronized (object) {
            GutterMark<SourceIcon> gutterMark = this.gutterMarks.get(codeEditor);
            if (gutterMark != null) {
                this.removeMark(codeEditor, gutterMark, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean matchesIconLocation(CodeEditor codeEditor, int line) {
        Object object = semaphore;
        synchronized (object) {
            GutterMark<SourceIcon> gutterMark = this.gutterMarks.get(codeEditor);
            return gutterMark != null && gutterMark.getLine() == line;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeIcon(Icon icon, HighlightStyle style) {
        Object object = semaphore;
        synchronized (object) {
            this.icon = icon;
            this.style = style;
            for (CodeEditor codeEditor : this.gutterMarks.keySet()) {
                CodeEditorGutter gutter = codeEditor.getGutter();
                if (gutter == null || gutter.getEditor() == null) continue;
                GutterMark<SourceIcon> gutterMark = this.gutterMarks.get(codeEditor);
                gutterMark.setIcon(icon);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeEditor getCodeEditor() {
        Object object = semaphore;
        synchronized (object) {
            Iterator<CodeEditor> i;
            if (this.gutterMarks.size() > 0 && (i = this.gutterMarks.keySet().iterator()).hasNext()) {
                return i.next();
            }
            return null;
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent != null && mouseEvent.getSource() instanceof CodeEditorGutter) {
            return null;
        }
        if (this.breakpoint != null) {
            return this.breakpoint.getMarkToolTip(null, mouseEvent);
        }
        if (this.type == 2) {
            return BreakpointArb.getString(21);
        }
        return null;
    }

    public int getLine() {
        return this.line;
    }

    private int[] getLineAndOffset(CodeEditor codeEditor) {
        int[] result = new int[2];
        if (codeEditor != null) {
            int lineFromBytecodeOffset;
            Node node;
            Context context;
            if (this.className != null && this.fieldName != null && (context = codeEditor.getContext()) != null && (node = context.getNode()) != null) {
                JavaField javaField;
                Project jproject = context.getProject();
                if (jproject == null) {
                    jproject = Ide.getActiveProject();
                }
                if (runtimeCallback != null && (javaField = runtimeCallback.getJavaField(jproject, node.getURL(), this.className, this.fieldName)) instanceof SourceElement) {
                    SourceName sourceName;
                    SourceElement sourceField = (SourceElement)javaField;
                    int offset = sourceField.getStartOffset();
                    if (sourceField instanceof SourceHasName && (sourceName = ((SourceHasName)sourceField).getNameElement()) != null) {
                        offset = sourceName.getStartOffset();
                    }
                    result[0] = codeEditor.getLineFromOffset(offset);
                    result[1] = offset - codeEditor.getLineStartOffset(result[0]);
                    return result;
                }
            }
            if (this.fqMethodName != null && (context = codeEditor.getContext()) != null && (node = context.getNode()) != null && runtimeCallback != null && (lineFromBytecodeOffset = runtimeCallback.getLineFromBytecodeOffset(node, this.offset)) != 0) {
                result[0] = lineFromBytecodeOffset;
                result[1] = 0;
                return result;
            }
        }
        result[0] = this.line;
        result[1] = 0;
        return result;
    }

    private boolean matchesGutter(CodeEditorGutter gutter) {
        Context context = gutter.getContext();
        if (context != null) {
            URL gutterWorkspaceURL;
            Workspace gutterWorkspace = context.getWorkspace();
            URL uRL = gutterWorkspaceURL = gutterWorkspace != null ? gutterWorkspace.getURL() : null;
            if (this.workspaceURL == null || gutterWorkspaceURL == null || URLFileSystem.equals((URL)this.workspaceURL, (URL)gutterWorkspaceURL)) {
                Node node;
                URL gutterProjectURL;
                Project gutterProject = context.getProject();
                URL uRL2 = gutterProjectURL = gutterProject != null ? gutterProject.getURL() : null;
                if ((this.projectURL == null || gutterProjectURL == null || URLFileSystem.equals((URL)this.projectURL, (URL)gutterProjectURL)) && (node = context.getNode()) != null) {
                    if (this.nodeToMatch != null) {
                        if (this.nodeToMatch.equals(node)) {
                            return true;
                        }
                    } else {
                        String nodeMethodName;
                        JavaField javaField;
                        if (this.url != null && this.url.equals(node.getURL())) {
                            return true;
                        }
                        Project jproject = gutterProject;
                        if (jproject == null) {
                            jproject = Ide.getActiveProject();
                        }
                        if (this.filename != null) {
                            if (runtimeCallback != null) {
                                return runtimeCallback.fileNameMatchesNode(this.filename, this.pkg, node, jproject);
                            }
                            StringBuilder buf = new StringBuilder();
                            buf.append('/');
                            if (this.pkg != null) {
                                buf.append(this.pkg.replace('\\', '/').replace('.', '/'));
                                buf.append('/');
                            }
                            buf.append(this.filename);
                            URL url = node.getURL();
                            if (url != null) {
                                try {
                                    String path = URLFileSystem.getPath((URL)url);
                                    if (path != null) {
                                        return path.replace('\\', '/').endsWith(buf.toString());
                                    }
                                }
                                catch (Exception e) {
                                    return false;
                                }
                            }
                            return false;
                        }
                        if (this.className != null && runtimeCallback != null && (javaField = runtimeCallback.getJavaField(jproject, node.getURL(), this.className, this.fieldName)) != null) {
                            return true;
                        }
                        if (this.fqMethodName != null && runtimeCallback != null && (nodeMethodName = runtimeCallback.getMethodNameFromBytecode(node)) != null && this.fqMethodName.equals(nodeMethodName)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gutterCreated(CodeEditor codeEditor) {
        Object object = semaphore;
        synchronized (object) {
            CodeEditorGutter gutter = codeEditor.getGutter();
            mapGutterToCodeEditor.put(gutter, codeEditor);
            if (gutter.getEditor() == null && codeEditor.getFocusedEditorPane() != null) {
                gutter.install(codeEditor.getFocusedEditorPane());
            }
            SourceIcon.createGutterColumn(gutter, 0);
            SourceIcon.createGutterColumn(gutter, 1);
            try {
                Context context = codeEditor.getContext();
                if (context != null) {
                    for (int i = shownIcons.size() - 1; i >= 0; --i) {
                        SourceIcon sourceIcon = shownIcons.get(i);
                        if (!sourceIcon.matchesGutter(gutter)) continue;
                        sourceIcon.makeMark(codeEditor, gutter);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gutterDestroyed(CodeEditor codeEditor) {
        Object object = semaphore;
        synchronized (object) {
            try {
                CodeEditorGutter gutter = codeEditor.getGutter();
                if (gutter != null) {
                    mapGutterToCodeEditor.remove(gutter);
                } else {
                    for (CodeEditorGutter g : mapGutterToCodeEditor.keySet()) {
                        CodeEditor editor = mapGutterToCodeEditor.get(g);
                        if (editor != codeEditor) continue;
                        mapGutterToCodeEditor.remove(g);
                    }
                }
                for (int i = shownIcons.size() - 1; i >= 0; --i) {
                    SourceIcon sourceIcon = shownIcons.get(i);
                    sourceIcon.handleGutterDestroyed(codeEditor);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CodeEditor[] getOpenCodeEditors() {
        Object object = semaphore;
        synchronized (object) {
            ArrayList<CodeEditor> temp = new ArrayList<CodeEditor>();
            for (CodeEditor codeEditor : mapGutterToCodeEditor.values()) {
                Context context = codeEditor.getContext();
                if (context == null) continue;
                temp.add(codeEditor);
            }
            return temp.toArray(new CodeEditor[temp.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeColumn(int type) {
        Object object = semaphore;
        synchronized (object) {
            if (!columnNames[type].equals("breakpoint")) {
                for (CodeEditorGutter gutter : mapGutterToCodeEditor.keySet()) {
                    GutterColumn gutterColumn;
                    if (gutter.getEditor() == null || (gutterColumn = gutter.lookupGutterColumn(columnNames[type])) == null) continue;
                    gutter.removeGutterColumn(gutterColumn);
                }
            }
        }
    }

    public static void createHighlightStyles() {
        disabledBPStyle = CodeEditor.createHighlightStyle((String)"disabled-breakpoint", (String)BreakpointArb.getString(22), (int)25, (Color)Color.black, (Color)Color.green);
        enabledBPStyle = CodeEditor.createHighlightStyle((String)"enabled-breakpoint", (String)BreakpointArb.getString(23), (int)30, (Color)Color.white, (Color)Color.red);
        ipStyle = CodeEditor.createHighlightStyle((String)"execution-point", (String)BreakpointArb.getString(24), (int)40, (Color)Color.white, (Color)Color.blue);
        EditorProperties.getProperties().getHighlightRegistry().modifyStylePriority("execution-point", 40);
        int order = 0;
        String ipCategory = order++ + "execution-point";
        mapStyleToCategory.put("execution-point", ipCategory);
        String enabledBPCategory = order++ + "enabled-breakpoint";
        mapStyleToCategory.put("enabled-breakpoint", enabledBPCategory);
        String disabledBPCategory = order + "disabled-breakpoint";
        mapStyleToCategory.put("disabled-breakpoint", disabledBPCategory);
    }

    static {
        columnNames = new String[]{"breakpoint", "watchpoint", "ip"};
        markOrder = new int[]{0, 1000, 7000};
        markOptions = new int[]{5, 7, 6};
        semaphore = new Object();
        mapGutterToCodeEditor = new HashMap<CodeEditorGutter, CodeEditor>();
        shownIcons = new ArrayList<SourceIcon>();
        mapStyleToCategory = new HashMap<String, String>();
    }

    public static class SourceIconGutterColumnListener
    implements GutterColumnListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void markMoved(GutterMark gutterMark, int oldLine, int newLine) {
            Object object = semaphore;
            synchronized (object) {
                SourceIcon sourceIcon = (SourceIcon)gutterMark.getUserData();
                if (sourceIcon.line != 0) {
                    sourceIcon.line = newLine;
                }
                if (sourceIcon.breakpoint != null) {
                    sourceIcon.breakpoint.markMoved(gutterMark, oldLine, newLine);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void markRemoved(GutterMark gutterMark, int deletedLine) {
            Object object = semaphore;
            synchronized (object) {
                SourceIcon sourceIcon = (SourceIcon)gutterMark.getUserData();
                sourceIcon.removedDuringEdit((CodeEditor)mapGutterToCodeEditor.get(gutterMark.getGutter()));
                if (sourceIcon.breakpoint != null) {
                    sourceIcon.breakpoint.markRemoved(gutterMark, deletedLine);
                }
            }
        }

        public void markClicked(GutterMark gutterMark, int clickedLine, MouseEvent event) {
            SourceIcon sourceIcon = (SourceIcon)gutterMark.getUserData();
            if (sourceIcon.breakpoint != null) {
                sourceIcon.breakpoint.markClicked(gutterMark, clickedLine, event);
            }
        }

        public String getMarkToolTip(GutterMark gutterMark, MouseEvent event) {
            SourceIcon sourceIcon = (SourceIcon)gutterMark.getUserData();
            return sourceIcon.getToolTipText(event);
        }
    }
}

