/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.commands;

import java.sql.Connection;
import oracle.dbtools.CpatResources;
import oracle.dbtools.common.CpatArguments;
import oracle.dbtools.common.CpatModel;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.exceptions.ProcessFailedException;
import oracle.dbtools.executors.CpatExecutor;
import oracle.dbtools.executors.CpatPostProcessor;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.generators.CpatPreprocessor;
import oracle.dbtools.generators.HtmlReportGenerator;
import oracle.dbtools.parser.CpatParser;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.raptor.utils.ToolLogger;
import oracle.dbtools.raptor.utils.ToolLoggerResources;
import oracle.dbtools.util.Logger;

public class CpatCommand
extends CommandListener
implements SQLCLService,
IHelp,
Connected {
    private static final String NAME = "Migrate Advisor Command";
    private static final String ADVISE = "advise";
    private static final String INFO = "info";
    private static final String PROPERTIES = "properties";
    private static final String HELP = "help";
    private static final String DQUOTE = "\"";
    private static final String NL = "\n";
    private static final String SPACE = " ";
    private static final String SQUOTE = "'";
    private CpatModel _model;

    public String getCommand() {
        return "MIGRATEADVISOR";
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getExtensionDescription() {
        return NAME;
    }

    public String getExtensionName() {
        return NAME;
    }

    public String getExtensionVersion() {
        return "1";
    }

    public String getHelp() {
        return CpatResources.getString("CP_HELP");
    }

    public boolean isSqlPlus() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String helpArg;
        long start;
        block20: {
            if (!(cmd.getLoweredTrimmedSQL().startsWith("migrateadvisor") || cmd.getLoweredTrimmedSQL().startsWith("ma") || cmd.getLoweredTrimmedSQL().startsWith("miga"))) {
                return false;
            }
            cmd.setSql(SQLPLUS.removeDashNewline((ISQLCommand)cmd, (String)cmd.getSql()));
            start = System.currentTimeMillis();
            CpatArguments args = (CpatArguments)ctx.getProperty("migrate.advisor");
            args = args == null ? new CpatArguments() : args.deepClone();
            this._model = new CpatModel(conn, ctx, cmd, args);
            this._model.getToolLogger().flushLog();
            helpArg = null;
            try {
                CpatParser parser = new CpatParser(this._model);
                parser.parse();
                this._model.getToolLogger().flushLog();
                helpArg = (String)args.get(HELP);
                if (helpArg != null) {
                    if (helpArg.equalsIgnoreCase(HELP)) {
                        this._model.getToolLogger().log(CpatResources.getString("CP_HELP"));
                    } else if (helpArg.endsWith("examples")) {
                        this._model.getToolLogger().log(CpatResources.getString("CP_HELP_EXAMPLES"));
                    } else if (helpArg.endsWith("syntax")) {
                        this._model.getToolLogger().log(CpatResources.getString("CP_HELP_SYNTAX"));
                    } else {
                        this._model.getToolLogger().log(CpatResources.getString("CP_HELP"));
                    }
                    break block20;
                }
                if (this._model.isVerbose() || this._model.isDebug()) {
                    this._model.getToolLogger().logToolStart(CpatResources.getString("CP"));
                }
                if (this._model.isDebug()) {
                    this._model.getToolLogger().log("debug on");
                }
                if (this._model.getConn() != null) {
                    String connName = ConnectionResolver.getConnectionName((Connection)this._model.getConn());
                    CpatPreprocessor preprocessor = new CpatPreprocessor(this._model);
                    if (preprocessor.check()) {
                        this._model.getToolLogger().flushLog();
                        CpatExecutor executor = new CpatExecutor(this._model);
                        boolean isExec = executor.exec();
                        CpatPostProcessor post = new CpatPostProcessor(this._model);
                        post.run();
                        this._model.getToolLogger().flushLog();
                        if (this._model.isDoHtml()) {
                            HtmlReportGenerator gen = new HtmlReportGenerator(this._model);
                            gen.writeReport(this._model.getHtmlReportDir());
                        }
                    }
                    break block20;
                }
                this._model.getToolLogger().logError(CpatResources.getString("CPCMPD_CONN"));
            }
            catch (Exception e) {
                if (e instanceof ProcessFailedException) {
                    Exception e1 = ((ProcessFailedException)e).getOriginalException();
                    this._model.getToolLogger().logError(e1.getLocalizedMessage());
                    break block20;
                }
                this._model.getToolLogger().logException((Throwable)e);
                Logger.warn(((Object)((Object)this)).getClass(), (Throwable)e);
            }
        }
        if (helpArg == null && (this._model.isVerbose() || this._model.isDebug())) {
            this._model.getToolLogger().logToolEnd();
        }
        if (ctx.getTiming()) {
            this._model.getToolLogger().log(ToolLoggerResources.format((String)"TIMINGELAPSEDTOTAL", (Object[])new Object[]{ToolLogger.getElapsedTime((long)start)}) + NL);
        }
        this._model.getToolLogger().flushLog();
        return true;
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public boolean needsConnection() {
        return true;
    }
}

