/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common;

import com.oracle.premigration.commons.enums.ReportFormat;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.CpatResources;
import oracle.dbtools.common.CpatArguments;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.ToolLogger;
import oracle.dbtools.utilities.CpatFileUtils;

public class CpatModel {
    private static final String SPACE = " ";
    private static final String LOG_BASE_NAME = "premigration_advisor.log";
    public static final String REPORT_BASE_NAME = "premigration_advisor_report";
    private static final String PROPS_BASE_NAME = "premigration_advisor_analysis.properties";
    private Connection _conn;
    private String _schema;
    private ScriptRunnerContext _ctx;
    private ISQLCommand _cmd;
    private int _exitCode;
    private CpatArguments _args;
    private ToolLogger _tLogger;
    private String _jsonName;
    private String _jsonLocation;
    private String _htmlName;
    private String _htmlLocation;
    private List<String> _userFileLocations = new ArrayList<String>();
    private final LinkedHashMap<String, String> _workingFileMap = new LinkedHashMap();
    private String _workingPrefix;
    private String _userLogName;
    private String _userPropsName;
    private String _userReportBase;
    private String _workingLogName;
    private String _workingPropsName;
    private String _workingReportBase;
    List<String> _genList = new ArrayList<String>();
    private boolean _isAdvise = false;
    private boolean _isInfo = false;
    private boolean _isProperties = false;
    private boolean _isValid = true;
    private boolean _isDebug = false;
    private boolean _isUserJson = true;
    private boolean _isDoHtml = false;

    public CpatModel(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, CpatArguments args) {
        this._conn = conn;
        this._ctx = ctx;
        this._cmd = cmd;
        this._args = args;
        try {
            this._schema = this._conn.getSchema();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._tLogger = new ToolLogger((OutputStream)ctx.getOutputStream());
    }

    public Connection getConn() {
        return this._conn;
    }

    public ScriptRunnerContext getCtx() {
        return this._ctx;
    }

    public CpatArguments getArgs() {
        return this._args;
    }

    public String getSchema() {
        return this._schema;
    }

    public ISQLCommand getSQLCommand() {
        return this._cmd;
    }

    public ToolLogger getToolLogger() {
        return this._tLogger;
    }

    public String getGen() {
        Object rtn = "";
        for (String str : this._genList) {
            rtn = (String)rtn + str + SPACE;
        }
        return rtn;
    }

    public String[] getGenArray() {
        return this._genList.toArray(new String[0]);
    }

    public List<String> getGenList() {
        return this._genList;
    }

    public void appendGen(String gen) {
        this._genList.add(gen);
    }

    public void isValid(boolean isValid) {
        this._isValid = isValid;
    }

    public boolean isValid() {
        return this._isValid;
    }

    public void isAdvise(boolean isAdvise) {
        this._isAdvise = isAdvise;
    }

    public boolean isAdvise() {
        return this._isAdvise;
    }

    public void isInfo(boolean isInfo) {
        this._isInfo = isInfo;
    }

    public boolean isInfo() {
        return this._isInfo;
    }

    public void isProperties(boolean isProperties) {
        this._isProperties = isProperties;
    }

    public boolean isProperties() {
        return this._isProperties;
    }

    public String getOperationName() {
        if (this.isAdvise()) {
            return "advise";
        }
        if (this.isInfo()) {
            return "info";
        }
        if (this.isProperties()) {
            return "properties";
        }
        return "";
    }

    public boolean isDebug() {
        return this.isArgTrue("debug");
    }

    public boolean isVerbose() {
        return this.isArgTrue("verbose");
    }

    public int getExitCode() {
        return this._exitCode;
    }

    public void setExitCode(int exitCode) {
        this._exitCode = exitCode;
    }

    public boolean isArgTrue(String arg) {
        String value = (String)this._args.get(arg);
        if (value == null) {
            return this._args.containsKey(arg);
        }
        return value.equalsIgnoreCase("TRUE") || value.equalsIgnoreCase("T") || value.isEmpty();
    }

    public boolean isDoHtml() {
        return this._isDoHtml;
    }

    public void isDoHtml(boolean isDoHtml) {
        this._isDoHtml = isDoHtml;
    }

    public String getWorkingPrefix() {
        return this._workingPrefix;
    }

    public boolean isUserJson() {
        return this._isUserJson;
    }

    public void isUserJson(boolean isUser) {
        this._isUserJson = isUser;
    }

    public String getJsonLocation() {
        if (this._jsonLocation == null) {
            this.initLocations();
            this._jsonLocation = CpatFileUtils.getUniqueFileName(this._userReportBase + ".json");
        }
        return this._jsonLocation;
    }

    public Path getHtmlReportDir() {
        if (this._htmlLocation == null) {
            this.initLocations();
            this._htmlLocation = CpatFileUtils.getUniqueDirName(this._userReportBase);
        }
        return Path.of(this._htmlLocation, new String[0]);
    }

    public File getJsonFile() {
        return new File(this.getJsonLocation());
    }

    public void deleteJsonFile() throws IOException {
        File jsonFile;
        if (this.isAdvise() && !this.isUserJson() && (jsonFile = this.getJsonFile()).exists()) {
            this.getJsonFile().delete();
        }
    }

    public List<String> getUserFileLocations() {
        if (this._userFileLocations.isEmpty()) {
            this.initLocations();
            this._userFileLocations = new ArrayList<String>();
            Object fileName = null;
            Object ext = null;
            if (this.isAdvise()) {
                List reports = (List)this._args.get("reportformat");
                for (String report : reports) {
                    fileName = null;
                    if (report.equals(ReportFormat.JSON.toString())) {
                        fileName = this.getJsonLocation();
                        ext = ".json";
                        this._userFileLocations.add((String)fileName);
                    } else if (report.equals(ReportFormat.TEXT.toString())) {
                        ext = ".txt";
                        fileName = CpatFileUtils.getUniqueFileName(this._userReportBase + (String)ext);
                        this._userFileLocations.add((String)fileName);
                    } else {
                        ext = "." + report.toLowerCase();
                        fileName = CpatFileUtils.getUniqueFileName(this._userReportBase + (String)ext);
                        this._userFileLocations.add((String)fileName);
                    }
                    this._workingFileMap.put(this._workingReportBase + (String)ext, (String)fileName);
                }
                if (this.isDoHtml()) {
                    fileName = this.getHtmlReportDir() + File.separator + "premigration_advisor_report.html";
                    this._userFileLocations.add((String)fileName);
                }
            } else if (this.isProperties()) {
                String report = "PROPS";
                fileName = CpatFileUtils.getUniqueFileName(this._userPropsName);
                this._userFileLocations.add((String)fileName);
                this._workingFileMap.put(this._workingPropsName, (String)fileName);
            }
            if (!this.isInfo()) {
                fileName = CpatFileUtils.getUniqueFileName(this._userLogName);
                this._userFileLocations.add((String)fileName);
                this._workingFileMap.put(this._workingLogName, (String)fileName);
            }
        }
        return this._userFileLocations;
    }

    public void renameUserFileLocations() {
        if (!this.getUserFileLocations().isEmpty()) {
            for (Map.Entry<String, String> entry : this._workingFileMap.entrySet()) {
                try {
                    new File(entry.getKey()).renameTo(new File(entry.getValue()));
                }
                catch (Exception e) {
                    this._tLogger.logError(CpatResources.format("CPMOD_FILE_NOT_RENAME", entry.getKey(), entry.getValue()));
                }
            }
        }
    }

    private void initLocations() {
        if (this._workingPrefix == null) {
            this._workingPrefix = "T" + System.currentTimeMillis();
            Object prefix = (String)this._args.get("outfileprefix");
            prefix = prefix == null ? "" : (String)prefix + "_";
            Object dir = (String)this._args.get("outdir");
            dir = dir != null ? (((String)dir).endsWith(File.separator) ? dir : (String)dir + File.separator) : "";
            this._userLogName = (String)dir + (String)prefix + LOG_BASE_NAME;
            this._userPropsName = (String)dir + (String)prefix + PROPS_BASE_NAME;
            this._userReportBase = (String)dir + (String)prefix + REPORT_BASE_NAME;
            this._workingLogName = (String)dir + this._workingPrefix + "_premigration_advisor.log";
            this._workingPropsName = (String)dir + this._workingPrefix + "_premigration_advisor_analysis.properties";
            this._workingReportBase = (String)dir + this._workingPrefix + "_premigration_advisor_report";
        }
    }
}

