/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.common.CpatOption;

public class CpatOptions {
    public static final String ADVISE = "advise";
    public static final String ANALYSISPROPS = "analysisprops";
    public static final String ANALYSISPROPS_S = "a";
    public static final String CPAT = "cpat";
    public static final String CPAT_S = "cp";
    public static final String INFO = "info";
    public static final String DEBUG = "debug";
    public static final String DEBUG_S = "de";
    public static final String ERRLOG = "errlog";
    public static final String ERRLOG_S = "e";
    public static final String EXAMPLES = "examples";
    public static final String EXCLUDESCHEMAS = "excludeschemas";
    public static final String EXCLUDESCHEMAS_S = "x";
    public static final String FULL = "full";
    public static final String FULL_S = "f";
    public static final String HELP = "help";
    public static final String LOG = "log";
    public static final String LOG_S = "l";
    public static final String MAXRELEVANTOBJECTS = "maxrelevantobjects";
    public static final String MAXRELEVANTOBJECTS_S = "m";
    public static final String MAXTEXTDATAROWS = "maxtextdatarows";
    public static final String MAXTEXTDATAROWS_S = "d";
    public static final String MIGRATIONMETHOD = "migrationmethod";
    public static final String MIGRATIONMETHOD_S = "mm";
    public static final String NOEXEC = "noexec";
    public static final String NOEXEC_S = "ne";
    public static final String OUTDIR = "outdir";
    public static final String OUTDIR_S = "o";
    public static final String OUTFILEPREFIX = "outfileprefix";
    public static final String OUTFILEPREFIX_S = "p";
    public static final String OPERATION = "operation";
    public static final String PROPERTIES = "properties";
    public static final String REPORTFORMAT = "reportformat";
    public static final String REPORTFORMAT_S = "r";
    public static final String SCHEMAS = "schemas";
    public static final String SCHEMAS_S = "s";
    public static final String SQLTEXT = "sqltext";
    public static final String SQLTEXT_S = "q";
    public static final String TARGETTYPE = "targettype";
    public static final String TARGETTYPE_S = "t";
    public static final String SYNTAX = "syntax";
    public static final String VERBOSE = "verbose";
    public static final String VERBOSE_S = "ve";
    public static final String VERSION = "version";
    public static final String VERSION_S = "v";
    public static final String GEN_BOOL_FALSE = "s";
    public static final String GEN_BOOL_TRUE = "t";
    public static final ArrayList<String> subCommands = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(CpatOptions.EXAMPLES);
            this.add(CpatOptions.ADVISE);
            this.add(CpatOptions.HELP);
            this.add(CpatOptions.INFO);
            this.add(CpatOptions.PROPERTIES);
            this.add(CpatOptions.SYNTAX);
        }
    };
    public static final HashMap<String, String> coreOptions = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(CpatOptions.ANALYSISPROPS, "StringValidator");
            this.put(CpatOptions.ANALYSISPROPS_S, "StringValidator");
            this.put(CpatOptions.DEBUG, "BooleanFlagValidator");
            this.put(CpatOptions.DEBUG_S, "BooleanFlagValidator");
            this.put(CpatOptions.ERRLOG, "BooleanFlagValidator");
            this.put(CpatOptions.ERRLOG_S, "BooleanFlagValidator");
            this.put(CpatOptions.EXCLUDESCHEMAS, "StringListValidator");
            this.put(CpatOptions.EXCLUDESCHEMAS_S, "StringListValidator");
            this.put(CpatOptions.FULL, "BooleanFlagValidator");
            this.put(CpatOptions.FULL_S, "BooleanFlagValidator");
            this.put(CpatOptions.LOG, "BooleanFlagValidator");
            this.put(CpatOptions.LOG_S, "BooleanFlagValidator");
            this.put(CpatOptions.MAXRELEVANTOBJECTS, "IntegerValidator");
            this.put(CpatOptions.MAXRELEVANTOBJECTS_S, "IntegerValidator");
            this.put(CpatOptions.MAXTEXTDATAROWS, "IntegerValidator");
            this.put(CpatOptions.MAXTEXTDATAROWS_S, "IntegerValidator");
            this.put(CpatOptions.MIGRATIONMETHOD, "StringListValidator");
            this.put(CpatOptions.MIGRATIONMETHOD_S, "StringListValidator");
            this.put(CpatOptions.NOEXEC, "BooleanFlagValidator");
            this.put(CpatOptions.NOEXEC_S, "BooleanFlagValidator");
            this.put(CpatOptions.HELP, "NullValidator");
            this.put(CpatOptions.OUTDIR, "StringValidator");
            this.put(CpatOptions.OUTDIR_S, "StringValidator");
            this.put(CpatOptions.OUTFILEPREFIX, "StringValidator");
            this.put(CpatOptions.OUTFILEPREFIX_S, "StringValidator");
            this.put(CpatOptions.REPORTFORMAT, "StringListValidator");
            this.put(CpatOptions.REPORTFORMAT_S, "StringListValidator");
            this.put(CpatOptions.SCHEMAS, "StringListValidator");
            this.put("s", "StringListValidator");
            this.put(CpatOptions.SQLTEXT, "BooleanFlagValidator");
            this.put(CpatOptions.SQLTEXT_S, "BooleanFlagValidator");
            this.put(CpatOptions.TARGETTYPE, "StringValidator");
            this.put("t", "StringValidator");
            this.put(CpatOptions.VERBOSE, "BooleanFlagValidator");
            this.put(CpatOptions.VERBOSE_S, "BooleanFlagValidator");
            this.put(CpatOptions.VERSION, "BooleanFlagValidator");
            this.put(CpatOptions.VERSION_S, "BooleanFlagValidator");
        }
    };
    public static final HashMap<String, CpatOption> options = new HashMap<String, CpatOption>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(CpatOptions.ANALYSISPROPS, new CpatOption(CpatOption.Operation.ADVISE, CpatOption.SubProgram.UNKNOWN, "--analysisprops", CpatOption.ParameterType.STRING));
            this.put(CpatOptions.DEBUG, new CpatOption(CpatOption.Operation.COMMON, CpatOption.SubProgram.UNKNOWN, null, CpatOption.ParameterType.BOOLEAN));
            this.put(CpatOptions.ERRLOG, new CpatOption(CpatOption.Operation.COMMON, CpatOption.SubProgram.UNKNOWN, null, CpatOption.ParameterType.BOOLEAN));
            this.put(CpatOptions.EXCLUDESCHEMAS, new CpatOption(CpatOption.Operation.ADVISE, CpatOption.SubProgram.UNKNOWN, "--excludeschemas", CpatOption.ParameterType.STRINGLIST));
            this.put(CpatOptions.FULL, new CpatOption(CpatOption.Operation.ADVISE, CpatOption.SubProgram.UNKNOWN, "--full", CpatOption.ParameterType.BOOLEAN));
            this.put(CpatOptions.HELP, new CpatOption(CpatOption.Operation.COMMON, CpatOption.SubProgram.UNKNOWN, null, CpatOption.ParameterType.BOOLEAN));
            this.put(CpatOptions.LOG, new CpatOption(CpatOption.Operation.COMMON, CpatOption.SubProgram.UNKNOWN, null, CpatOption.ParameterType.BOOLEAN));
            this.put(CpatOptions.MAXRELEVANTOBJECTS, new CpatOption(CpatOption.Operation.ADVISE, CpatOption.SubProgram.UNKNOWN, "--maxrelevantobjects", CpatOption.ParameterType.STRING));
            this.put(CpatOptions.MAXTEXTDATAROWS, new CpatOption(CpatOption.Operation.ADVISE, CpatOption.SubProgram.UNKNOWN, "--maxtextdatarows", CpatOption.ParameterType.STRING));
            this.put(CpatOptions.MIGRATIONMETHOD, new CpatOption(CpatOption.Operation.ADVISE, CpatOption.SubProgram.UNKNOWN, "--migrationmethod", CpatOption.ParameterType.STRINGLIST));
            this.put(CpatOptions.NOEXEC, new CpatOption(CpatOption.Operation.COMMON, CpatOption.SubProgram.UNKNOWN, null, CpatOption.ParameterType.BOOLEAN));
            this.put(CpatOptions.OPERATION, new CpatOption(CpatOption.Operation.COMMON, CpatOption.SubProgram.UNKNOWN, null, CpatOption.ParameterType.STRING));
            this.put(CpatOptions.OUTDIR, new CpatOption(CpatOption.Operation.ANAPROP, CpatOption.SubProgram.UNKNOWN, "--outdir", CpatOption.ParameterType.STRING));
            this.put(CpatOptions.OUTFILEPREFIX, new CpatOption(CpatOption.Operation.ANAPROP, CpatOption.SubProgram.UNKNOWN, "--outfileprefix", CpatOption.ParameterType.STRING));
            this.put(CpatOptions.REPORTFORMAT, new CpatOption(CpatOption.Operation.ADVISE, CpatOption.SubProgram.UNKNOWN, "--reportformat", CpatOption.ParameterType.STRINGLIST));
            this.put(CpatOptions.SCHEMAS, new CpatOption(CpatOption.Operation.ADVISE, CpatOption.SubProgram.UNKNOWN, "--schemas", CpatOption.ParameterType.STRINGLIST));
            this.put(CpatOptions.SQLTEXT, new CpatOption(CpatOption.Operation.ADVISE, CpatOption.SubProgram.UNKNOWN, "--sqltext", CpatOption.ParameterType.BOOLEAN));
            this.put(CpatOptions.TARGETTYPE, new CpatOption(CpatOption.Operation.ADVISE, CpatOption.SubProgram.UNKNOWN, "--targetcloud", CpatOption.ParameterType.STRING, null, TargetCloud.class));
            this.put(CpatOptions.VERBOSE, new CpatOption(CpatOption.Operation.COMMON, CpatOption.SubProgram.UNKNOWN, null, CpatOption.ParameterType.BOOLEAN));
            this.put(CpatOptions.VERSION, new CpatOption(CpatOption.Operation.INFO, CpatOption.SubProgram.UNKNOWN, null, CpatOption.ParameterType.BOOLEAN));
        }
    };
    public static final HashMap<String, String> aliases = new HashMap<String, String>(){
        {
            this.put(CpatOptions.ANALYSISPROPS_S, CpatOptions.ANALYSISPROPS);
            this.put(CpatOptions.DEBUG_S, CpatOptions.DEBUG);
            this.put(CpatOptions.ERRLOG_S, CpatOptions.ERRLOG);
            this.put(CpatOptions.EXCLUDESCHEMAS_S, CpatOptions.EXCLUDESCHEMAS);
            this.put(CpatOptions.FULL_S, CpatOptions.FULL);
            this.put(CpatOptions.LOG_S, CpatOptions.LOG);
            this.put(CpatOptions.MAXTEXTDATAROWS_S, CpatOptions.MAXTEXTDATAROWS);
            this.put(CpatOptions.MAXRELEVANTOBJECTS_S, CpatOptions.MAXRELEVANTOBJECTS);
            this.put(CpatOptions.MIGRATIONMETHOD_S, CpatOptions.MIGRATIONMETHOD);
            this.put(CpatOptions.NOEXEC_S, CpatOptions.NOEXEC);
            this.put(CpatOptions.OUTDIR_S, CpatOptions.OUTDIR);
            this.put(CpatOptions.OUTFILEPREFIX_S, CpatOptions.OUTFILEPREFIX);
            this.put(CpatOptions.REPORTFORMAT_S, CpatOptions.REPORTFORMAT);
            this.put("s", CpatOptions.SCHEMAS);
            this.put(CpatOptions.SQLTEXT_S, CpatOptions.SQLTEXT);
            this.put("t", CpatOptions.TARGETTYPE);
            this.put(CpatOptions.VERBOSE_S, CpatOptions.VERBOSE);
            this.put(CpatOptions.VERSION_S, CpatOptions.VERSION);
        }
    };

    public static void setArgumentDefaults(Map<String, Object> args) {
        args.put(DEBUG, "FALSE");
        args.put(MIGRATIONMETHOD, MigrationMethod.DATAPUMP.toString());
        args.put(REPORTFORMAT, REPORTFORMAT_VALUES.HTML.toString());
        args.put(VERBOSE, "FALSE");
    }

    public static CpatOption getOption(String key) {
        String aKey;
        String lKey = key.toLowerCase();
        CpatOption opt = options.get(lKey);
        if (opt == null && (aKey = aliases.get(lKey)) != null) {
            return options.get(aKey);
        }
        return opt;
    }

    public static String getName(String nameOrAlias) {
        if (options.get(nameOrAlias) != null) {
            return nameOrAlias;
        }
        return aliases.get(nameOrAlias);
    }

    public static Map<String, CpatOption> getOptions() {
        return options;
    }

    public static Map<String, CpatOption> getOptions(CpatOption.Operation operation) {
        HashMap<String, CpatOption> opts = new HashMap<String, CpatOption>();
        for (Map.Entry<String, CpatOption> entry : options.entrySet()) {
            CpatOption opt = entry.getValue();
            if (opt.getOperation() != operation && opt.getOperation() != CpatOption.Operation.ANAPROP) continue;
            opts.put(entry.getKey(), entry.getValue());
        }
        return opts;
    }

    public static Map<String, CpatOption> getOptions(CpatOption.Operation operation, CpatOption.SubProgram subProgram) {
        HashMap<String, CpatOption> opts = new HashMap<String, CpatOption>();
        for (Map.Entry<String, CpatOption> entry : options.entrySet()) {
            CpatOption opt = entry.getValue();
            if (opt.getSubProgram() != subProgram || opt.getOperation() != operation && opt.getOperation() != CpatOption.Operation.ANAPROP) continue;
            opts.put(entry.getKey(), entry.getValue());
        }
        return opts;
    }

    public static boolean isOperationOption(CpatOption.Operation operation, CpatOption opt) {
        CpatOption.Operation op = opt.getOperation();
        if (operation == op) {
            return true;
        }
        return (operation == CpatOption.Operation.ADVISE || operation == CpatOption.Operation.PROPERTIES) && op == CpatOption.Operation.ANAPROP;
    }

    public static Map<String, CpatOption> getGenBooleanOptions() {
        HashMap<String, CpatOption> opts = new HashMap<String, CpatOption>();
        for (Map.Entry<String, CpatOption> entry : options.entrySet()) {
            CpatOption opt = entry.getValue();
            if (opt.getGenBoolean() == null) continue;
            opts.put(entry.getKey(), entry.getValue());
        }
        return opts;
    }

    public static enum REPORTFORMAT_VALUES {
        HTML;

    }
}

