/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.generators;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.ReportFormat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.dbtools.CpatResources;
import oracle.dbtools.common.CpatArguments;
import oracle.dbtools.common.CpatModel;
import oracle.dbtools.common.CpatOption;
import oracle.dbtools.common.CpatOptions;
import oracle.dbtools.common.CpatQuery;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.utilities.CpatFileUtils;

public class CpatPreprocessor {
    private static final String DQ = "\"";
    private static final String SQ = "'";
    private static final String NL = "\n";
    private CpatModel _model;
    private CpatArguments _args;

    public CpatPreprocessor(CpatModel model) {
        this._model = model;
        this._args = this._model.getArgs();
    }

    public boolean check() {
        if (this._model.isVerbose() || this._model.isDebug()) {
            this._model.getToolLogger().logProcessStart(CpatResources.getString("CP_PREPROCESS"));
        }
        if (this.validateRequiredArguments() && this.validateConflictingArguments() && this.checkArgumentValues()) {
            this.checkAccess();
        }
        this.handleArgConversions();
        return this._model.isValid();
    }

    public boolean validateRequiredArguments() {
        if (!(this._model.isAdvise() || this._model.isInfo() || this._model.isProperties())) {
            this._model.isValid(false);
            this._model.getToolLogger().logError(CpatResources.getString("CPPRE_OPERATION"));
        }
        if (this._model.isAdvise() && (String)this._args.get("targettype") == null) {
            this._model.isValid(false);
            this._model.getToolLogger().logError(CpatResources.getString("CPPRE_TARGET_TYPE_ERR"));
        }
        return this._model.isValid();
    }

    public boolean validateConflictingArguments() {
        String schemasArg = (String)this._args.get("schemas");
        String xschemasArg = (String)this._args.get("excludeschemas");
        if ((String)this._args.get("schemas") != null && (String)this._args.get("excludeschemas") != null) {
            this._model.getToolLogger().logError(CpatResources.format("CPPRE_OPTS_CONFLICT", "schemas", "excludeschemas"));
            this._model.isValid(false);
        }
        return this._model.isValid();
    }

    public boolean checkArgumentValues() {
        return this._model.isValid();
    }

    public boolean checkAccess() {
        if (this._model.isAdvise()) {
            this.handleSchemas("schemas");
            this.handleSchemas("excludeschemas");
            this.handleDir("outdir");
            this.handlePrefix("outfileprefix");
            this.handleProperties("analysisprops");
            this.handleMigrationMethod("migrationmethod");
            this.handleReportFormat("reportformat");
            this.handleMaxTextDataRows("maxtextdatarows");
        } else if (this._model.isProperties()) {
            this.handleDir("outdir");
            this.handlePrefix("outfileprefix");
        }
        if (this._model.isValid()) {
            List<String> reports = this._model.getUserFileLocations();
            if (this._model.isVerbose() || this._model.isDebug()) {
                for (String report : reports) {
                    this._model.getToolLogger().log("User File: " + report);
                }
            }
        }
        return this._model.isValid();
    }

    private ArrayList<String> handleListArg(String option) {
        return this.handleListArg(option, false);
    }

    private void handleDir(String optName) {
        String dir = (String)this._args.get(optName);
        String cdDir = (String)this._model.getCtx().getProperty("script.runner.cd_command");
        Path path = null;
        if (dir == null) {
            dir = cdDir;
            if (dir != null) {
                path = Paths.get(dir, new String[0]);
                if (!Files.exists(path, new LinkOption[0])) {
                    this._model.getToolLogger().logError(CpatResources.format("CPPRE_CD_NOT_EXIST", path.toString()));
                    this._model.isValid(false);
                } else if (!Files.isDirectory(path, new LinkOption[0])) {
                    this._model.getToolLogger().logError(CpatResources.format("CPPRE_CD_NOT_DIRECTORY", path.toString()));
                    this._model.isValid(false);
                } else if (!Files.isWritable(path)) {
                    this._model.getToolLogger().logError(CpatResources.format("CPPRE_CD_NOT_WRITABLE", path.toString()));
                    this._model.isValid(false);
                } else {
                    this._args.put(optName, dir);
                }
            } else {
                this._args.put(optName, new File("").getAbsolutePath());
            }
        } else {
            path = Paths.get(dir, new String[0]);
            if (!path.isAbsolute()) {
                path = cdDir != null ? CpatFileUtils.concatDir(cdDir, dir) : CpatFileUtils.concatDir(new File("").getAbsolutePath(), dir);
            }
            if (Files.exists(path, new LinkOption[0])) {
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    this._model.getToolLogger().logError(CpatResources.format("CPPRE_OUTDIR_NOT_DIRECTORY", path.toString()));
                    this._model.isValid(false);
                }
                if (!Files.isWritable(path)) {
                    this._model.getToolLogger().logError(CpatResources.format("CPPRE_OUTDIR_NOT_DIRECTORY", path.toString()));
                    this._model.isValid(false);
                }
            } else {
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                    if (!Files.isWritable(path)) {
                        this._model.getToolLogger().logError(CpatResources.format("CPPRE_OUTDIR_NOT_WRITABLE", path.toString()));
                        this._model.isValid(false);
                    }
                }
                catch (IOException e) {
                    this._model.getToolLogger().logError(CpatResources.format("CPPRE_OUTDIR_NOT_CREATE", path.toString()));
                    this._model.isValid(false);
                }
            }
            this._args.put(optName, path.toString());
        }
    }

    private ArrayList<String> handleListArg(String option, boolean isUnquote) {
        String listArg = (String)this._args.get(option);
        try {
            if (listArg != null && !listArg.isEmpty()) {
                ArrayList<String> list = new ArrayList<String>();
                String[] objects = this.utilSplit(listArg, ",");
                if (objects != null) {
                    for (String object : objects) {
                        list.add(isUnquote ? this.unquote(object) : object);
                    }
                }
                this._args.put(option, list);
                return list;
            }
        }
        catch (Exception e) {
            this._model.getToolLogger().logException((Throwable)e);
            this._model.isValid(false);
        }
        return null;
    }

    private ArrayList<String> handleListSetArg(String option) {
        String listArg = (String)this._args.get(option);
        try {
            if (listArg != null && !listArg.isEmpty()) {
                ArrayList<String> list = new ArrayList<String>();
                String[] sets = this.utilSplit(listArg, ";");
                if (sets != null) {
                    for (String set : sets) {
                        String[] objects = this.utilSplit(set, ",");
                        if (objects == null) continue;
                        for (String object : objects) {
                            list.add(object);
                        }
                    }
                }
                this._args.put(option, list);
                return list;
            }
        }
        catch (Exception e) {
            this._model.getToolLogger().logException((Throwable)e);
            this._model.isValid(false);
        }
        return null;
    }

    private void handleMaxTextDataRows(String optName) {
        List<String> reports = this._args.getList("reportformat");
        Integer maxText = this._args.getInteger(optName);
        Integer maxRel = this._args.getInteger("maxrelevantobjects");
        if (maxText != null) {
            if (!reports.contains(ReportFormat.TEXT.toString())) {
                this._model.getToolLogger().logError(CpatResources.getString("CPPRE_CPAT1009"));
                this._model.isValid(false);
            }
            if (maxRel != null && maxText > maxRel) {
                this._model.getToolLogger().logWarning(CpatResources.getString("CPPRE_CPAT1012"));
                this._args.put(optName, maxRel);
            }
        }
    }

    private void handleMigrationMethod(String optName) {
        this._args.put(optName, ((String)this._args.get(optName)).toUpperCase());
        ArrayList<String> listArg = this.handleListArg(optName);
        if (listArg != null || !listArg.isEmpty()) {
            for (String value : listArg) {
                if (CpatOption.getEnumFromString(MigrationMethod.class, value) != null) continue;
                this._model.getToolLogger().logError(CpatResources.format("CPPRE_INVALID_VALUE", value));
                this._model.isValid(false);
            }
        }
        if (listArg.contains(MigrationMethod.DATAPUMP.toString()) && listArg.contains(MigrationMethod.DATAPUMP_DBLINK.toString())) {
            this._model.getToolLogger().logWarning(CpatResources.getString("CPPRE_CPAT1010"));
            listArg.remove(MigrationMethod.DATAPUMP.toString());
        }
    }

    private void handlePrefix(String optName) {
        String prefix = this.unquote(this._args.getString(optName));
        if (!(prefix == null || Pattern.matches("^[-_\\.A-Za-z0-9]+$", prefix) && !prefix.equals("") && Character.isAlphabetic(prefix.charAt(0)))) {
            this._model.getToolLogger().logError(CpatResources.getString("CPPRE_CPAT1011"));
            this._model.isValid(false);
        }
        this._args.put(optName, prefix);
    }

    private void handleProperties(String optName) {
        String propFileStr = (String)this._args.get(optName);
        if (propFileStr != null) {
            String cdDir;
            Path path = null;
            File propFile = null;
            try {
                path = Paths.get(propFileStr, new String[0]);
                propFile = path.toFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (path != null && !path.isAbsolute() && (cdDir = (String)this._model.getCtx().getProperty("script.runner.cd_command")) != null) {
                String prepend = this._model.getCtx().prependCD(propFileStr);
                if (prepend != null) {
                    propFile = new File(prepend);
                } else {
                    this._model.getToolLogger().logError(CpatResources.format("CPPRE_PROPS_FILE_NOT_VALID", propFileStr));
                    this._model.isValid(false);
                    return;
                }
            }
            if (propFile != null) {
                if (!propFile.exists()) {
                    this._model.getToolLogger().logError(CpatResources.format("CPPRE_PROP_FILE_NOT_EXIST", propFile.getAbsolutePath()));
                    this._model.isValid(false);
                } else if (!propFile.isFile()) {
                    this._model.getToolLogger().logError(CpatResources.format("CPPRE_PROP_FILE_NOT_FILE", propFile.getAbsolutePath()));
                    this._model.isValid(false);
                } else if (!propFile.canRead()) {
                    this._model.getToolLogger().logError(CpatResources.format("CPPRE_PROP_FILE_NOT_READABLE", propFile.getAbsolutePath()));
                    this._model.isValid(false);
                } else {
                    this._args.put(optName, propFile.getPath());
                }
            }
        }
    }

    private void handleReportFormat(String optName) {
        this._args.put(optName, ((String)this._args.get(optName)).toUpperCase());
        ArrayList<String> listArg = this.handleListArg(optName);
        if (listArg != null || !listArg.isEmpty()) {
            for (String value : listArg) {
                if (CpatOption.getEnumFromString(CpatOptions.REPORTFORMAT_VALUES.class, value) != null || CpatOption.getEnumFromString(ReportFormat.class, value) != null) continue;
                this._model.getToolLogger().logError(CpatResources.format("CPPRE_INVALID_VALUE", value));
                this._model.isValid(false);
            }
            if (!listArg.contains(ReportFormat.JSON.toString())) {
                listArg.add(ReportFormat.JSON.toString());
                this._model.isUserJson(false);
            }
            if (listArg.contains(CpatOptions.REPORTFORMAT_VALUES.HTML.toString())) {
                listArg.remove(CpatOptions.REPORTFORMAT_VALUES.HTML.toString());
                this._model.isDoHtml(true);
            }
            this._args.put("reportformat", listArg);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(ReportFormat.JSON.toString());
            this._args.put("reportformat", list);
            this._model.isUserJson(false);
            this._model.isDoHtml(true);
        }
    }

    private void handleSchemas(String optName) {
        String schemasArg = (String)this._args.get(optName);
        ArrayList<String> schemasList = new ArrayList<String>();
        try {
            if (schemasArg != null) {
                String[] schemas = this.utilSplit(schemasArg, ",");
                if (schemas != null) {
                    for (String schema : schemas) {
                        String cleanName = this.cleanName(schema);
                        if (!this.existsSchema(cleanName)) {
                            this._model.getToolLogger().logError(CpatResources.format("CPPRE_INVALID_SCHEMA", schema));
                            this._model.isValid(false);
                        } else if (!this.assertName(schema)) {
                            this._model.getToolLogger().logError(CpatResources.format("CPPRE_INVALID_SCHEMA_NAME", schema));
                            this._model.isValid(false);
                        }
                        schemasList.add(cleanName);
                    }
                }
                this._args.put(optName, schemasList);
            } else {
                this._args.put(optName, new ArrayList());
            }
        }
        catch (Exception e) {
            this._model.getToolLogger().logException((Throwable)e);
            this._model.isValid(false);
        }
    }

    private boolean canCreateIn(File dir) {
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("cpat", ".tmp", dir);
            FileOutputStream tmpStream = new FileOutputStream(tmpFile);
            tmpStream.write(1);
            tmpStream.close();
            tmpFile.delete();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void handleArgConversions() {
        Map<String, CpatOption> options = CpatOptions.getGenBooleanOptions();
        for (Map.Entry<String, CpatOption> entry : options.entrySet()) {
            CpatOption opt = entry.getValue();
            String key = entry.getKey();
            if (opt.getGenBoolean().equals("t")) {
                if (this._model.isArgTrue(key)) continue;
                this._args.remove(key);
                continue;
            }
            if (!this._model.isArgTrue(key)) continue;
            this._args.remove(key);
        }
    }

    private String cleanName(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        if (name.startsWith(DQ) && name.endsWith(DQ)) {
            return name.substring(1, name.length() - 1);
        }
        return name.toUpperCase();
    }

    private String cleanObjectType(String type) {
        if (type.startsWith(DQ) && type.endsWith(DQ) && type.length() > 1) {
            return type.substring(1, type.length() - 1).toUpperCase();
        }
        return type;
    }

    private String unquote(String string) {
        if (string != null && !string.isEmpty() && string.startsWith(DQ) && string.endsWith(DQ) && string.length() > 1) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private boolean existsSchema(String name) {
        String value = null;
        try {
            String query = CpatQuery.getQuery("cpatExistsSchema", this._model.getConn());
            if (query != null) {
                HashMap<String, Object> binds = new HashMap<String, Object>();
                binds.put("SCHEMA", name);
                value = (String)this.executeOneCol(query, binds);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return value != null && value.equals("1");
    }

    private boolean assertName(String name) {
        String value = null;
        try {
            String query = CpatQuery.getQuery("cpatAssertName", this._model.getConn());
            if (query != null) {
                HashMap<String, Object> binds = new HashMap<String, Object>();
                binds.put("NAME", name);
                value = (String)this.executeOneCol(query, binds);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return value != null;
    }

    private Object executeOneCol(String query) throws SQLException {
        return this.executeOneCol(query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeOneCol(String query, Map<String, Object> binds) throws SQLException {
        String rtn = null;
        if (LockManager.lock((Connection)this._model.getConn())) {
            try {
                DBUtil dbUtil = DBUtil.getInstance((Connection)this._model.getConn());
                rtn = dbUtil.executeReturnOneCol(query, binds);
                SQLException e = dbUtil.getLastException();
                if (e != null) {
                    throw e;
                }
            }
            finally {
                LockManager.unlock((Connection)this._model.getConn());
            }
        }
        return rtn;
    }

    private String[] utilSplit(String baseString, String separator) {
        String[] retVal = null;
        String nullBase = baseString;
        String nullSeparator = separator;
        if (baseString == null) {
            nullBase = "";
        }
        if (separator == null) {
            nullSeparator = "";
        }
        if (baseString == null || separator == null) {
            retVal = null;
        } else {
            retVal = baseString.split(separator, -1);
            boolean isNull = false;
            for (String val : retVal) {
                if (!val.isEmpty()) continue;
                isNull = true;
            }
            if (retVal == null || retVal.length == 0) {
                isNull = true;
            }
            if (isNull) {
                retVal = null;
            }
        }
        if (retVal == null) {
            this._model.getToolLogger().logError(CpatResources.format("CPPRE_INVALID_LIST", nullBase, nullSeparator));
            this._model.isValid(false);
        }
        return retVal;
    }
}

