/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.CpatResources;
import oracle.dbtools.common.CpatModel;
import oracle.dbtools.common.CpatOption;
import oracle.dbtools.common.CpatOptions;
import oracle.dbtools.exceptions.ProcessFailedException;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parser.CoreParameterParser;

public class CpatParser {
    final String CPAT_PARMS = "sqlcl.Cpat.parms";
    private static final String ADVISE = "advise";
    private static final String INFO = "info";
    private static final String HELP = "help";
    private static final String PROPERTIES = "properties";
    private static final String NL = "\n";
    private CpatModel _model;

    public CpatParser(CpatModel model) {
        this._model = model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean parse() throws ProcessFailedException {
        try {
            CpatOption opt;
            String value;
            String key;
            ScriptRunnerContext ctx = this._model.getCtx();
            CoreParameterParser.loadParams((String)"sqlcl.Cpat.parms", (String)this._model.getSQLCommand().getSql(), (ScriptRunnerContext)ctx, CpatOptions.subCommands, CpatOptions.coreOptions, (boolean)false);
            HashMap coreArgs = ctx.getParams("sqlcl.Cpat.parms");
            String arg = null;
            for (Map.Entry coreArg : coreArgs.entrySet()) {
                key = (String)coreArg.getKey();
                value = (String)coreArg.getValue();
                arg = CpatOptions.getName(key);
                if (key.equalsIgnoreCase("basecommand")) continue;
                if (key.equalsIgnoreCase("command")) {
                    if (value.contains(HELP)) {
                        String[] helpVals = value.split(",");
                        Object help = HELP;
                        if (helpVals.length > 1) {
                            if (helpVals[1].equalsIgnoreCase("examples")) {
                                help = (String)help + "examples";
                            } else if (helpVals[1].equalsIgnoreCase("syntax")) {
                                help = (String)help + "syntax";
                            }
                        }
                        this._model.getArgs().put(HELP, help);
                        continue;
                    }
                    if (value.equalsIgnoreCase(ADVISE)) {
                        this._model.isAdvise(true);
                        this._model.getArgs().put("operation", value.toUpperCase());
                        continue;
                    }
                    if (value.equalsIgnoreCase(INFO.toUpperCase())) {
                        this._model.isInfo(true);
                        this._model.getArgs().put("operation", value);
                        continue;
                    }
                    if (!value.equalsIgnoreCase(PROPERTIES.toUpperCase())) throw new InvalidParameterException(CpatResources.format("CPPAR_INVALID_CMD", value));
                    this._model.isProperties(true);
                    this._model.getArgs().put("operation", value);
                    continue;
                }
                opt = CpatOptions.getOption(arg);
                if (opt == null) {
                    throw new InvalidParameterException(CpatResources.format("CPPAR_INVALID_OPT", key));
                }
                boolean isValid = opt.isValidValue(value);
                if (!isValid) {
                    if (value != null) throw new InvalidParameterException(CpatResources.format("CPPAR_INVALID_OPT_VALUE", arg, value));
                    if (!CpatOptions.coreOptions.get(key).equals("StringOrNullValidator")) {
                        throw new InvalidParameterException(CpatResources.format("CPPAR_INVALID_OPT_VALUE", arg, value != null ? value : ""));
                    }
                } else if (value == null && CpatOptions.coreOptions.get(key).equals("BooleanFlagValidator")) {
                    value = "true";
                }
                if (arg.equalsIgnoreCase(HELP)) continue;
                this._model.getArgs().put(arg, value);
            }
            for (Map.Entry coreArg : coreArgs.entrySet()) {
                key = (String)coreArg.getKey();
                value = (String)coreArg.getValue();
                arg = CpatOptions.getName(key);
                if (arg == null || (opt = CpatOptions.getOption(arg)) == null) continue;
                CpatOption.Operation operation = opt.getOperation();
            }
            return this._model.isValid();
        }
        catch (InvalidParameterException e) {
            this._model.isValid(false);
            throw new ProcessFailedException((Exception)((Object)e), CpatResources.getString("CP_PARSE"));
        }
    }
}

