/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.xkms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.security.xmlsec.c14n.CanonicalizationException;
import oracle.security.xmlsec.c14n.XMLC14NWithComments;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.xkms.Request;
import oracle.security.xmlsec.xkms.xkiss.LocateRequest;
import oracle.security.xmlsec.xkms.xkiss.ValidateRequest;
import oracle.security.xmlsec.xkms.xkrss.RecoverRequest;
import oracle.security.xmlsec.xkms.xkrss.RegisterRequest;
import oracle.security.xmlsec.xkms.xkrss.ReissueRequest;
import oracle.security.xmlsec.xkms.xkrss.RevokeRequest;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CompoundRequest
extends Request {
    public CompoundRequest(Element element) throws DOMException {
        super(element);
    }

    public CompoundRequest(Document owner) throws DOMException {
        super(owner, "CompoundRequest");
    }

    public CompoundRequest(Document owner, String systemId) throws DOMException {
        super(owner, "CompoundRequest", systemId);
    }

    public CompoundRequest(Document owner, List requests) throws DOMException {
        this(owner);
        int j = requests.size();
        for (int i = 0; i < j; ++i) {
            this.addRequest((Request)((Object)requests.get(i)));
        }
    }

    public void addRequest(Request request) throws DOMException {
        Element kiElement = null;
        try {
            byte[] kiBytes = new XMLC14NWithComments().canonicalize(request.getNode());
            Document kiDoc = XMLUtils.createDocBuilder().parse(new ByteArrayInputStream(kiBytes));
            kiElement = kiDoc.getDocumentElement();
        }
        catch (CanonicalizationException ex) {
            throw new DOMException(11, "Error canonicalizing xkms:Request");
        }
        catch (IOException ex) {
            throw new DOMException(11, "Error reading xkms:Request");
        }
        catch (SAXException ex) {
            throw new DOMException(11, "Error reading xkms:Request");
        }
        Element pn = (Element)this.getOwnerDocument().importNode(kiElement, true);
        this.insertChild(pn, new String[]{"Signature", "MessageExtension", "OpaqueClientData", "ResponseMechanism", "RespondWith", "PendingNotification"}, new String[]{"http://www.w3.org/2000/09/xmldsig#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#"});
        this.clearSignature();
    }

    public List getRequests() throws DOMException {
        int i;
        ArrayList<Request> list = new ArrayList<Request>();
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "LocateRequest");
        int j = nList.getLength();
        for (i = 0; i < j; ++i) {
            list.add(new LocateRequest((Element)nList.item(i)));
        }
        nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "ValidateRequest");
        j = nList.getLength();
        for (i = 0; i < j; ++i) {
            list.add(new ValidateRequest((Element)nList.item(i)));
        }
        nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "RegisterRequest");
        j = nList.getLength();
        for (i = 0; i < j; ++i) {
            list.add(new RegisterRequest((Element)nList.item(i)));
        }
        nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "ReissueRequest");
        j = nList.getLength();
        for (i = 0; i < j; ++i) {
            list.add(new ReissueRequest((Element)nList.item(i)));
        }
        nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "RecoverRequest");
        j = nList.getLength();
        for (i = 0; i < j; ++i) {
            list.add(new RecoverRequest((Element)nList.item(i)));
        }
        nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "RevokeRequest");
        j = nList.getLength();
        for (i = 0; i < j; ++i) {
            list.add(new RevokeRequest((Element)nList.item(i)));
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }
}

