/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.xkms;

import oracle.security.xmlsec.xkms.Status;
import oracle.security.xmlsec.xkms.UnverifiedKeyBinding;
import oracle.security.xmlsec.xkms.util.XKMSUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyBinding
extends UnverifiedKeyBinding {
    public KeyBinding(Element element) throws DOMException {
        super(element);
    }

    public KeyBinding(Document owner) throws DOMException {
        this(owner, "KeyBinding");
    }

    public KeyBinding(Document owner, String systemId) throws DOMException {
        super(owner, "KeyBinding", systemId);
    }

    public KeyBinding(Document owner, String tagName, String systemId) throws DOMException {
        super(owner, tagName, systemId);
    }

    public void setStatus(Status status) throws DOMException {
        XKMSUtils.removeChildren((Element)this.getNode(), "http://www.w3.org/2002/03/xkms#", "Status");
        if (status.getOwnerDocument() != this.getOwnerDocument()) {
            Element st = (Element)this.getOwnerDocument().importNode(status.getNode(), true);
            status = new Status(st);
        }
        Node v = status.getNode();
        XKMSUtils.insertChild((Element)this.getNode(), (Element)v, new String[]{"KeyInfo", "KeyUsage", "UseKeyWith", "ValidityInterval"}, new String[]{"http://www.w3.org/2000/09/xmldsig#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#"});
    }

    public Status getStatus() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "Status");
        if (nList.getLength() > 0) {
            return new Status((Element)nList.item(0));
        }
        return null;
    }
}

