/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.build.spi;

import java.util.ArrayList;
import java.util.Collection;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.util.MetaClass;

public final class BuildSystemHook
extends ExtensionHook {
    private static final ElementName LISTENER_CLASS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "listener-class");
    private static final ElementName BUILD_LISTENERS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "build-listeners");
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "build-system-hook");
    private final Collection _metaListeners = new ArrayList();
    private final ElementVisitor _listenerVisitor = new ListenerClassVisitor();
    private final ElementVisitor _buildListenersVisitor = new BuildListenersVisitor();

    public Collection getListeners() {
        ArrayList listeners = new ArrayList(this._metaListeners.size());
        for (MetaClass thisClass : this._metaListeners) {
            try {
                listeners.add(thisClass.newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return listeners;
    }

    @Override
    public void start(ElementStartContext ctx) {
        ctx.registerChildVisitor(BUILD_LISTENERS, this._buildListenersVisitor);
    }

    private class ListenerClassVisitor
    extends MetaClassVisitor {
        private ListenerClassVisitor() {
        }

        @Override
        protected void metaClass(ElementContext context, MetaClass mc) {
            BuildSystemHook.this._metaListeners.add(mc);
        }
    }

    private class BuildListenersVisitor
    extends ElementVisitor {
        private BuildListenersVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            context.registerChildVisitor(LISTENER_CLASS, BuildSystemHook.this._listenerVisitor);
        }
    }
}

