/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.ide.extension.spi.Stack;

public final class ScopedMap
extends AbstractMap {
    private final Stack _mapStack = new Stack();

    public ScopedMap() {
        this.enterScope();
    }

    synchronized void reset() {
        while (this._mapStack.size() > 1) {
            this._mapStack.pop();
        }
    }

    public synchronized void enterScope() {
        this._mapStack.push(new LinkedHashMap(8));
    }

    public synchronized void exitScope() {
        this._mapStack.pop();
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Map topMap = (Map)this._mapStack.peek();
        return topMap.put(key, value);
    }

    @Override
    public synchronized Object get(Object key) {
        for (Map thisMap : this._mapStack) {
            Object o = thisMap.get(key);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    @Override
    public synchronized Object remove(Object key) {
        for (Map thisMap : this._mapStack) {
            Object o = thisMap.remove(key);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    @Override
    public void clear() {
        Iterator i = this._mapStack.iterator();
        while (i.hasNext()) {
            ((Map)i.next()).clear();
        }
    }

    @Override
    public synchronized Set entrySet() {
        HashSet hs = new HashSet();
        for (Map thisMap : this._mapStack) {
            hs.addAll(thisMap.entrySet());
        }
        return hs;
    }

    public synchronized void copyInto(Map destination) {
        Iterator i = this._mapStack.reverseIterator();
        while (i.hasNext()) {
            Map thisMap = (Map)i.next();
            destination.putAll(thisMap);
        }
    }

    public static Map copyScopeData(Map scopeData, Set<String> keysToExclude) {
        HashMap destination = new HashMap(7);
        if (scopeData instanceof ScopedMap) {
            ((ScopedMap)scopeData).copyInto(destination);
        } else {
            destination.putAll(scopeData);
        }
        if (keysToExclude != null) {
            for (String key : keysToExclude) {
                destination.remove(key);
            }
        }
        return destination;
    }
}

