/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.menu.spi;

import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.I18NCharVisitor;
import javax.ide.extension.I18NStringVisitor;
import javax.ide.extension.IconVisitor;
import javax.ide.menu.spi.Menu;
import javax.ide.menu.spi.MenuBar;
import javax.ide.menu.spi.PositionableVisitor;
import javax.ide.menu.spi.SectionVisitor;
import javax.ide.util.IconDescription;

class MenuVisitor
extends PositionableVisitor {
    static final ElementName MENU = new ElementName("http://jcp.org/jsr/198/extension-manifest", "menu");
    private static final ElementName LABEL = new ElementName("http://jcp.org/jsr/198/extension-manifest", "label");
    private static final ElementName MNEMONIC = new ElementName("http://jcp.org/jsr/198/extension-manifest", "mnemonic");
    private static final ElementName TOOLTIP = new ElementName("http://jcp.org/jsr/198/extension-manifest", "tooltip");
    private static final ElementName ICONPATH = new ElementName("http://jcp.org/jsr/198/extension-manifest", "iconpath");
    private static final String KEY_DEFAULT_SECTION = "defaultsection";
    private ElementVisitor _sectionVisitor;

    MenuVisitor() {
    }

    @Override
    protected void positionable(ElementStartContext context, String id, String before, String after, Float weight) {
        MenuBar menuBar = (MenuBar)context.getScopeData().get("menuBar");
        Menu menu = menuBar.getMenu(id);
        if (menu == null) {
            menu = new Menu(id);
            menuBar.addMenu(menu);
        }
        this.processMenu(context, menu, before, after, weight);
    }

    protected final void processMenu(ElementStartContext context, final Menu menu, String before, String after, Float weight) {
        if (weight != null) {
            if (menu.getWeight() != null) {
                this.log(context, Level.WARNING, "The " + menu.getID() + " menu already has a defined weight of " + menu.getWeight());
            } else {
                menu.setWeight(weight);
            }
        } else if (before != null) {
            if (menu.getBefore() != null) {
                this.log(context, Level.WARNING, "The " + menu.getID() + " menu already has a defined before section of " + menu.getBefore());
            } else {
                menu.setBefore(before);
            }
            this.log(context, Level.WARNING, "The weight attribute should be used in place of before or after attributes.");
        } else if (after != null) {
            if (menu.getAfter() != null) {
                this.log(context, Level.WARNING, "The " + menu.getID() + " menu already has a defined 'after' section of " + menu.getAfter());
            } else {
                menu.setAfter(after);
            }
            this.log(context, Level.WARNING, "The 'weight' attribute should be used in place of 'before' or 'after' attributes.");
        }
        if (this._sectionVisitor == null) {
            this._sectionVisitor = new SectionVisitor();
        }
        context.getScopeData().put("sectionContainer", menu);
        context.registerChildVisitor(SectionVisitor.SECTION, this._sectionVisitor);
        String defaultSection = context.getAttributeValue(KEY_DEFAULT_SECTION);
        if (defaultSection != null) {
            if (menu.getDefaultSection() != null) {
                this.log(context, Level.WARNING, "The " + menu.getID() + " menu already has a defined defaultsection of " + menu.getDefaultSection());
            } else {
                menu.setDefaultSection(Float.valueOf(defaultSection));
            }
        }
        context.registerChildVisitor(LABEL, new I18NStringVisitor(){

            @Override
            protected void string(ElementContext context, String string) {
                menu.setLabel(string);
            }
        });
        context.registerChildVisitor(MNEMONIC, new I18NCharVisitor(){

            @Override
            protected void characterValue(ElementContext context, char c) {
                menu.setMnemonic(c);
            }
        });
        context.registerChildVisitor(TOOLTIP, new I18NStringVisitor(){

            @Override
            protected void string(ElementContext context, String string) {
                menu.setTooltip(string);
            }
        });
        context.registerChildVisitor(ICONPATH, new IconVisitor(){

            @Override
            protected void icon(ElementContext context, IconDescription icon) {
                menu.setIcon(icon);
            }
        });
    }
}

