/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbbridge;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.osgi.framework.BundleException;

public class IdeClassLoadingHook
implements ClassLoadingHook,
HookConfigurator {
    private static final String APPLY_PATCHES_KEY = "oracle.ide.apply.patches";
    private static final String EMMA_PROPERTY = "ide.testcoverage.emma";
    private final Map<String, String> m_bundleId2PatchJarPath;
    private boolean m_applyPatchesProcessed = false;
    private boolean m_emmaCoverageRun = false;
    private boolean m_isDebugBuild = "true".equals(System.getProperty("ide.debugbuild"));
    private String m_oracleHome = System.getProperty("ORACLE_HOME");
    public static final String EXTERNAL_LIB_PREFIX = "external:";
    public static final String VARIABLE_DELIM_STRING = "$";
    public static final char VARIABLE_DELIM_CHAR = '$';

    public IdeClassLoadingHook() {
        this.m_bundleId2PatchJarPath = new HashMap<String, String>();
        String coverage = System.getProperty(EMMA_PROPERTY);
        if ("true".equals(coverage)) {
            this.m_emmaCoverageRun = true;
        }
    }

    public byte[] processClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        return null;
    }

    public boolean addClassPathEntry(ArrayList result, String entryToAdd, ClasspathManager hostmanager, BaseData sourcedata, ProtectionDomain sourcedomain) {
        ClasspathEntry newEntry;
        String bundleId;
        boolean entriesAdded = false;
        if (!this.m_applyPatchesProcessed) {
            this.parsePatches(System.getProperty(APPLY_PATCHES_KEY));
        }
        if (this.m_bundleId2PatchJarPath.containsKey(bundleId = sourcedata.getSymbolicName())) {
            File patchesFile;
            BundleFile bundlefile;
            boolean containPatchesEntry = false;
            for (ClasspathEntry entry : result) {
                if (!(entry instanceof PatchClassPathEntry)) continue;
                containPatchesEntry = true;
                break;
            }
            if (!containPatchesEntry && (bundlefile = IdeClassLoadingHook.createBundleFile(patchesFile = new File(this.m_bundleId2PatchJarPath.get(bundleId)), sourcedata)) != null) {
                PatchClassPathEntry cpEntry = new PatchClassPathEntry(bundlefile, sourcedomain);
                result.add(0, cpEntry);
                entriesAdded = true;
            }
        }
        try {
            String projectName;
            Dictionary dictionary = sourcedata.getManifest();
            String attributes = (String)dictionary.get("JDEVADF-Class-Path-Includes");
            if (attributes != null && !attributes.trim().isEmpty()) {
                int entryLength = entryToAdd.length();
                int i = 0;
                while (true) {
                    if (attributes.regionMatches(i, entryToAdd, 0, entryLength) && attributes.charAt(i + entryLength) == '=') {
                        int begin = i + entryLength + 1;
                        int end = attributes.indexOf(44, begin);
                        if (end < 0) {
                            end = attributes.length();
                        }
                        Object pattern = attributes.substring(begin, end);
                        int depth = 1;
                        try {
                            int colon = ((String)pattern).lastIndexOf(58);
                            if (colon >= 0) {
                                depth = Integer.valueOf(((String)pattern).substring(colon + 1));
                                pattern = ((String)pattern).substring(0, colon);
                            }
                        }
                        catch (NumberFormatException e) {
                            sourcedata.getAdaptor().getEventPublisher().publishFrameworkEvent(16, sourcedata.getBundle(), (Throwable)e);
                        }
                        String PREFIX = EXTERNAL_LIB_PREFIX;
                        File file = new File(entryToAdd.startsWith(PREFIX) ? IdeClassLoadingHook.substituteVars(entryToAdd.substring(PREFIX.length())) : entryToAdd);
                        LinkedHashSet<File> collected = new LinkedHashSet<File>();
                        this.collectEntries(file, IdeClassLoadingHook.wildcardToRegex(new String[]{pattern}).matcher(""), depth, sourcedata, sourcedomain, collected, new HashSet<File>());
                        if (collected.isEmpty()) break;
                        ArrayList<ManifestClassPathEntry> entries = new ArrayList<ManifestClassPathEntry>(collected.size());
                        for (File newEntry2 : collected) {
                            try {
                                BundleFile bundleFile = sourcedata.getAdaptor().createBundleFile((Object)newEntry2, sourcedata);
                                ProtectionDomain domain = this.createProtectionDomain(newEntry2, sourcedomain);
                                entries.add(new ManifestClassPathEntry(bundleFile, domain));
                            }
                            catch (IOException e) {
                                sourcedata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, sourcedata.getBundle(), (Throwable)e);
                            }
                        }
                        if (entries.isEmpty()) break;
                        result.addAll(0, entries);
                        entriesAdded = true;
                        break;
                    }
                    int comma = attributes.indexOf(44, i + 1);
                    if (comma < 0) break;
                    i = comma + 1;
                }
            }
            if (this.m_isDebugBuild && (projectName = (String)dictionary.get("Oracle-ProjectName")) != null) {
                File classesDir;
                String projectType = (String)dictionary.get("Oracle-ProjectType");
                String classesDirTail = "/built/" + projectName + ("JUNIT".equals(projectType) ? "/junit-classes" : "/classes");
                boolean addClassesDir = true;
                for (ClasspathEntry entry : result) {
                    if (entry instanceof ProjectClassPathEntry) {
                        addClassesDir = false;
                        break;
                    }
                    BundleFile bf = entry.getBundleFile();
                    File baseFile = bf.getBaseFile();
                    String filepath = baseFile.getAbsolutePath().replace('\\', '/');
                    if (!filepath.endsWith(classesDirTail)) continue;
                    addClassesDir = false;
                    break;
                }
                if (addClassesDir && (classesDir = new File(this.m_oracleHome + classesDirTail)).exists()) {
                    BundleFile bundleFile = IdeClassLoadingHook.createBundleFile(classesDir, sourcedata);
                    ProtectionDomain domain = this.createProtectionDomain(classesDir, sourcedomain);
                    newEntry = new ProjectClassPathEntry(bundleFile, domain);
                    result.add(0, newEntry);
                    entriesAdded = true;
                }
            }
        }
        catch (BundleException e) {
            sourcedata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, sourcedata.getBundle(), (Throwable)e);
        }
        if (this.m_emmaCoverageRun) {
            ArrayList<ClasspathEntry> additions = new ArrayList<ClasspathEntry>();
            for (ClasspathEntry entry : result) {
                BundleFile bf = entry.getBundleFile();
                File baseFile = bf.getBaseFile();
                String filepath = baseFile.getAbsolutePath();
                if (!filepath.endsWith("classes")) continue;
                String icpath = filepath.substring(0, filepath.length() - "classes".length());
                File instrumentedDir = new File(icpath = icpath + "classes-instrumented");
                if (!instrumentedDir.exists()) continue;
                BundleFile instrumentedBundleFile = IdeClassLoadingHook.createBundleFile(instrumentedDir, sourcedata);
                newEntry = new ClasspathEntry(instrumentedBundleFile, sourcedomain);
                additions.add(newEntry);
                entriesAdded = true;
            }
            result.addAll(0, additions);
        }
        return entriesAdded;
    }

    private void collectEntries(File file, Matcher matcher, int depth, BaseData sourcedata, ProtectionDomain sourcedomain, Set<File> collected, Set<File> seen) {
        boolean unseen = seen.add(file);
        if (!unseen) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        boolean recurse = depth == 0 || --depth > 0;
        try (JarFile jar = new JarFile(file);){
            String paths = jar.getManifest().getMainAttributes().getValue("Class-Path");
            if (paths == null) {
                return;
            }
            Path directory = file.getParentFile().toPath();
            for (String entryPath : paths.split(" +")) {
                boolean uncollected;
                if (entryPath.isEmpty()) continue;
                File entryFile = directory.resolve(entryPath).normalize().toFile();
                matcher.reset(entryFile.toString());
                if (!matcher.matches() || !entryFile.exists() || !(uncollected = collected.add(entryFile)) || !recurse) continue;
                this.collectEntries(entryFile, matcher, depth, sourcedata, sourcedomain, collected, seen);
            }
        }
        catch (IOException e) {
            sourcedata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, sourcedata.getBundle(), (Throwable)e);
        }
    }

    public static Pattern wildcardToRegex(String ... wildcards) {
        char SEPARATOR = File.separatorChar;
        String ESCAPED_SEPARATOR = (SEPARATOR == '\\' ? "\\" : "") + SEPARATOR;
        StringBuilder builder = new StringBuilder(wildcards.length * 24);
        for (String wildcard : wildcards) {
            int length = wildcard.length();
            if (length == 0) continue;
            if (builder.length() > 0) {
                builder.append('|');
            }
            boolean endsWithSeparator = false;
            block7: for (int i = 0; i < length; ++i) {
                char c = wildcard.charAt(i);
                endsWithSeparator = false;
                switch (c) {
                    case '/': 
                    case '\\': {
                        endsWithSeparator = true;
                        builder.append(ESCAPED_SEPARATOR);
                        continue block7;
                    }
                    case '*': {
                        if (i + 1 < length && wildcard.charAt(i + 1) == '*') {
                            builder.append(".*");
                            ++i;
                            continue block7;
                        }
                        builder.append("[^" + ESCAPED_SEPARATOR + "]*");
                        continue block7;
                    }
                    case '?': {
                        builder.append(".");
                        continue block7;
                    }
                    case '$': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '.': 
                    case '[': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        builder.append('\\').append(c);
                        continue block7;
                    }
                    default: {
                        builder.append(c);
                    }
                }
            }
            if (!endsWithSeparator) continue;
            builder.append(".*");
        }
        return Pattern.compile(builder.toString());
    }

    public String findLibrary(BaseData data, String libName) {
        return null;
    }

    public ClassLoader getBundleClassLoaderParent() {
        return null;
    }

    public BaseClassLoader createClassLoader(ClassLoader parent, ClassLoaderDelegate delegate, BundleProtectionDomain domain, BaseData data, String[] bundleclasspath) {
        return null;
    }

    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData data) {
    }

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addClassLoadingHook((ClassLoadingHook)this);
    }

    private static BundleFile createBundleFile(Object content, BaseData sourcedata) {
        try {
            return sourcedata.getAdaptor().createBundleFile(content, sourcedata);
        }
        catch (IOException e) {
            sourcedata.getAdaptor().getEventPublisher().publishFrameworkEvent(2, sourcedata.getBundle(), (Throwable)e);
            return null;
        }
    }

    private ProtectionDomain createProtectionDomain(File file, ProtectionDomain baseDomain) {
        BundleProtectionDomain domain;
        try {
            PermissionCollection permissions;
            if (baseDomain != null) {
                permissions = baseDomain.getPermissions();
            } else {
                AllPermission allPerm = new AllPermission();
                permissions = allPerm.newPermissionCollection();
                permissions.add(allPerm);
            }
            domain = new BundleProtectionDomain(permissions, new CodeSource(file.toURI().toURL(), (Certificate[])null), null);
        }
        catch (MalformedURLException e) {
            domain = null;
        }
        return domain;
    }

    private void parsePatches(String applyPatchesValue) {
        if (applyPatchesValue != null) {
            String[] patchInfos;
            for (String patchInfo : patchInfos = applyPatchesValue.split(";")) {
                String[] tuple = patchInfo.split(",");
                if (tuple.length != 2) continue;
                this.m_bundleId2PatchJarPath.put(tuple[0], tuple[1]);
            }
        }
        this.m_applyPatchesProcessed = true;
    }

    public static String substituteVars(String path) {
        StringBuffer buf = new StringBuffer(path.length());
        StringTokenizer st = new StringTokenizer(path, VARIABLE_DELIM_STRING, true);
        boolean varStarted = false;
        String var = null;
        while (st.hasMoreElements()) {
            String tok = st.nextToken();
            if (VARIABLE_DELIM_STRING.equals(tok)) {
                if (!varStarted) {
                    varStarted = true;
                    var = "";
                    continue;
                }
                String prop = null;
                if (var != null && var.length() > 0) {
                    prop = System.getProperty(var);
                }
                if (prop == null) {
                    try {
                        Method getenv = System.class.getMethod("getenv", String.class);
                        prop = (String)getenv.invoke(null, var);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (prop != null) {
                    buf.append(prop);
                } else {
                    buf.append(var == null ? "" : var);
                }
                varStarted = false;
                var = null;
                continue;
            }
            if (!varStarted) {
                buf.append(tok);
                continue;
            }
            var = tok;
        }
        if (var != null) {
            buf.append('$').append(var);
        }
        return buf.toString();
    }

    private static class ManifestClassPathEntry
    extends ClasspathEntry {
        public ManifestClassPathEntry(BundleFile bundlefile, ProtectionDomain domain) {
            super(bundlefile, domain);
        }
    }

    private static class ProjectClassPathEntry
    extends ClasspathEntry {
        public ProjectClassPathEntry(BundleFile bundlefile, ProtectionDomain domain) {
            super(bundlefile, domain);
        }
    }

    private static class PatchClassPathEntry
    extends ClasspathEntry {
        public PatchClassPathEntry(BundleFile bundlefile, ProtectionDomain domain) {
            super(bundlefile, domain);
        }
    }
}

