/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.navigator.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.util.dnd.DropHelper;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ideri.navigator.dnd.TransferableProject;

public class WorkspaceNodeDropHelper
implements DropHelper {
    public static final Class DROP_TARGET_TYPE = Workspace.class;

    public float getWeight() {
        return 1.0f;
    }

    public boolean canTransferData(Object dropTarget, DataFlavor[] transferFlavors, int action) {
        if (!(dropTarget instanceof TNode)) {
            return false;
        }
        for (int i = 0; i < transferFlavors.length; ++i) {
            if (!transferFlavors[i].equals(TransferableProject.PROJECT_NODE_FLAVOR)) continue;
            return true;
        }
        return false;
    }

    public boolean transferData(Object dropTarget, Transferable[] transferables, int action) {
        if (transferables.length == 0) {
            return false;
        }
        if (!(dropTarget instanceof TNode)) {
            return false;
        }
        TNode dropTargetNode = (TNode)dropTarget;
        Element elem = dropTargetNode.getData();
        if (!(elem instanceof Workspace)) {
            return false;
        }
        Workspace parent = (Workspace)elem;
        try {
            for (int i = 0; i < transferables.length; ++i) {
                Transferable transferable = transferables[i];
                if (!this.canTransferData(dropTarget, transferable.getTransferDataFlavors(), action)) continue;
                this.doTransfer(parent, transferable, action);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean doTransfer(Workspace newParent, Transferable transferable, int action) throws IOException, UnsupportedFlavorException {
        if (action == 2 || action == 1) {
            DefaultMutableTreeNode originatingNode;
            Workspace oldParent;
            Project project = (Project)transferable.getTransferData(TransferableProject.PROJECT_NODE_FLAVOR);
            if (action == 1) {
                project.open();
                Project copyOfProject = (Project)project.copyTo(null);
                newParent.add((Element)copyOfProject, true);
                return true;
            }
            if (action == 2 && transferable.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR) && (oldParent = this.getWorkspaceForProjectNode(originatingNode = (DefaultMutableTreeNode)transferable.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR))) != newParent && !newParent.containsChild((Element)project)) {
                oldParent.remove((Element)project, true);
                newParent.add((Element)project, true);
                return true;
            }
        }
        return false;
    }

    private Workspace getWorkspaceForProjectNode(DefaultMutableTreeNode projectTNode) {
        TreeNode[] nodes = projectTNode.getPath();
        int length = nodes.length;
        for (int i = length - 1; i >= 0; --i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes[i];
            Object userData = node.getUserObject();
            if (!(userData instanceof Workspace)) continue;
            return (Workspace)userData;
        }
        return null;
    }
}

