/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.core.utils;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.migration.cloud.core.utils.ApiNLS;
import oracle.dbtools.migration.cloud.core.utils.SQLCLException;
import oracle.dbtools.raptor.newscriptrunner.SQLPLUS;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.newscriptrunner.commands.SetAppinfo;

public class RunSQLcl {
    private ScriptExecutor m_scriptRunner;
    private ScriptRunnerContext m_scriptRunnerContext;

    public RunSQLcl(Connection connection, WrapListenBufferOutputStream wrapListenBufferOutputStream) {
        this.createScriptRunner(connection, wrapListenBufferOutputStream);
    }

    public void createScriptRunner(Connection connection, WrapListenBufferOutputStream wrapListenBufferOutputStream) {
        this.m_scriptRunnerContext = new ScriptRunnerContext();
        this.m_scriptRunnerContext.putProperty("DBConfig.GLOGIN", (Object)true);
        this.m_scriptRunnerContext.putProperty("script.runner.sqlplus.nolog", (Object)Boolean.TRUE);
        this.m_scriptRunnerContext.consumerRuning(true);
        this.m_scriptRunnerContext.setBaseConnection(connection);
        this.m_scriptRunnerContext.setCurrentConnection(connection);
        this.m_scriptRunnerContext.putProperty("script.runner.commandlineconnect", (Object)Boolean.FALSE);
        this.m_scriptRunnerContext.setEscape(false);
        this.m_scriptRunnerContext.setSubstitutionOn(false);
        this.m_scriptRunnerContext.setCloseConnection(false);
        ResultSetFormatter.setMaxLines((int)Integer.MAX_VALUE);
        this.m_scriptRunner = new ScriptExecutor(connection);
        this.m_scriptRunner.setScriptRunnerContext(this.m_scriptRunnerContext);
        this.m_scriptRunner.setOut((BufferedOutputStream)wrapListenBufferOutputStream);
        this.setScriptRunnerContext(this.m_scriptRunnerContext);
        this.setScriptRunner(this.m_scriptRunner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSQLFile(String string) throws SQLCLException, IOException {
        URL uRL = this.getClass().getClassLoader().getResource(string);
        this.getScriptRunnerContext().consumerRuning(true);
        this.getScriptRunner().setStmt(uRL.openStream());
        this.getScriptRunnerContext().putProperty("Run SQL File", (Object)this.getScriptRunner());
        this.getScriptRunnerContext().setTopLevel(true);
        ArrayList arrayList = (ArrayList)this.getScriptRunnerContext().getProperty("script.runner.appinfo.arraylist");
        arrayList.add(string);
        this.getScriptRunnerContext().putProperty("script.runner.appinfo.arraylist", (Object)arrayList);
        ResultSetFormatter.setMaxLines((int)Integer.MAX_VALUE);
        ResultSetFormatter.setMaxRows((int)Integer.MAX_VALUE);
        this.getScriptRunner().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new MyUncaughtExceptionHandler());
        try {
            this.getScriptRunner().run();
            if (this.getScriptRunnerContext().getReturnExited()) {
                throw new SQLCLException(ApiNLS.getString("ERROR_REPOSITORY_FAILED_TO_BUILD"));
            }
        }
        finally {
            arrayList = (ArrayList)this.getScriptRunnerContext().getProperty("script.runner.appinfo.arraylist");
            if (arrayList.size() != 0) {
                arrayList.remove(arrayList.size() - 1);
            }
            this.getScriptRunnerContext().putProperty("script.runner.appinfo.arraylist", (Object)arrayList);
            if (arrayList.size() != 0) {
                SetAppinfo.setAppinfo((ScriptRunnerContext)this.getScriptRunnerContext(), (Connection)this.getScriptRunnerContext().getCurrentConnection(), (String)((String)arrayList.get(arrayList.size() - 1)), (Integer)arrayList.size());
            } else {
                SetAppinfo.setAppinfo((ScriptRunnerContext)this.getScriptRunnerContext(), (Connection)this.getScriptRunnerContext().getCurrentConnection(), (String)SQLPLUS.PRODUCT_NAME, (Integer)0);
            }
        }
        this.getScriptRunnerContext().setTopLevel(true);
    }

    public void runSQLScript(String string) throws SQLCLException {
        this.getScriptRunnerContext().consumerRuning(true);
        this.getScriptRunner().setStmt(string);
        this.getScriptRunnerContext().putProperty("Run SQL Script", (Object)this.getScriptRunner());
        this.getScriptRunnerContext().setTopLevel(true);
        ArrayList arrayList = (ArrayList)this.getScriptRunnerContext().getProperty("script.runner.appinfo.arraylist");
        arrayList.add(string);
        this.getScriptRunnerContext().putProperty("script.runner.appinfo.arraylist", (Object)arrayList);
        ResultSetFormatter.setMaxLines((int)Integer.MAX_VALUE);
        ResultSetFormatter.setMaxRows((int)Integer.MAX_VALUE);
        this.getScriptRunner().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new MyUncaughtExceptionHandler());
        this.getScriptRunner().setScriptRunnerContext(this.getScriptRunnerContext());
        try {
            this.getScriptRunner().run();
            if (this.getScriptRunnerContext().getReturnExited()) {
                throw new SQLCLException(ApiNLS.getString("ERROR_REPOSITORY_FAILED_TO_BUILD"));
            }
        }
        finally {
            arrayList = (ArrayList)this.getScriptRunnerContext().getProperty("script.runner.appinfo.arraylist");
            if (arrayList.size() != 0) {
                arrayList.remove(arrayList.size() - 1);
            }
            this.getScriptRunnerContext().putProperty("script.runner.appinfo.arraylist", (Object)arrayList);
            if (arrayList.size() != 0) {
                SetAppinfo.setAppinfo((ScriptRunnerContext)this.getScriptRunnerContext(), (Connection)this.getScriptRunnerContext().getCurrentConnection(), (String)((String)arrayList.get(arrayList.size() - 1)), (Integer)arrayList.size());
            } else {
                SetAppinfo.setAppinfo((ScriptRunnerContext)this.getScriptRunnerContext(), (Connection)this.getScriptRunnerContext().getCurrentConnection(), (String)SQLPLUS.PRODUCT_NAME, (Integer)0);
            }
        }
        this.getScriptRunnerContext().setTopLevel(true);
    }

    public void dropScriptRunner() {
        try {
            if (this.m_scriptRunner != null) {
                if (!this.m_scriptRunner.getConn().isClosed()) {
                    this.m_scriptRunner.getConn().close();
                }
                this.m_scriptRunner = null;
            }
            if (this.m_scriptRunnerContext != null) {
                this.m_scriptRunnerContext = null;
            }
        }
        catch (SQLException sQLException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ScriptExecutor getScriptRunner() {
        return this.m_scriptRunner;
    }

    public void setScriptRunner(ScriptExecutor scriptExecutor) {
        this.m_scriptRunner = scriptExecutor;
    }

    public ScriptRunnerContext getScriptRunnerContext() {
        return this.m_scriptRunnerContext;
    }

    public void setScriptRunnerContext(ScriptRunnerContext scriptRunnerContext) {
        this.m_scriptRunnerContext = scriptRunnerContext;
    }

    class MyUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        MyUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

