/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLStylesheet;
import oracle.xml.xsql.Res;
import oracle.xml.xsql.XSQLConfigManager;
import oracle.xml.xsql.XSQLPageRequest;
import oracle.xml.xsql.XSQLParserHelper;
import oracle.xml.xsql.XSQLStylesheet;
import oracle.xml.xsql.XSQLUtil;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class XSQLStylesheetPool {
    private XMLDocument parsedSheetSource = null;
    private long parsedSheetTimestamp = -1L;
    private Hashtable stylesheets;
    private String sheeturi;
    private String password;
    private static int total = 0;
    private long lastCleanup = -1L;
    private int POOL_TIMEOUT = 60000;
    private int POOL_INCREMENT = 1;
    private int POOL_INITIAL = 1;
    private URL xslURL = null;
    private static final Boolean SYNC_LOCK = Boolean.TRUE;

    public XSQLStylesheetPool(String string, XSQLPageRequest xSQLPageRequest, boolean bl) throws FileNotFoundException, SAXParseException, XSLException, MalformedURLException {
        XSQLConfigManager xSQLConfigManager = XSQLConfigManager.getManager();
        this.POOL_TIMEOUT = xSQLConfigManager.getStylesheetPoolTimeout();
        this.POOL_INCREMENT = xSQLConfigManager.getStylesheetPoolIncrement();
        this.POOL_INITIAL = xSQLConfigManager.getStylesheetPoolInitial();
        this.sheeturi = string;
        String string2 = string.substring(string.lastIndexOf("/") + 1);
        this.xslURL = new URL(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSQLStylesheet getStylesheet(XSQLPageRequest xSQLPageRequest, boolean bl) throws Exception, SAXParseException, SAXException, XSLException, FileNotFoundException {
        long l = XSQLUtil.timestampOf(this.sheeturi);
        Object var5_4 = null;
        if (l == 0L) {
            return new XSQLStylesheet(this.newSheet(this.parseStylesheetSourceDoc(this.xslURL, xSQLPageRequest, bl), xSQLPageRequest, bl), this.sheeturi, false);
        }
        if (this.stylesheets == null) {
            Boolean bl2 = SYNC_LOCK;
            synchronized (bl2) {
                try {
                    if (this.stylesheets == null) {
                        this.rereadStylehseetSourceDoc(this.xslURL, l, xSQLPageRequest, bl);
                    }
                }
                catch (SAXParseException sAXParseException) {
                    this.stylesheets = null;
                    this.parsedSheetSource = null;
                    this.parsedSheetTimestamp = -1L;
                    throw sAXParseException;
                }
                catch (XSLException xSLException) {
                    this.stylesheets = null;
                    this.parsedSheetSource = null;
                    this.parsedSheetTimestamp = -1L;
                    throw xSLException;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.stylesheets = null;
                    this.parsedSheetSource = null;
                    this.parsedSheetTimestamp = -1L;
                    throw fileNotFoundException;
                }
                catch (Exception exception) {
                    this.stylesheets = null;
                    this.parsedSheetSource = null;
                    this.parsedSheetTimestamp = -1L;
                    throw exception;
                }
            }
        }
        if (this.parsedSheetSource == null || l > this.parsedSheetTimestamp) {
            try {
                this.rereadStylehseetSourceDoc(this.xslURL, l, xSQLPageRequest, bl);
            }
            catch (SAXParseException sAXParseException) {
                this.stylesheets = null;
                this.parsedSheetSource = null;
                this.parsedSheetTimestamp = -1L;
                throw sAXParseException;
            }
            catch (XSLException xSLException) {
                this.stylesheets = null;
                this.parsedSheetSource = null;
                this.parsedSheetTimestamp = -1L;
                throw xSLException;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.stylesheets = null;
                this.parsedSheetSource = null;
                this.parsedSheetTimestamp = -1L;
                throw fileNotFoundException;
            }
            catch (Exception exception) {
                this.stylesheets = null;
                this.parsedSheetSource = null;
                this.parsedSheetTimestamp = -1L;
                throw exception;
            }
        }
        return this.getSheetFromPool(xSQLPageRequest, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XSQLStylesheet getSheetFromPool(XSQLPageRequest xSQLPageRequest, boolean bl) throws SAXParseException, XSLException, FileNotFoundException {
        XSQLStylesheet xSQLStylesheet = null;
        XSQLStylesheet xSQLStylesheet2 = null;
        Enumeration enumeration = this.stylesheets.keys();
        int n = 0;
        long l = System.currentTimeMillis();
        boolean bl2 = false;
        if (l - this.lastCleanup > (long)this.POOL_TIMEOUT) {
            bl2 = true;
            this.lastCleanup = l;
        }
        Hashtable hashtable = this.stylesheets;
        synchronized (hashtable) {
            while (enumeration.hasMoreElements()) {
                xSQLStylesheet = (XSQLStylesheet)enumeration.nextElement();
                ++n;
                Boolean bl3 = (Boolean)this.stylesheets.get(xSQLStylesheet);
                if (bl3 != Boolean.FALSE) continue;
                if (xSQLStylesheet2 == null) {
                    this.stylesheets.put(xSQLStylesheet, Boolean.TRUE);
                    xSQLStylesheet2 = xSQLStylesheet;
                    continue;
                }
                if (!bl2 || l - xSQLStylesheet.getLastUsed() <= (long)this.POOL_TIMEOUT || n <= this.POOL_INITIAL) continue;
                xSQLStylesheet.close();
                this.stylesheets.remove(xSQLStylesheet);
            }
        }
        if (xSQLStylesheet2 != null) {
            return xSQLStylesheet2;
        }
        for (int i = 0; i < this.POOL_INCREMENT; ++i) {
            xSQLStylesheet2 = new XSQLStylesheet(this.newSheet(this.parsedSheetSource, xSQLPageRequest, bl), this.sheeturi, true);
            this.stylesheets.put(xSQLStylesheet2, Boolean.FALSE);
        }
        return this.getSheetFromPool(xSQLPageRequest, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSheet(XSQLStylesheet xSQLStylesheet) {
        if (xSQLStylesheet.isPooled()) {
            Enumeration enumeration = this.stylesheets.keys();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                ++n;
                XSQLStylesheet xSQLStylesheet2 = (XSQLStylesheet)enumeration.nextElement();
                if (xSQLStylesheet2 != xSQLStylesheet) continue;
                Hashtable hashtable = this.stylesheets;
                synchronized (hashtable) {
                    long l = System.currentTimeMillis();
                    xSQLStylesheet2.updateLastUsed();
                    this.stylesheets.put(xSQLStylesheet2, Boolean.FALSE);
                    break;
                }
            }
        }
    }

    private XSLStylesheet newSheet(XMLDocument xMLDocument, XSQLPageRequest xSQLPageRequest, boolean bl) throws SAXParseException, FileNotFoundException, XSLException {
        XSLStylesheet xSLStylesheet = null;
        try {
            PrintWriter printWriter = new PrintWriter(new StringWriter());
            xSLStylesheet = new XSLStylesheet(xMLDocument, this.xslURL);
        }
        catch (XSLException xSLException) {
            throw xSLException;
        }
        catch (Exception exception) {
            throw new RuntimeException(Res.getString(25101));
        }
        return xSLStylesheet;
    }

    private XMLDocument parseStylesheetSourceDoc(URL uRL, XSQLPageRequest xSQLPageRequest, boolean bl) throws Exception, SAXParseException, SAXException, FileNotFoundException, XSLException {
        XMLDocument xMLDocument = null;
        try {
            PrintWriter printWriter = new PrintWriter(new StringWriter());
            xMLDocument = (XMLDocument)XSQLParserHelper.parse(uRL, printWriter);
        }
        catch (SAXParseException sAXParseException) {
            if (!bl) {
                xSQLPageRequest.signalError(25006, new String[]{xSQLPageRequest.getStylesheetURI()}, new Object[]{sAXParseException});
            }
            throw sAXParseException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!bl) {
                xSQLPageRequest.signalError(25008, new String[]{xSQLPageRequest.getStylesheetURI()}, null);
            }
            throw fileNotFoundException;
        }
        catch (Exception exception) {
            xSQLPageRequest.signalError(25019, new String[]{xSQLPageRequest.getStylesheetURI()}, new Object[]{exception});
            throw exception;
        }
        return xMLDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void rereadStylehseetSourceDoc(URL uRL, long l, XSQLPageRequest xSQLPageRequest, boolean bl) throws Exception, SAXParseException, FileNotFoundException, XSLException {
        this.parsedSheetSource = this.parseStylesheetSourceDoc(uRL, xSQLPageRequest, bl);
        this.parsedSheetTimestamp = l;
        Hashtable<XSQLStylesheet, Boolean> hashtable = new Hashtable<XSQLStylesheet, Boolean>(this.POOL_INITIAL * 2);
        if (l != 0L) {
            for (int i = 0; i < this.POOL_INITIAL; ++i) {
                XSQLStylesheet xSQLStylesheet = new XSQLStylesheet(this.newSheet(this.parsedSheetSource, xSQLPageRequest, bl), this.sheeturi, true);
                if (xSQLStylesheet == null) continue;
                hashtable.put(xSQLStylesheet, Boolean.FALSE);
            }
            if (this.stylesheets != null) {
                Hashtable hashtable2 = this.stylesheets;
                synchronized (hashtable2) {
                    this.stylesheets = hashtable;
                }
            } else {
                this.stylesheets = hashtable;
            }
        }
    }
}

