/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.util.Arrays;
import javax.ide.util.MetaResource;
import oracle.ide.ExtensionRegistry;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.util.Assert;
import oracle.ide.wizard.Invokable;
import oracle.ide.wizard.Wizard;
import oracle.ideimpl.gallery.NbResourceHelper;

public class ElementInfo {
    private String[] _path;
    private String _id;
    private Invokable _invokable;
    private String _invokableClassName;
    private ClassLoader _classLoader;
    private String[] _params;
    private String _name;
    private String _description;
    private String _descriptionURL;
    private String _iconFilePath;
    private MetaResource _iconMetaResource;
    private boolean _unsorted;
    private String[] _technologyKeys;
    @Deprecated
    private String _resClass;
    private String _ruleId;
    private boolean _canAddToMruMenu = true;

    @Deprecated
    public ElementInfo(String[] path, String clazz, String[] params, String name, String description, String iconFile, boolean unsorted) {
        this(path, clazz, (ClassLoader)null, name, description, iconFile, unsorted);
        this.setWizardParameters(params);
    }

    @Deprecated
    public ElementInfo(String[] path, Wizard wzClass, String[] params, String name, String description, String iconFile, boolean unsorted) {
        this(path, null, (ClassLoader)null, name, description, iconFile, unsorted);
        this.setInvokable((Invokable)wzClass);
        this.setWizardParameters(params);
    }

    @Deprecated
    public ElementInfo(String categoryName, String folderName, String clazz, String[] params, String name, String description, String iconFile, boolean unsorted) {
        this(ElementInfo.makePath(categoryName, folderName), clazz, (ClassLoader)null, name, description, iconFile, unsorted);
        this.setWizardParameters(params);
    }

    @Deprecated
    public ElementInfo(String categoryName, String folderName, Wizard wizard, String[] params, String name, String description, String iconFile, boolean unsorted) {
        this(ElementInfo.makePath(categoryName, folderName), null, (ClassLoader)null, name, description, iconFile, unsorted);
        this.setInvokable((Invokable)wizard);
        this.setWizardParameters(params);
    }

    public ElementInfo(String[] path, String className, ClassLoader classloader, String name, String description, String iconFilePath, boolean unsorted) {
        this.pathMustHaveNoNullElements(path);
        this.setPath(path);
        this.setInvokableClass(className);
        this.setInvokableClassLoader(classloader);
        this.setName(name);
        this.setDescription(description);
        this.setIconFile(iconFilePath);
        this.setUnsorted(unsorted);
    }

    public ElementInfo(String[] path, String className, ClassLoader classloader, String name, String description, MetaResource iconResource, boolean unsorted) {
        this.pathMustHaveNoNullElements(path);
        this.setPath(path);
        this.setInvokableClass(className);
        this.setInvokableClassLoader(classloader);
        this.setName(name);
        this.setDescription(description);
        this.setIconMetaResource(iconResource);
        this.setUnsorted(unsorted);
    }

    public ElementInfo() {
    }

    public String[] getPath() {
        return this._path;
    }

    public void setPath(String[] path) {
        this._path = path;
    }

    public void setPath(String folderName) {
        this._path = ElementInfo.makePath(null, folderName);
    }

    public void setPath(String categoryName, String folderName) {
        this._path = ElementInfo.makePath(categoryName, folderName);
    }

    @Deprecated
    public String getWizardClass() {
        return this.getInvokableClassName();
    }

    public String getInvokableClassName() {
        return this._invokableClassName;
    }

    ClassLoader getInvokableClassLoader() {
        if (this._classLoader == null) {
            if (this._invokable != null) {
                return this._invokable.getClass().getClassLoader();
            }
            Assert.println((this._invokableClassName != null ? 1 : 0) != 0, (String)("The classloader should not be null; wizard=" + this._invokableClassName));
            return ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.ide");
        }
        return this._classLoader;
    }

    @Deprecated
    public void setWizardClassLoader(ClassLoader loader) {
        this.setInvokableClassLoader(loader);
    }

    public void setInvokableClassLoader(ClassLoader loader) {
        this._classLoader = loader;
    }

    @Deprecated
    public void setWizardClass(String wizardClassName) {
        this.setInvokableClass(wizardClassName);
    }

    public void setInvokableClass(String invokableClassName) {
        this._invokableClassName = invokableClassName;
    }

    @Deprecated
    public Wizard getWizard() {
        return this.getInvokable() instanceof Wizard ? (Wizard)this.getInvokable() : null;
    }

    @Deprecated
    public void setWizard(Wizard wizard) {
        this.setInvokable((Invokable)wizard);
    }

    public Invokable getInvokable() {
        return this._invokable;
    }

    public void setInvokable(Invokable invokable) {
        this._invokable = invokable;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getDescription() {
        if (this._description == null && this._descriptionURL != null) {
            this._description = NbResourceHelper.loadResource(this._descriptionURL);
        }
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    void setDescriptionURL(String descriptionURL) {
        this._descriptionURL = descriptionURL;
    }

    public String getIconFile() {
        return this._iconFilePath;
    }

    public void setIconFile(String iconFilePath) {
        this._iconFilePath = iconFilePath;
    }

    public MetaResource getIconMetaResource() {
        return this._iconMetaResource;
    }

    public void setIconMetaResource(MetaResource iconMetaResource) {
        this._iconMetaResource = iconMetaResource;
    }

    public String[] getWizardParameters() {
        return this._params;
    }

    public void setWizardParameters(String[] params) {
        this._params = params;
    }

    @Deprecated
    public boolean getUnsorted() {
        return this.isUnsorted();
    }

    public boolean isUnsorted() {
        return this._unsorted;
    }

    public void setUnsorted(boolean unsorted) {
        this._unsorted = unsorted;
    }

    public String[] getTechnologyKeys() {
        return this._technologyKeys;
    }

    public void setTechnologyKeys(String[] technologyKeys) {
        this._technologyKeys = technologyKeys;
    }

    public void setRule(String ruleId) {
        this._ruleId = ruleId;
    }

    public String getRule() {
        return this._ruleId;
    }

    @Deprecated
    public void setWizardId(String wizardId) {
        this.setId(wizardId);
    }

    public void setId(String wizardId) {
        this._id = wizardId;
    }

    public String getId() {
        return this._id;
    }

    public final void setCanAddToMruMenu(boolean canAddToMruMenu) {
        this._canAddToMruMenu = canAddToMruMenu;
    }

    private boolean canAddToNewMenu() {
        if (!this._canAddToMruMenu) {
            return false;
        }
        for (String category : this.getPath()) {
            if (!"Applications".equals(category) && !"Projects".equals(category)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public String getResClass() {
        return this._resClass;
    }

    @Deprecated
    public void setResClass(String resClass) {
        this._resClass = resClass;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ElementInfo)) {
            return false;
        }
        ElementInfo other = (ElementInfo)object;
        if (!Arrays.equals(this._path, other._path)) {
            return false;
        }
        if (this._canAddToMruMenu != other._canAddToMruMenu) {
            return false;
        }
        if (!(this._id != null ? this._id.equals(other._id) : other._id == null)) {
            return false;
        }
        if (!(this._invokableClassName != null ? this._invokableClassName.equals(other._invokableClassName) : other._invokableClassName == null)) {
            return false;
        }
        if (!(this._classLoader != null ? this._classLoader.equals(other._classLoader) : other._classLoader == null)) {
            return false;
        }
        if (!Arrays.equals(this._params, other._params)) {
            return false;
        }
        if (!(this._name != null ? this._name.equals(other._name) : other._name == null)) {
            return false;
        }
        if (!(this._description != null ? this._description.equals(other._description) : other._description == null)) {
            return false;
        }
        if (!(this._descriptionURL != null ? this._descriptionURL.equals(other._descriptionURL) : other._descriptionURL == null)) {
            return false;
        }
        if (!(this._iconFilePath != null ? this._iconFilePath.equals(other._iconFilePath) : other._iconFilePath == null)) {
            return false;
        }
        if (!(this._iconMetaResource != null ? this._iconMetaResource.equals(other._iconMetaResource) : other._iconMetaResource == null)) {
            return false;
        }
        if (this._unsorted != other._unsorted) {
            return false;
        }
        if (!Arrays.equals(this._technologyKeys, other._technologyKeys)) {
            return false;
        }
        return this._ruleId != null ? this._ruleId.equals(other._ruleId) : other._ruleId == null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("path=").append(Arrays.toString(this._path));
        b.append("; name=").append(this._name);
        b.append("; id=").append(this._id);
        b.append("; description=").append(this._description);
        b.append("; invokable=").append(this._invokable);
        b.append("; class=").append(this._invokableClassName);
        b.append("; class loader=").append(this._classLoader);
        b.append("; params=").append(Arrays.toString(this._params));
        b.append("; unsorted=").append(this._unsorted);
        b.append("; icon file=").append(this._iconFilePath);
        b.append("; icon resource=").append(this._iconMetaResource);
        b.append("; resource key=").append(this._resClass);
        b.append("; technologies=").append(Arrays.toString(this._technologyKeys));
        return b.toString();
    }

    public GalleryElement createElement() {
        GalleryElement ele = new GalleryElement(this.getInvokable());
        ele.setInvokableClassLoader(this.getInvokableClassLoader());
        ele.setInvokableClass(this.getInvokableClassName());
        ele.setName(this.getName());
        ele.setId(this.getId());
        ele.setDescription(this.getDescription());
        ele.setIconFile(this.getIconFile());
        ele.setIconMetaResource(this.getIconMetaResource());
        ele.setUnsorted(this.isUnsorted());
        ele.setWizardParameters(this.getWizardParameters());
        ele.setTechnologyKeys(this.getTechnologyKeys());
        ele.setRule(this.getRule());
        ele.setAddToNewMenu(this.canAddToNewMenu());
        return ele;
    }

    static String[] makePath(String categoryName, String folderName) {
        String[] stringArray;
        if (folderName == null) {
            throw new NullPointerException("folderName must not be null.");
        }
        if (categoryName == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = folderName;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = categoryName;
            stringArray = stringArray3;
            stringArray3[1] = folderName;
        }
        return stringArray;
    }

    private void pathMustHaveNoNullElements(Object[] path) {
        if (path == null) {
            throw new NullPointerException("path is null");
        }
        for (int i = 0; i < path.length; ++i) {
            if (path[i] != null) continue;
            throw new NullPointerException("path element " + i + " is null");
        }
    }
}

