/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import oracle.bali.ewt.graphics.ColorUtils;
import oracle.ide.Context;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.gallery.GalleryElementHierarchyMgr;
import oracle.ide.natives.accessibility.HighContrast;
import oracle.ide.nulls.NullIcon;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.RichHintLabel;
import oracle.javatools.ui.themes.LinearGradientPainter;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.Themes;
import oracle.javatools.util.ModelUtil;

final class GalleryItemsListCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final Icon NULL_ICON = new NullIcon();
    private static final boolean FORCIBLY_HIDE_DESCRIPTIONS = Boolean.parseBoolean(System.getProperty("hide-gallery-descriptions"));
    private static final boolean HIGH_CONTRAST = HighContrast.isHighContrastModeEnabled();
    private final Color hc_listForeground = UIManager.getColor("List.foreground");
    private final Color hc_selectionHighlightColor = UIManager.getColor("List.selectionForeground");
    private final Color hc_inactiveText = UIManager.getColor("textInactiveText");
    private final Color hc_selectionHighlightBackground = UIManager.getColor("List.selectionBackground");
    private final Color hc_listBackground = UIManager.getColor("List.background");
    private final Color descriptionForegroundColor = Colors.HINT_TEXT;
    private final Color selectionHighlightColor = new Color(216, 236, 253);
    private final Color bandingBackgroundColor = new Color(250, 250, 250);
    private Color _gradientLightColor = Themes.isThemed() ? Colors.GRADIENT_SELECTION_LIGHT : UIManager.getColor("List.selectionBackground");
    private Color _gradientDarkColor = Themes.isThemed() ? Colors.GRADIENT_SELECTION_DARK : UIManager.getColor("List.selectionBackground");
    private Color _selectedForegroundColor = Themes.isThemed() ? Color.BLACK : UIManager.getColor("List.selectionForeground");
    private Color _unselectedForegroundColor = Color.BLACK;
    private final transient Border _itemBorder = BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(200, 200, 200));
    private final transient Border _selectedItemBorder = BorderFactory.createCompoundBorder(this._itemBorder, BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("Tree.selectionBorderColor")));
    private transient Painter _selectedPainter = this.createSelectionPainter();
    private final DefaultListCellRenderer _automationRenderer = new DefaultListCellRenderer();
    private final JLabel _titleLabel = new JLabel();
    private final RichHintLabel _descriptionLabel = new RichHintLabel();
    private final JPanel _indicatorsPanel = new JPanel();
    private final JLabel _indicatorLabel = new JLabel();
    private final transient Context _context;
    private final transient GalleryElementHierarchyMgr _elementHierarchyMgr;
    private transient GalleryElement _element;
    private transient AccessibleContext _accessibleContext;
    private StyleSheet _styleSheet;
    private boolean _selected;
    private boolean _layoutDone;
    private int _selectedIndex;
    private boolean _showCategory;
    private boolean _showAllDescriptions;

    GalleryItemsListCellRenderer(Context context, GalleryElementHierarchyMgr hierarchyMgr, boolean showAllDescriptions) {
        this._context = context;
        this._elementHierarchyMgr = hierarchyMgr;
        this._showAllDescriptions = showAllDescriptions;
    }

    private void layoutComponents() {
        if (!this._layoutDone) {
            this._layoutDone = true;
            this.setLayout(new GridBagLayout());
            this.add((Component)this._indicatorsPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(5, 5, 5, 0), 0, 0));
            this._indicatorsPanel.setOpaque(false);
            this.add((Component)this._titleLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
            this.add((Component)this._descriptionLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 5, 0), 0, 0));
            this.setOpaque(false);
            this.updateUI();
            this._indicatorsPanel.setLayout(new BoxLayout(this._indicatorsPanel, 0));
            this._indicatorsPanel.add(this._indicatorLabel);
            StyleSheet styles = this.getStyleSheet();
            ((HTMLEditorKit)this._descriptionLabel.getEditorKit()).getStyleSheet().addStyleSheet(styles);
        }
    }

    private Painter createSelectionPainter() {
        return new LinearGradientPainter(this._gradientLightColor, this._gradientDarkColor, 1);
    }

    @Override
    public final void paintComponent(Graphics g) {
        if (this._selected) {
            this._selectedPainter.paint(g, 0, 0, this.getWidth(), this.getHeight());
        } else {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        super.paintComponent(g);
    }

    public final Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Insets inset;
        int preferredWidth;
        this._element = (GalleryElement)value;
        if (!SwingUtilities.isEventDispatchThread()) {
            return this;
        }
        String itemName = this.getTitle(this._element);
        boolean enabled = this._element.isAvailable(this._context) && list.isEnabled();
        Icon icon = enabled ? this._element.getIcon() : this._element.getDisabledIcon();
        boolean bl = this._selected = list.isEnabled() && index == this._selectedIndex;
        if (FORCIBLY_HIDE_DESCRIPTIONS) {
            JLabel component = (JLabel)this._automationRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this._titleLabel.setText(itemName);
            component.setText(itemName);
            component.setIcon(icon != null ? icon : NULL_ICON);
            if (!enabled) {
                component.setForeground(UIManager.getColor("textInactiveText"));
            }
            return component;
        }
        this.layoutComponents();
        this.setBorder(this._selected && cellHasFocus ? this._selectedItemBorder : this._itemBorder);
        this._titleLabel.setFont(this._selected ? this._titleLabel.getFont().deriveFont(1) : this._titleLabel.getFont().deriveFont(0));
        this._indicatorLabel.setIcon(icon != null ? icon : NULL_ICON);
        this._titleLabel.setEnabled(enabled);
        this._titleLabel.setText(itemName);
        String para = "<p>";
        if (this._selected && enabled) {
            para = "<p class=itemselected>";
        } else if (!enabled || !list.isEnabled()) {
            para = "<p class=itemdisabled>";
        }
        String description = this.getDescription(this._element);
        if (!ModelUtil.hasLength((String)description)) {
            this._descriptionLabel.setVisible(false);
        } else {
            this._descriptionLabel.setText(para + description);
            this._descriptionLabel.setVisible(true);
        }
        this.colorControls(index, list.isEnabled(), this._selected);
        this._descriptionLabel.setSize(0, 0);
        this.setPreferredSize(null);
        Container parent = list.getParent();
        if (parent != null && parent instanceof JViewport) {
            preferredWidth = ((JViewport)parent).getExtentSize().width;
            inset = ((JViewport)parent).getInsets();
            preferredWidth -= inset.left + inset.right;
        } else {
            preferredWidth = list.getWidth();
            inset = list.getInsets();
            preferredWidth -= inset.left + inset.right;
        }
        if (preferredWidth > 0) {
            int originalDescWidth;
            int minWidth = this._calculateMinimumWidth();
            int descWidth = this._calculateDescriptionWidth(preferredWidth);
            if (descWidth < (originalDescWidth = this._descriptionLabel.getPreferredSize().width)) {
                descWidth = Math.max(descWidth, 100);
                this._descriptionLabel.setSize(descWidth, this._descriptionLabel.getPreferredSize().height);
            }
            this.setPreferredSize(new Dimension(preferredWidth, this.getPreferredSize().height));
            preferredWidth = Math.max(preferredWidth, minWidth);
            if (list.getFixedCellWidth() != preferredWidth) {
                list.setFixedCellWidth(preferredWidth);
            }
        }
        return this;
    }

    void setSelectedIndex(int selectedIndex) {
        this._selectedIndex = selectedIndex;
    }

    public final String getText() {
        return this._titleLabel.getText();
    }

    private String getTitle(GalleryElement listItem) {
        StringBuilder sb = new StringBuilder();
        if (listItem != null) {
            sb.append(listItem.getName());
            if (this._showCategory) {
                sb.append(" (");
                sb.append(this._elementHierarchyMgr.getParentFolder(listItem));
                sb.append(")");
            }
        }
        return sb.toString();
    }

    private String getDescription(GalleryElement listItem) {
        if (listItem != null && !FORCIBLY_HIDE_DESCRIPTIONS && (this._showAllDescriptions || this._selected)) {
            return listItem.getDescription();
        }
        return null;
    }

    private StyleSheet getStyleSheet() {
        if (this._styleSheet == null) {
            this._styleSheet = new StyleSheet();
            String s = "p.itemselected { color: " + ColorUtils.colorToHTML((Color)(Themes.isThemed() ? Color.BLACK : UIManager.getColor("List.selectionForeground"))) + ";}";
            this._styleSheet.addRule(s);
            s = "p.itemdisabled { color: " + ColorUtils.colorToHTML((Color)UIManager.getColor("textInactiveText")) + ";}";
            this._styleSheet.addRule(s);
            s = "p { color: " + ColorUtils.colorToHTML((Color)this.hc_listForeground) + ";}";
            if (HIGH_CONTRAST) {
                this._styleSheet.addRule(s);
            }
        }
        return this._styleSheet;
    }

    private int _calculateDescriptionWidth(int width) {
        int remainingWidth = this.getPreferredSize().width;
        return width -= (remainingWidth -= this._descriptionLabel.getPreferredSize().width);
    }

    private int _calculateMinimumWidth() {
        int width = this.getPreferredSize().width;
        int remainingWidth = this._descriptionLabel.getPreferredSize().width;
        width -= remainingWidth;
        return width += Math.min(100, remainingWidth);
    }

    private void colorControls(int index, boolean enabled, boolean selected) {
        if (HIGH_CONTRAST) {
            Color fg = enabled ? (selected ? this.hc_selectionHighlightColor : this.hc_listForeground) : this.hc_inactiveText;
            this._titleLabel.setForeground(fg);
            this._descriptionLabel.setForeground(fg);
            this.setBackground(selected ? this.hc_selectionHighlightBackground : this.hc_listBackground);
        } else {
            Color bgcolor;
            Color fgcolor;
            if (enabled) {
                fgcolor = selected ? this._selectedForegroundColor : this._unselectedForegroundColor;
                bgcolor = index % 2 == 0 ? SystemColor.WHITE : this.bandingBackgroundColor;
            } else {
                fgcolor = UIManager.getColor("textInactiveText");
                bgcolor = UIManager.getColor("control");
            }
            this._titleLabel.setForeground(fgcolor);
            this._descriptionLabel.setForeground(selected ? this._selectedForegroundColor : this.descriptionForegroundColor);
            this.setBackground(selected ? this.selectionHighlightColor : bgcolor);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this._accessibleContext == null) {
            this._accessibleContext = new AccessibleListRenderer();
        }
        return this._accessibleContext;
    }

    boolean isShowCategory() {
        return this._showCategory;
    }

    void setShowCategory(boolean showCategory) {
        this._showCategory = showCategory;
    }

    private class AccessibleListRenderer
    extends JComponent.AccessibleJComponent {
        private AccessibleListRenderer() {
            super(GalleryItemsListCellRenderer.this);
        }

        @Override
        public String getAccessibleName() {
            String description;
            StringBuffer sb = new StringBuffer();
            String title = GalleryItemsListCellRenderer.this.getTitle(GalleryItemsListCellRenderer.this._element);
            if (ModelUtil.hasLength((String)title)) {
                sb.append(title);
            }
            if (ModelUtil.hasLength((String)(description = GalleryItemsListCellRenderer.this.getDescription(GalleryItemsListCellRenderer.this._element)))) {
                sb.append(" ");
                sb.append(description);
            }
            return sb.toString();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST_ITEM;
        }
    }
}

