/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.ceditor.tint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.ceditor.tint.TintProvider;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ideimpl.ceditor.tint.TintProviderReference;
import oracle.javatools.data.HashStructure;

final class TintHook
extends HashStructureHook {
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "ceditor-tint");
    private Collection<TintProviderReference> providers;

    TintHook() {
    }

    public static TintHook get() {
        return (TintHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
    }

    Collection<TintProviderReference> providers() {
        if (this.providers == null) {
            this.providers = new ArrayList<TintProviderReference>();
            TintHook.get().addHashStructureHookListener(new HashStructureHookListener(){

                public void elementVisited(HashStructureHookEvent e) {
                    TintHook.this.addProviders(e.getNewElementHashStructure());
                }

                public void listenerAttached(HashStructureHookEvent e) {
                    TintHook.this.addProviders(e.getCombinedHashStructure());
                }
            });
        }
        return this.providers;
    }

    private void addProviders(HashStructure hookHash) {
        List newProviders = hookHash.getAsList("provider");
        if (newProviders == null) {
            return;
        }
        for (Object o : newProviders) {
            HashStructure hsProvider = (HashStructure)o;
            String name = hsProvider.getString("name");
            MetaClass clazz = LazyClassAdapter.getInstance((HashStructure)hsProvider).getMetaClass("class");
            this.providers.add(new TintProviderReference(name, (MetaClass<TintProvider>)clazz));
        }
    }
}

