/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.compiler;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleDriver;

public class CompilerConnection {
    private String url;
    private Connection connection;

    public CompilerConnection() {
    }

    public CompilerConnection(String url) {
        this.url = url;
    }

    public boolean inServer() {
        String vendor = System.getProperty("java.vendor");
        return vendor.indexOf("Oracle") >= 0;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection == null) {
            OracleDriver driver = new OracleDriver();
            DriverManager.registerDriver((Driver)new OracleDriver());
            if (this.inServer()) {
                this.connection = driver.defaultConnection();
            } else if (this.url != null) {
                this.connection = DriverManager.getConnection(this.url);
            } else {
                throw new SQLException("in CompilerConnection.getConnection:  we are running on client but no url was specified");
            }
        }
        this.connection.setAutoCommit(false);
        return this.connection;
    }

    public void commit() throws SQLException {
        if (this.connection != null) {
            this.connection.commit();
        }
    }
}

