/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import com.sun.jmx.remote.security.FileLoginModule;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.URL;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import oracle.aurora.rdbms.MXBeanFactory;
import oracle.aurora.rdbms.Schema;
import sun.management.Agent;
import sun.rmi.transport.Transport;
import sun.rmi.transport.tcp.TCPEndpoint;
import sun.rmi.transport.tcp.TCPTransport;

public class JMXAgent
extends Agent {
    private static String toURL(String name, String ext, boolean addExt) {
        if (name.endsWith(ext)) {
            name = name.substring(0, name.lastIndexOf(ext));
        }
        name = name.replace('.', '/');
        name = name.replace(File.separator, "/");
        if (addExt) {
            name = name + ext;
        }
        return name;
    }

    private static String toFileName(String name, String ext, boolean addExt) {
        if (name.endsWith(ext)) {
            name = name.substring(0, name.lastIndexOf(ext));
        }
        name = name.replace("/", File.separator);
        name = name.replace(".", File.separator);
        if (addExt) {
            name = name + ext;
        }
        return name;
    }

    private static boolean loadFromResource(String name, Properties p) {
        try {
            String url_string = "jserver:/resource/schema/" + Schema.currentSchema().name().toString() + "/" + JMXAgent.toURL(name, ".properties", true);
            URL url = new URL(url_string);
            InputStream is = url.openConnection().getInputStream();
            p.load(is);
            is.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readConfiguration(Properties p) {
        File configFile;
        String fname = System.getProperty("com.sun.management.config.file", "lib.management.management.properties");
        if (JMXAgent.loadFromResource(fname, p)) {
            return;
        }
        if (System.getProperty("com.sun.management.config.file") == null) {
            String home = System.getProperty("java.home");
            if (home == null) {
                throw new Error("Can't find java.home ??");
            }
            fname = home + File.separator + JMXAgent.toFileName(fname, ".properties", true);
        }
        if (!(configFile = new File(fname)).exists()) {
            ResourceBundle resources = null;
            try {
                resources = ResourceBundle.getBundle("sun.management.management");
            }
            catch (MissingResourceException mre) {
                JMXAgent.error((String)"missing resource bundle sun.management.management");
            }
            Enumeration<String> en = resources.getKeys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                String val = resources.getString(key);
                p.setProperty(key, val);
            }
            return;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(configFile);
            BufferedInputStream bin = new BufferedInputStream(in);
            p.load(bin);
        }
        catch (FileNotFoundException e) {
            JMXAgent.error((String)"agent.err.configfile.failed", (String)e.getMessage());
        }
        catch (IOException e) {
            JMXAgent.error((String)"agent.err.configfile.failed", (String)e.getMessage());
        }
        catch (SecurityException e) {
            JMXAgent.error((String)"agent.err.configfile.access.denied", (String)fname);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    JMXAgent.error((String)"agent.err.configfile.closed.failed", (String)fname);
                }
            }
        }
    }

    public static void premain(String args) throws Exception {
        singleton = new JMXAgent();
        singleton.premain2(args);
    }

    public static void startOJVMAgent(String port, String ssl, String auth) {
        System.setProperty("com.sun.management.jmxremote", "true");
        try {
            if (port != null) {
                System.setProperty("com.sun.management.jmxremote.port", port);
            }
            if (ssl != null) {
                System.setProperty("com.sun.management.jmxremote.ssl", ssl);
            }
            if (auth != null) {
                String auth_lc = auth.toLowerCase();
                if (!auth_lc.equals("false") && !auth_lc.equals("true")) {
                    System.setProperty("com.sun.management.jmxremote.authenticate", "true");
                    FileLoginModule.addCredentialsList((String)auth);
                } else {
                    System.setProperty("com.sun.management.jmxremote.authenticate", auth);
                }
            }
            if (System.getProperty("com.sun.management.agent.class") == null) {
                // empty if block
            }
            System.setProperty("com.sun.management.agent.class", "oracle.aurora.rdbms.JMXAgent");
            JMXAgent.startAgent();
            MXBeanFactory.createOracleMXBeans();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            JMXAgent.error((Exception)e);
        }
    }

    private static TCPTransport getTransport() {
        try {
            String portString = System.getProperty("com.sun.management.jmxremote.port");
            int port = Integer.parseInt(portString);
            TCPEndpoint jmxep = TCPEndpoint.getLocalEndpoint(port, null, null);
            Transport it = jmxep.getInboundTransport();
            if (!(it instanceof TCPTransport)) {
                return null;
            }
            return (TCPTransport)it;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void closeServerSocket(ServerSocket ss) {
        if (ss != null) {
            try {
                ss.close();
            }
            catch (IOException ex) {
                System.out.println("-- got: " + ex);
            }
        }
    }
}

