/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.security.CodeSource;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import oracle.aurora.rdbms.ClassHandle;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.NonDelegatingClassLoader;
import oracle.aurora.rdbms.ObjectTypeChangedException;
import oracle.aurora.rdbms.Resolver;
import sun.reflect.Reflection;

public final class NonDelegatingSessionPrivateClassLoader
extends NonDelegatingClassLoader {
    protected Resolver _resolver;
    protected FQNPredicate _predicate;
    private static TrustedPD _trustedPD = new TrustedPD();

    protected NonDelegatingSessionPrivateClassLoader(ClassLoader parent, Resolver resolver, FQNPredicate predicate) {
        super(parent);
        this._resolver = resolver;
        this._predicate = predicate;
    }

    public static NonDelegatingSessionPrivateClassLoader getSYSInstance(FQNPredicate predicate) {
        if (Reflection.getCallerClass((int)2).getClassLoader() != null) {
            throw new SecurityException("only system classes may access the trusted private classloader");
        }
        return new NonDelegatingSessionPrivateClassLoader(null, Resolver.defaultResolver(), predicate);
    }

    protected boolean delegate_p(String fqn) {
        return !this._predicate.conforms(fqn);
    }

    protected native Class findPreviouslyLoaded_(String var1);

    private native void memoizeLoadedClass(Handle var1, Class var2);

    protected Class findClass(String fqn) throws ClassNotFoundException {
        Class<?> clazz = null;
        String normalized_name = fqn.replace('.', '/');
        ClassHandle ref = (ClassHandle)Handle.lookup(normalized_name, this._resolver, 29, false);
        if (ref != null) {
            try {
                byte[] bits = ref.data();
                clazz = this.defineClass(fqn, bits, 0, bits.length, _trustedPD);
                this.memoizeLoadedClass(ref, clazz);
                return clazz;
            }
            catch (ObjectTypeChangedException e) {
                throw new ClassNotFoundException(fqn + " (class changed)");
            }
        }
        throw new ClassNotFoundException(fqn);
    }

    private static class TrustedPD
    extends ProtectionDomain {
        TrustedPD() {
            super(new CodeSource(null, (Certificate[])null), null);
        }

        public boolean implies(Permission permission) {
            return true;
        }

        public String toString() {
            return "TrustedProtectionDomain";
        }
    }

    public static abstract class FQNPredicate {
        public abstract boolean conforms(String var1);
    }
}

