/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.IOException;
import java.io.Writer;

public class Statistics
implements Cloneable {
    protected int nSamples;
    protected double minimum;
    protected double maximum;
    protected double accum;
    protected double squares;

    public Statistics copy() {
        try {
            return (Statistics)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("clone error");
        }
    }

    public synchronized Statistics copySync() {
        return this.copy();
    }

    public void reset() {
        this.nSamples = 0;
        this.squares = 0.0;
        this.accum = 0.0;
        this.maximum = 0.0;
        this.minimum = 0.0;
    }

    public void accumulate(Statistics s) {
        if (s.nSamples == 0) {
            return;
        }
        this.nSamples += s.nSamples;
        this.accum += s.accum;
        this.squares += s.squares;
        if (this.nSamples > 0) {
            if (s.minimum < this.minimum) {
                this.minimum = s.minimum;
            }
            if (s.maximum > this.maximum) {
                this.maximum = s.maximum;
            }
        } else {
            this.minimum = s.minimum;
            this.maximum = s.maximum;
        }
    }

    public void sample(double datum) {
        ++this.nSamples;
        this.accum += datum;
        this.squares += datum * datum;
        if (this.nSamples > 0) {
            if (datum < this.minimum) {
                this.minimum = datum;
            }
            if (datum > this.maximum) {
                this.maximum = datum;
            }
        } else {
            this.minimum = datum;
            this.maximum = datum;
        }
    }

    public synchronized void sampleSync(double datum) {
        this.sample(datum);
    }

    public int nSamples() {
        return this.nSamples;
    }

    public double total() {
        return this.accum;
    }

    public double minimum() {
        return this.nSamples > 0 ? this.minimum : Double.NaN;
    }

    public double maximum() {
        return this.nSamples > 0 ? this.maximum : Double.NaN;
    }

    public double mean() {
        return this.nSamples > 0 ? this.accum / (double)this.nSamples : Double.NaN;
    }

    public double variance() {
        if (this.nSamples == 0) {
            return Double.NaN;
        }
        double mean = this.mean();
        return (this.squares - 2.0 * this.accum * mean + (double)this.nSamples * mean * mean) / (double)this.nSamples;
    }

    public double stdDev() {
        return this.nSamples > 0 ? Math.sqrt(this.variance()) : Double.NaN;
    }

    public void dump(Writer w) throws IOException {
        w.write("Stats\n  nSamples: " + this.nSamples() + "\n" + "  minimum: " + this.minimum() + "\n" + "  maximum: " + this.maximum() + "\n" + "  mean: " + this.mean() + "\n" + "  stdDev: " + this.stdDev());
    }

    public synchronized void dumpSync(Writer w) throws IOException {
        this.dump(w);
    }
}

