/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.classfile;

import oracle.aurora.util.classfile.Dig;
import oracle.aurora.util.classfile.Lnkd;
import oracle.aurora.util.xclass.NotKnownException;
import oracle.aurora.util.xclass.Signature;
import oracle.aurora.util.xclass.XAttribute;
import oracle.aurora.util.xclass.XAttributes;
import oracle.aurora.util.xclass.XBytes;
import oracle.aurora.util.xclass.XClass;
import oracle.aurora.util.xclass.XClasses;
import oracle.aurora.util.xclass.XCode;
import oracle.aurora.util.xclass.XConstant;
import oracle.aurora.util.xclass.XConstants;
import oracle.aurora.util.xclass.XExceptionHandler;
import oracle.aurora.util.xclass.XExceptionHandlers;
import oracle.aurora.util.xclass.XField;
import oracle.aurora.util.xclass.XFields;
import oracle.aurora.util.xclass.XFinder;
import oracle.aurora.util.xclass.XKinds;
import oracle.aurora.util.xclass.XMember;
import oracle.aurora.util.xclass.XMethod;
import oracle.aurora.util.xclass.XMethods;
import oracle.aurora.util.xclass.XType;

public class LnkdX {
    private static final String idCode = "code";
    private Lnkd.Class lnkdClass;
    private Dig.Class digClass;
    private Lnkd.ConstantPool lnkdConstants;
    private Class xClass;
    private XFinder xFinder;
    private Signature typeFactory;

    public LnkdX(Lnkd.Class lnkdClass) {
        this.lnkdClass = lnkdClass;
        this.digClass = lnkdClass.getDig();
        this.xClass = new Class();
        this.lnkdConstants = lnkdClass.getConstants();
    }

    public Lnkd.Class getLnkdClass() {
        return this.lnkdClass;
    }

    Dig.Class getDigClass() {
        return this.digClass;
    }

    Class getXClass() {
        return this.xClass;
    }

    XFinder getFinder() {
        if (this.xFinder == null) {
            Lnkd.Finder lnkdFinder = this.getLnkdClass().getLnkd().getFinder();
            this.xFinder = new Finder(this.getXClass().name(), lnkdFinder);
        }
        return this.xFinder;
    }

    Signature getTypeFactory() {
        if (this.typeFactory == null) {
            this.typeFactory = new Signature(this.getFinder());
        }
        return this.typeFactory;
    }

    XType myType(String descriptor) {
        try {
            return this.getTypeFactory().make(descriptor);
        }
        catch (Signature.BadlyFormedException bex) {
            throw new NotKnownException(bex.getMessage());
        }
    }

    static void NYI() {
        throw new NotKnownException("NYI");
    }

    public static class Finder
    implements XFinder {
        String from;
        Lnkd.Finder lnkdFinder;

        Finder(String from, Lnkd.Finder lnkdFinder) {
            this.from = from;
            this.lnkdFinder = lnkdFinder;
        }

        public XClass find(String name) throws ClassNotFoundException {
            XClass xClass = null;
            Lnkd lnkd = this.lnkdFinder.find(name);
            if (lnkd != null) {
                xClass = lnkd.getXClass();
            }
            if (xClass == null) {
                throw new ClassNotFoundException(name + " from " + this.from);
            }
            return xClass;
        }
    }

    public class Attribute
    extends XAttribute.Abstract
    implements XAttribute {
        Dig.Attribute dig;

        Attribute(Dig.Attribute dig) {
            this.dig = dig;
        }

        public XClass containing() {
            return LnkdX.this.getXClass();
        }

        public String name() {
            return this.dig.getName();
        }

        public XBytes value() {
            return new XBytes(this.dig.getData());
        }
    }

    public class Attributes
    implements XAttributes {
        Dig.Attributes dig;

        Attributes(Dig.Attributes dig) {
            this.dig = dig;
        }

        public XClass containing() {
            return LnkdX.this.getXClass();
        }

        public int size() {
            return this.dig == null ? 0 : this.dig.count();
        }

        public XAttribute get(int index) {
            if (this.dig == null) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return new Attribute(this.dig.get(index));
        }

        public XAttribute lookup(String name) {
            return this.dig == null ? null : new Attribute(this.dig.get(name));
        }
    }

    public class FieldRef
    extends MemberRef
    implements XField {
        FieldRef(int index) {
            super(index);
        }
    }

    public class FieldDef
    extends MemberDef
    implements XField {
        FieldDef(Lnkd.Member lnkd) {
            super(lnkd);
        }
    }

    public class ExceptionHandler
    implements XExceptionHandler {
        Dig.ExceptionHandler dig;

        ExceptionHandler(Dig.ExceptionHandler dig) {
            this.dig = dig;
        }

        public int startPc() {
            return this.dig.getStartPc();
        }

        public int endPc() {
            return this.dig.getEndPc();
        }

        public int handlerPc() {
            return this.dig.getHandlerPc();
        }

        public XClass exceptionClass() {
            return LnkdX.this.getTypeFactory().makeClass(this.dig.getExceptionClass()).toClass();
        }
    }

    public class ExceptionHandlers
    implements XExceptionHandlers {
        Dig.ExceptionHandlers dig;

        ExceptionHandlers(Dig.ExceptionHandlers dig) {
            this.dig = dig;
        }

        public XClass containing() {
            return LnkdX.this.getXClass();
        }

        public int size() {
            return this.dig.getSize();
        }

        public XExceptionHandler get(int index) {
            return new ExceptionHandler(this.dig.get(index));
        }
    }

    public class Code
    implements XCode {
        Dig.Code dig;

        Code(Dig.Code dig) {
            this.dig = dig;
        }

        public XBytes bytecodes() {
            return new XBytes(this.dig.getBytecodes());
        }

        public int maxStack() {
            return this.dig.getMaxStack();
        }

        public int maxLocals() {
            return this.dig.getMaxLocals();
        }

        public XExceptionHandlers exceptionHandlers() {
            LnkdX.NYI();
            return null;
        }

        public XAttributes attributes() {
            LnkdX.NYI();
            return null;
        }
    }

    public class MethodRef
    extends MemberRef
    implements XMethod {
        MethodRef(int index) {
            super(index);
        }

        public XType[] exceptionTypes() {
            LnkdX.NYI();
            return null;
        }

        public XCode code() {
            Dig.Attribute codeAttr = this.digMember().getAttributes().get(LnkdX.idCode);
            Dig.Code digCode = LnkdX.this.digClass.makeCode(codeAttr);
            return new Code(digCode);
        }
    }

    public class MemberRef
    extends Constant
    implements XMember {
        Dig.Member digMember_;

        MemberRef(int index) {
            super(index);
        }

        Dig.Member digMember() {
            if (this.digMember_ == null) {
                this.digMember_ = this.lnkdConstant().getMember().getDig();
            }
            return this.digMember_;
        }

        public XAttributes attributes() {
            Dig.Attributes digA = this.lnkdConstant().getMember().getDig().getAttributes();
            return new Attributes(digA);
        }

        public XAttributes envAttributes() {
            return new Attributes(null);
        }

        public int modifiers() {
            return this.digMember().getModifiers();
        }

        public String name() {
            return this.digPool().getNameOfRef(this.index);
        }

        public String signature() {
            return this.digPool().getDescriptorOfRef(this.index);
        }

        public XType type() {
            LnkdX.NYI();
            return null;
        }

        public XClass declaring() {
            Lnkd.Class mClass = this.lnkdConstant().getMember().getDeclaring();
            return mClass.getLnkd().getXClass();
        }

        public String declaringName() {
            return this.digPool().getDeclaringClass(this.index);
        }

        public boolean isMethod() {
            return this.kind() != 9;
        }
    }

    public class MethodDef
    extends MemberDef
    implements XMethod {
        MethodDef(Lnkd.Member lnkdMember) {
            super(lnkdMember);
        }

        public XType[] exceptionTypes() {
            LnkdX.NYI();
            return null;
        }

        public XCode code() {
            Dig.Attribute codeAttr = this.lnkdMember.getAttributes().get(LnkdX.idCode);
            Dig.Code digCode = LnkdX.this.digClass.makeCode(codeAttr);
            return new Code(digCode);
        }
    }

    public class MemberDef
    implements XMember {
        Lnkd.Member lnkdMember;

        MemberDef(Lnkd.Member lnkdMember) {
            this.lnkdMember = lnkdMember;
        }

        public XAttributes attributes() {
            return new Attributes(this.lnkdMember.getDig().getAttributes());
        }

        public XAttributes envAttributes() {
            return new Attributes(null);
        }

        public int modifiers() {
            return this.lnkdMember.getDig().getModifiers();
        }

        public String name() {
            return this.lnkdMember.getDig().getName();
        }

        public XType type() {
            return LnkdX.this.myType(this.signature());
        }

        public String signature() {
            return this.lnkdMember.getDig().getDescriptor();
        }

        public XClass declaring() {
            return this.lnkdMember.getDeclaring().getLnkd().getXClass();
        }

        public String declaringName() {
            return this.lnkdMember.getDeclaring().getName();
        }

        public boolean isMethod() {
            return this.lnkdMember.getDig().isMethod();
        }
    }

    public class FieldDefs
    extends XFields.Abstract
    implements XFields {
        Lnkd.Fields fields;

        FieldDefs() {
            this.fields = LnkdX.this.getLnkdClass().getFields();
        }

        public XClass containing() {
            return LnkdX.this.getXClass();
        }

        public int size() {
            return this.fields.count();
        }

        public XField get(int index) {
            return new FieldDef(this.fields.get(index));
        }
    }

    public class MethodDefs
    extends XMethods.Abstract
    implements XMethods {
        Lnkd.Methods methods;

        MethodDefs() {
            this.methods = LnkdX.this.getLnkdClass().getMethods();
        }

        public XClass containing() {
            return LnkdX.this.getXClass();
        }

        public int size() {
            return this.methods.count();
        }

        public XMethod get(int index) {
            return new MethodDef(this.methods.get(index));
        }
    }

    public class Constant
    implements XConstant,
    XKinds {
        protected final int index;
        Lnkd.Constant lnkdConstant;
        Lnkd.Member member_;

        Constant(int index) {
            this.index = index;
        }

        public XConstants pool() {
            return LnkdX.this.getXClass().constants();
        }

        public int index() {
            return this.index;
        }

        public int kind() {
            return this.digPool().getConstantType(this.index);
        }

        public XType toType() {
            return LnkdX.this.myType(this.signature());
        }

        public XClass toClass() {
            XType type = this.toType();
            return type == null ? null : type.toClass();
        }

        Lnkd.Member toMember() {
            if (this.member_ == null && this.hasLnkd()) {
                this.member_ = this.lnkdConstant().getMember();
            }
            return this.member_;
        }

        public XMethod toMethod() {
            XMethod method = null;
            if (this instanceof XMethod) {
                method = (XMethod)((Object)this);
            } else {
                Lnkd.Member member = this.toMember();
                if (member != null && member.isMethod()) {
                    method = new MethodDef(member);
                }
            }
            return method;
        }

        public XField toField() {
            XField field = null;
            if (this instanceof XField) {
                field = (XField)((Object)this);
            } else {
                Lnkd.Member member = this.toMember();
                if (member != null && !member.isMethod()) {
                    field = new FieldDef(member);
                }
            }
            return field;
        }

        public String getString() {
            return this.digPool().toString(this.index);
        }

        public String signature() {
            String s = null;
            Dig.ConstantPool pool = this.digPool();
            if (pool.isRef(this.index)) {
                s = pool.getDescriptorOfRef(this.index);
            } else if (pool.is(this.index, 7)) {
                s = "L" + this.getString() + ";";
            } else if (pool.is(this.index, 8)) {
                s = "Ljava/lang/String;";
            }
            return s;
        }

        public long toLong() {
            return this.digPool().getLong(this.index);
        }

        public double toDouble() {
            return this.digPool().getDouble(this.index);
        }

        Dig.ConstantPool digPool() {
            return LnkdX.this.getDigClass().getConstants();
        }

        Lnkd.Constant lnkdConstant() {
            if (this.lnkdConstant == null) {
                this.lnkdConstant = LnkdX.this.getLnkdClass().getConstants().get(this.index);
            }
            return this.lnkdConstant();
        }

        boolean hasLnkd() {
            Lnkd.Constant c = this.lnkdConstant();
            return c != null && c.ok();
        }
    }

    public class Constants
    implements XConstants {
        public XConstant get(int index) {
            return new Constant(index);
        }

        public int size() {
            return LnkdX.this.getDigClass().getConstants().size();
        }

        public XClass containing() {
            return LnkdX.this.getXClass();
        }
    }

    public class Classes
    implements XClasses {
        Lnkd[] lnkds;

        Classes(Lnkd[] lnkds) {
            this.lnkds = lnkds;
        }

        public XClass get(int index) {
            return this.lnkds[index].getXClass();
        }

        public int size() {
            return this.lnkds.length;
        }

        public XClass containing() {
            return LnkdX.this.getXClass();
        }
    }

    public class Class
    extends XClass.Abstract
    implements XClass {
        private Constants constants_;
        private MethodDefs methods_;
        private FieldDefs fields_;
        private Classes interfaces_;

        public String name() {
            return LnkdX.this.digClass.getName();
        }

        public int modifiers() {
            return LnkdX.this.digClass.getModifiers();
        }

        public XConstants constants() {
            if (this.constants_ == null) {
                this.constants_ = new Constants();
            }
            return this.constants_;
        }

        public XMethods methods() {
            if (this.methods_ == null) {
                this.methods_ = new MethodDefs();
            }
            return this.methods_;
        }

        public XFields fields() {
            if (this.fields_ == null) {
                this.fields_ = new FieldDefs();
            }
            return this.fields_;
        }

        public XClasses interfaces() {
            if (this.interfaces_ == null) {
                this.interfaces_ = new Classes(LnkdX.this.lnkdClass.getInterfaces());
            }
            return this.interfaces_;
        }

        public XAttributes attributes() {
            return new Attributes(LnkdX.this.digClass.getAttributes());
        }

        public XAttributes envAttributes() {
            return new Attributes(null);
        }

        public XFinder finder() {
            if (LnkdX.this.xFinder == null) {
                // empty if block
            }
            return LnkdX.this.xFinder;
        }

        public Object domain() {
            return ((LnkdX)LnkdX.this).lnkdClass.getLnkd().packageDomain;
        }

        public XClass superClass() {
            return LnkdX.this.lnkdClass.getSuperClass().getXClass();
        }

        public XClasses nestedClasses() {
            LnkdX.NYI();
            return null;
        }

        public XClass outerClass() {
            LnkdX.NYI();
            return null;
        }
    }
}

