/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.util.ModelUtil;

public class SchemaObjectDescriptor {
    private transient SystemObject m_obj;
    private String m_name;
    private String m_type;
    private String m_schema;
    private String m_dbName;
    private String m_otherName;

    private SchemaObjectDescriptor() {
    }

    public SchemaObjectDescriptor(String string, String string2, String string3) {
        this.m_name = string;
        this.m_type = string2;
        this.m_schema = string3;
    }

    public SchemaObjectDescriptor(SystemObject systemObject) {
        if (systemObject != null) {
            DBObjectID dBObjectID;
            this.m_name = systemObject.getName();
            this.m_type = systemObject.getType();
            if (systemObject instanceof SchemaObject) {
                dBObjectID = ((SchemaObject)systemObject).getSchema();
                String string = this.m_schema = dBObjectID != null ? dBObjectID.getName() : null;
            }
            if ((dBObjectID = systemObject.getID()) instanceof BaseObjectID) {
                this.m_dbName = ((BaseObjectID)dBObjectID).getDatabaseName();
            }
        }
        this.m_obj = systemObject;
    }

    public String getName() {
        return this.m_name;
    }

    @Deprecated
    public String getOriginalName() {
        return this.getName();
    }

    public String getType() {
        return this.m_type;
    }

    public String getSchema() {
        return this.m_schema;
    }

    public String getDatabaseName() {
        return this.m_dbName;
    }

    public SystemObject getObject() {
        return this.m_obj;
    }

    public String getOtherName() {
        return this.m_otherName;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void setDatabaseName(String string) {
        this.m_dbName = string;
    }

    @Deprecated
    public void setOriginalName(String string) {
        this.setName(string);
    }

    public void setType(String string) {
        this.m_type = string;
    }

    public void setSchema(String string) {
        this.m_schema = string;
    }

    public void setOtherName(String string) {
        this.m_otherName = string;
    }

    public boolean matches(BaseObjectID baseObjectID) {
        return baseObjectID != null && ModelUtil.areEqual((Object)this.getName(), (Object)baseObjectID.getName()) && ModelUtil.areEqual((Object)this.getType(), (Object)baseObjectID.getType()) && ModelUtil.areEqual((Object)this.getSchema(), (Object)baseObjectID.getSchemaName());
    }

    public boolean equals(Object object) {
        return object instanceof SchemaObjectDescriptor && this.equalsImpl((SchemaObjectDescriptor)object, false);
    }

    protected boolean equalsImpl(SchemaObjectDescriptor schemaObjectDescriptor, boolean bl) {
        return ModelUtil.areEqual((Object)this.getName(), (Object)schemaObjectDescriptor.getName()) && ModelUtil.areEqual((Object)this.getType(), (Object)schemaObjectDescriptor.getType()) && ModelUtil.areEqual((Object)this.getSchema(), (Object)schemaObjectDescriptor.getSchema()) && (!bl || ModelUtil.areEqual((Object)this.m_name, (Object)schemaObjectDescriptor.m_name));
    }

    public boolean equals(Object object, boolean bl) {
        return object instanceof SchemaObjectDescriptor && this.equalsImpl((SchemaObjectDescriptor)object, bl);
    }

    public Object copyTo(Object object) {
        SchemaObjectDescriptor schemaObjectDescriptor = object == null ? new SchemaObjectDescriptor() : (SchemaObjectDescriptor)object;
        this.copyToImpl(schemaObjectDescriptor);
        return schemaObjectDescriptor;
    }

    protected void copyToImpl(SchemaObjectDescriptor schemaObjectDescriptor) {
        schemaObjectDescriptor.m_name = this.m_name;
        schemaObjectDescriptor.m_schema = this.m_schema;
        schemaObjectDescriptor.m_type = this.m_type;
        schemaObjectDescriptor.m_dbName = this.m_dbName;
        schemaObjectDescriptor.m_otherName = this.m_otherName;
    }

    public String toString() {
        return this.getName() + " (" + this.getSchema() + ")";
    }

    public int hashCode() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_type).append(".").append(this.m_name);
        return stringBuilder.toString().hashCode();
    }

    public DBObjectCriteria<SystemObject> createCriteria() {
        DBObjectCriteria dBObjectCriteria = DBObjectCriteria.createSingleObjectCriteria((String)this.getType(), (String)this.getDatabaseName(), (String)this.getSchema(), (String)this.getName());
        return dBObjectCriteria;
    }

    public SystemObject findObject(DBObjectProvider dBObjectProvider) throws DBException {
        return this.findObject(dBObjectProvider, false);
    }

    public SystemObject findObject(DBObjectProvider dBObjectProvider, boolean bl) throws DBException {
        SystemObject systemObject = this.m_obj;
        if (dBObjectProvider != null) {
            DBObjectCriteria<SystemObject> dBObjectCriteria;
            if (!(systemObject == null || (dBObjectCriteria = systemObject.getID()) instanceof BaseObjectID && ((BaseObjectID)dBObjectCriteria).getProvider() == dBObjectProvider)) {
                systemObject = null;
            }
            if (systemObject == null) {
                dBObjectCriteria = this.createCriteria();
                dBObjectCriteria.setFullyLoadObjects(bl);
                this.m_obj = dBObjectProvider.getObject(dBObjectCriteria);
            }
        }
        if (this.m_obj == null && systemObject != null) {
            this.m_obj = systemObject;
        }
        return this.m_obj;
    }

    @Deprecated
    public SchemaObject unwrapDescriptor(DBObjectProvider dBObjectProvider) throws DBException {
        SystemObject systemObject = this.findObject(dBObjectProvider);
        return systemObject instanceof SchemaObject ? (SchemaObject)systemObject : null;
    }

    @Deprecated
    public SystemObject unwrapSystemObjectDescriptor(DBObjectProvider dBObjectProvider) throws DBException {
        return this.findObject(dBObjectProvider);
    }

    public static SystemObject[] findObjects(DBObjectProvider dBObjectProvider, SchemaObjectDescriptor ... schemaObjectDescriptorArray) throws DBException {
        SystemObject[] systemObjectArray;
        if (schemaObjectDescriptorArray == null) {
            systemObjectArray = new SystemObject[]{};
        } else {
            systemObjectArray = new SystemObject[schemaObjectDescriptorArray.length];
            for (int i = 0; i < schemaObjectDescriptorArray.length; ++i) {
                systemObjectArray[i] = schemaObjectDescriptorArray[i].findObject(dBObjectProvider);
            }
        }
        return systemObjectArray;
    }

    @Deprecated
    public static SchemaObject[] unwrapDescriptors(SchemaObjectDescriptor[] schemaObjectDescriptorArray, DBObjectProvider dBObjectProvider) throws DBException {
        SystemObject[] systemObjectArray = SchemaObjectDescriptor.findObjects(dBObjectProvider, schemaObjectDescriptorArray);
        SchemaObject[] schemaObjectArray = new SchemaObject[systemObjectArray.length];
        for (int i = 0; i < schemaObjectArray.length; ++i) {
            if (!(systemObjectArray[i] instanceof SchemaObject)) continue;
            schemaObjectArray[i] = (SchemaObject)systemObjectArray[i];
        }
        return schemaObjectArray;
    }

    @Deprecated
    public static SystemObject[] unwrapSystemObjectDescriptors(SchemaObjectDescriptor[] schemaObjectDescriptorArray, DBObjectProvider dBObjectProvider) throws DBException {
        return SchemaObjectDescriptor.findObjects(dBObjectProvider, schemaObjectDescriptorArray);
    }

    public static SchemaObjectDescriptor[] createDescriptors(SystemObject[] systemObjectArray, boolean bl) {
        if (systemObjectArray != null) {
            SchemaObjectDescriptor[] schemaObjectDescriptorArray = new SchemaObjectDescriptor[systemObjectArray.length];
            for (int i = 0; i < systemObjectArray.length; ++i) {
                if (bl) {
                    schemaObjectDescriptorArray[i] = new SchemaObjectDescriptor(systemObjectArray[i]);
                    continue;
                }
                String string = null;
                if (systemObjectArray[i] instanceof SchemaObject) {
                    string = ((SchemaObject)systemObjectArray[i]).getSchema().getName();
                }
                schemaObjectDescriptorArray[i] = new SchemaObjectDescriptor(systemObjectArray[i].getName(), systemObjectArray[i].getType(), string);
            }
            return schemaObjectDescriptorArray;
        }
        return null;
    }

    public static SchemaObjectDescriptor[] createDescriptors(SystemObject[] systemObjectArray) {
        return SchemaObjectDescriptor.createDescriptors(systemObjectArray, true);
    }

    public static SchemaObjectDescriptor[] createDescriptors(DBObjectID[] dBObjectIDArray) {
        if (dBObjectIDArray != null) {
            SchemaObjectDescriptor[] schemaObjectDescriptorArray = new SchemaObjectDescriptor[dBObjectIDArray.length];
            for (int i = 0; i < dBObjectIDArray.length; ++i) {
                try {
                    DBObject dBObject;
                    if (dBObjectIDArray[i] == null || (dBObject = dBObjectIDArray[i].resolveID()) == null || !(dBObject instanceof SystemObject)) continue;
                    schemaObjectDescriptorArray[i] = new SchemaObjectDescriptor((SystemObject)dBObject);
                    continue;
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
            return schemaObjectDescriptorArray;
        }
        return null;
    }
}

