/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.component.CheckBoxListPanel;
import oracle.ide.controls.checkboxlist.CheckBoxList;
import oracle.ide.controls.checkboxlist.CheckBoxListCellData;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.db.extension.DatabaseUIExtensionHook;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.icons.OracleIcons;

public class DBObjectTypePicker {
    private final CheckBoxListModel m_typeBoxes;
    private final CheckBoxListPanel m_typesPanel;
    private final JLabel m_typesDialogErrorLabel = new JLabel();
    private final Collection<String> m_chosenTypes = new TreeSet<String>();
    private String m_name;
    private JEWTDialog m_typesDialog;

    public DBObjectTypePicker() {
        this.m_typeBoxes = new CheckBoxListModel();
        this.m_typesPanel = new CheckBoxListPanel(this.m_typeBoxes);
        this.m_typesPanel.getList().setLayoutOrientation(1);
        this.setComponentName("DBObjectTypePicker");
    }

    public void setComponentName(String string) {
        this.m_name = string;
        this.m_typesPanel.setName(string + ".Panel");
        this.m_typesPanel.getList().setName(string + ".List");
        this.m_typesPanel.getSelectAllButton().setName(string + ".SelectAll");
        this.m_typesPanel.getDeselectAllButton().setName(string + ".DeselectAll");
    }

    public void setAvailableTypes(DBObjectProvider dBObjectProvider, boolean bl, String ... stringArray) {
        boolean bl2;
        boolean bl3 = bl2 = stringArray != null && stringArray.length != 0;
        if (!(bl2 && bl || dBObjectProvider != null)) {
            throw new IllegalArgumentException("Need a DBObjectProvider, or included types.");
        }
        this.m_chosenTypes.clear();
        this.m_typeBoxes.clear();
        if (bl2) {
            if (bl) {
                for (String string : stringArray) {
                    if (string == null || dBObjectProvider != null && !dBObjectProvider.supportsObjectType(string)) continue;
                    this.m_chosenTypes.add(string);
                }
            } else {
                List<String> list = Arrays.asList(stringArray);
                for (String string : dBObjectProvider.listObjectTypes()) {
                    if (list.contains(string)) continue;
                    this.m_chosenTypes.add(string);
                }
            }
        } else {
            for (String string : dBObjectProvider.listObjectTypes()) {
                this.m_chosenTypes.add(string);
            }
        }
        for (String string : this.m_chosenTypes) {
            this.m_typeBoxes.addElement((Object)string, this.getIcon(string), true, true, this.getLabel(string));
        }
        this.m_typeBoxes.addCheckBoxStateListener(object -> this.checkBoxChanged());
        this.setSelectedTypes(DatabaseUIExtensionHook.getHook().getDefaultObjectTypeFilter());
    }

    protected String getLabel(String string) {
        return DBTypeDisplayRegistry.getDisplayName(string);
    }

    protected Icon getIcon(String string) {
        return DBTypeDisplayRegistry.getNodeIcon(string);
    }

    public Collection<String> getAvailableTypes() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < this.m_typeBoxes.getSize(); ++i) {
            treeSet.add((String)this.m_typeBoxes.getUserObjectAt(i));
        }
        return treeSet;
    }

    private void checkBoxChanged() {
        if (this.m_typesDialog == null) {
            this.setChosenTypesFromSelection();
        } else {
            this.updateErrorLabel();
        }
    }

    private void updateErrorLabel() {
        List list = this.m_typeBoxes.getSelectionList();
        if (list == null || list.isEmpty()) {
            this.m_typesDialogErrorLabel.setText(UIBundle.get("PICKER_NO_TYPES_ERR"));
            this.m_typesDialogErrorLabel.setIcon(OracleIcons.getIcon((String)"error.png"));
            this.m_typesDialog.setOKButtonEnabled(false);
        } else {
            this.m_typesDialogErrorLabel.setText(" ");
            this.m_typesDialogErrorLabel.setIcon(OracleIcons.getIcon((String)"Empty.gif"));
            this.m_typesDialog.setOKButtonEnabled(true);
        }
    }

    private void setChosenTypesFromSelection() {
        this.m_chosenTypes.clear();
        List list = this.m_typeBoxes.getSelectionList();
        if (list != null) {
            for (Object e : list) {
                if (!(e instanceof String)) continue;
                this.m_chosenTypes.add((String)e);
            }
        }
    }

    public Component getPickerComponent() {
        return this.m_typesPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean showFilterTypesDialog(Component component) {
        if (!SwingUtilities.isEventDispatchThread() || this.m_typesDialog != null) {
            throw new IllegalStateException("Can only show one dialog, on the EDT.");
        }
        this.m_typesDialog = JEWTDialog.createDialog((Component)component, (String)UIBundle.get("FILTER_TYPES_DIALOG_TITLE"), (int)7);
        DefaultTraversablePanel defaultTraversablePanel = new DefaultTraversablePanel();
        defaultTraversablePanel.setHelpID("f1_db_filter_types_html");
        defaultTraversablePanel.setLayout((LayoutManager)new BorderLayout(0, 5));
        CheckBoxList checkBoxList = this.m_typesPanel.getList();
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)checkBoxList, (String)UIBundle.get("PICKER_TYPES"));
        defaultTraversablePanel.add((Component)jLabel, (Object)"North");
        defaultTraversablePanel.add(this.getPickerComponent(), (Object)"Center");
        defaultTraversablePanel.add((Component)this.m_typesDialogErrorLabel, (Object)"South");
        this.m_typesDialog.setContent((Component)defaultTraversablePanel);
        this.m_typesDialog.setName(this.m_name);
        this.m_typesDialog.setInitialFocus((Component)checkBoxList);
        boolean bl = false;
        try {
            this.updateErrorLabel();
            bl = this.m_typesDialog.runDialog();
            if (bl) {
                this.setChosenTypesFromSelection();
            } else {
                this.setSelectedTypes(this.m_chosenTypes);
            }
        }
        finally {
            this.m_typesDialog.dispose();
            this.m_typesDialog = null;
        }
        return bl;
    }

    public final Collection<String> getSelectedTypes() {
        return this.m_chosenTypes;
    }

    public final void setSelectedTypes(Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            this.m_typeBoxes.selectAll();
        } else {
            this.m_typeBoxes.deselectAll();
            for (int i = 0; i < this.m_typeBoxes.getSize(); ++i) {
                CheckBoxListCellData checkBoxListCellData = (CheckBoxListCellData)this.m_typeBoxes.getElementAt(i);
                checkBoxListCellData.setCheckBoxState(collection.contains(checkBoxListCellData.getUserObject()));
            }
        }
    }

    public final Collection<String> getDefaultSelection() {
        Collection<String> collection;
        Collection<String> collection2 = DatabaseUIExtensionHook.getHook().getDefaultObjectTypeFilter();
        if (collection2.isEmpty()) {
            collection = this.getAvailableTypes();
        } else {
            collection = new TreeSet<String>();
            for (String string : this.getAvailableTypes()) {
                if (!collection2.contains(string)) continue;
                collection.add(string);
            }
        }
        return collection;
    }
}

