/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import oracle.ide.db.controls.SelectableComponent;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBLog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.ResizeComponent;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.util.ModelUtil;

public final class ListButtons {
    private static final String ADD = "ButtonAdd";
    private static final String REMOVE = "ButtonRemove";
    private static final String TOP = "ButtonTop";
    private static final String UP = "ButtonUp";
    private static final String DOWN = "ButtonDown";
    private static final String BOTTOM = "ButtonBottom";
    private final SelectableComponent m_selectableComponent;
    private final Controller m_controller;
    private final Map<String, AbstractButton> m_toolButtons = new LinkedHashMap<String, AbstractButton>();
    private JPanel m_panel;
    private JLabel m_listLabel;
    private JScrollPane m_listScrollPane;
    private ControlBar m_toolbar;
    private ComponentWithTitlebar m_compTitleBar;
    private AbstractButton m_addButton;
    private AbstractButton m_removeButton;
    private JPanel m_sidePanel;
    private int m_buttonIndex = 0;
    private JButton m_upButton;
    private JButton m_downButton;
    private JButton m_topButton;
    private JButton m_bottomButton;

    public ListButtons(JList jList, Controller controller) {
        this(SelectableComponent.createSelectableComponent(jList), controller);
    }

    public ListButtons(JTree jTree, Controller controller) {
        this(SelectableComponent.createSelectableComponent(jTree), controller);
    }

    public ListButtons(SelectableComponent selectableComponent, Controller controller) {
        if (selectableComponent == null) {
            throw new IllegalArgumentException("SelectableComponent must not be null");
        }
        if (controller == null) {
            throw new IllegalArgumentException("Controller must not be null");
        }
        this.m_controller = controller;
        this.m_controller.m_selectableComponent = selectableComponent;
        this.m_selectableComponent = selectableComponent;
        this.m_selectableComponent.addSelectionListener(new SelectableComponent.SelectionListener(){

            @Override
            public void valueChanged(SelectableComponent.SelectionEvent selectionEvent) {
                if (ListButtons.this.m_panel != null && ListButtons.this.m_panel.isEnabled()) {
                    ListButtons.this.enableButtons();
                }
            }
        });
    }

    public JLabel getLabel() {
        return this.m_compTitleBar == null ? null : this.m_compTitleBar.getLabel();
    }

    public JComponent getComponent() {
        if (this.m_panel == null) {
            String string;
            String string2;
            Object object2;
            this.m_toolbar = new ControlBar();
            this.m_panel = new JPanel();
            this.m_panel.setLayout(new GridBagLayout());
            if (this.m_controller.includeAddRemoveButtons()) {
                if (this.m_addButton == null) {
                    object2 = this.m_controller == null ? UIBundle.get("LIST_BUTTONS_ADD") : this.m_controller.getAddTooltipText();
                    this.m_addButton = this.createButton(OracleIcons.getIcon((String)"add.png"), (String)object2, ADD);
                }
                if (this.m_removeButton == null) {
                    object2 = this.m_controller == null ? UIBundle.get("LIST_BUTTONS_REMOVE") : this.m_controller.getRemoveTooltipText();
                    this.m_removeButton = this.createButton(OracleIcons.getIcon((String)"delete.png"), (String)object2, REMOVE);
                    this.m_removeButton.setEnabled(false);
                }
                this.m_toolbar.add((Component)this.m_addButton);
                this.m_toolbar.add((Component)this.m_removeButton);
            } else {
                this.m_addButton = null;
                this.m_removeButton = null;
            }
            for (AbstractButton object3 : this.m_toolButtons.values()) {
                this.m_toolbar.add((Component)object3);
            }
            if (this.m_controller.includeReorderButtons()) {
                object2 = this.m_controller == null ? UIBundle.get("LIST_BUTTONS_TOP") : this.m_controller.getTopTooltipText();
                this.m_topButton = this.createButton(OracleIcons.getIcon((String)"first.png"), (String)object2, TOP);
                String string3 = this.m_controller == null ? UIBundle.get("LIST_BUTTONS_UP") : this.m_controller.getUpTooltipText();
                this.m_upButton = this.createButton(OracleIcons.getIcon((String)"previous.png"), string3, UP);
                string2 = this.m_controller == null ? UIBundle.get("LIST_BUTTONS_DOWN") : this.m_controller.getDownTooltipText();
                this.m_downButton = this.createButton(OracleIcons.getIcon((String)"next.png"), string2, DOWN);
                string = this.m_controller == null ? UIBundle.get("LIST_BUTTONS_BOTTOM") : this.m_controller.getBottomTooltipText();
                this.m_bottomButton = this.createButton(OracleIcons.getIcon((String)"last.png"), string, BOTTOM);
                this.m_sidePanel = new JPanel();
                this.m_sidePanel.setLayout(new GridBagLayout());
                this.addSideButton(this.m_sidePanel, this.m_topButton);
                this.addSideButton(this.m_sidePanel, this.m_upButton);
                this.addSideButton(this.m_sidePanel, this.m_downButton);
                this.addSideButton(this.m_sidePanel, this.m_bottomButton);
                this.m_panel.add((Component)this.m_sidePanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(5, 5, 0, 0), 0, 0));
            } else {
                this.m_sidePanel = null;
                this.m_topButton = null;
                this.m_upButton = null;
                this.m_downButton = null;
                this.m_bottomButton = null;
            }
            object2 = this.m_selectableComponent.getComponent();
            String string4 = this.m_controller.getListLabel();
            if (string4 == null) {
                this.m_listLabel = null;
            } else {
                this.m_listLabel = new JLabel();
                ResourceUtils.resLabel((JLabel)this.m_listLabel, (Component)object2, (String)string4);
            }
            this.m_listScrollPane = new JScrollPane((Component)object2);
            this.m_compTitleBar = new ComponentWithTitlebar((JComponent)this.m_listScrollPane, this.m_listLabel, this.m_toolbar);
            if (this.m_controller.useResizeComponent()) {
                string = new ResizeComponent((JComponent)this.m_compTitleBar);
                Dimension dimension = new Dimension(100, 300);
                string.setMinimumSize(dimension);
                string.setPreferredSize(dimension);
                string2 = string;
            } else {
                string2 = this.m_compTitleBar;
            }
            this.m_panel.add((Component)((Object)string2), new GridBagConstraints(0, 1, 1, 3, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
            this.m_panel.add(Box.createHorizontalStrut(160), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.m_panel.add(Box.createVerticalStrut(60), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.m_panel;
    }

    public SelectableComponent getSelectableComponent() {
        return this.m_selectableComponent;
    }

    private void addSideButton(JPanel jPanel, JButton jButton) {
        IconicButtonUI.install((AbstractButton)jButton);
        int n = this.m_buttonIndex > 0 ? 5 : 0;
        jPanel.add((Component)jButton, new GridBagConstraints(0, this.m_buttonIndex++, 1, 1, 0.0, 0.0, 11, 0, new Insets(n, 0, 0, 0), 0, 0));
    }

    public void setAddButton(AbstractButton abstractButton) {
        if (this.m_addButton != null) {
            throw new IllegalStateException("Cannot set button more than once, or after layout");
        }
        this.m_addButton = abstractButton;
    }

    public void setRemoveButton(AbstractButton abstractButton) {
        if (this.m_removeButton != null) {
            throw new IllegalStateException("Cannot set button more than once, or after layout");
        }
        this.m_removeButton = abstractButton;
    }

    public final void addCustomButton(Icon icon, String string, String string2) {
        JButton jButton = this.createButton(icon, string, string2);
        this.m_toolButtons.put(string2, jButton);
        if (this.m_toolbar != null) {
            this.m_toolbar.add((Component)jButton);
        }
    }

    public void enableButtons() {
        this.enableButtonsImpl(false);
    }

    private void enableButtonsImpl(boolean bl) {
        Object object;
        Object object2;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        block9: {
            block10: {
                int n;
                block11: {
                    int n2;
                    int n3;
                    bl5 = false;
                    bl4 = false;
                    bl3 = false;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    boolean bl8 = bl2 = !bl;
                    if (bl) break block9;
                    object2 = this.m_selectableComponent.getSelectedIndices();
                    if (object2 == null) break block10;
                    if (((int[])object2).length != 1) break block11;
                    n = object2[0];
                    object = this.m_selectableComponent.get(n);
                    if (object == null) break block10;
                    boolean bl9 = bl5 = this.m_controller == null || this.m_controller.canRemove() && this.m_controller.canRemove(object);
                    if (this.m_controller != null && !this.m_controller.canReorder()) break block10;
                    if (this.m_controller == null || this.m_controller.canMoveUp(object)) {
                        n3 = this.m_selectableComponent.getPreviousIndex(n);
                        n2 = this.m_selectableComponent.getFirstIndex(n);
                        bl4 = n3 >= 0;
                        boolean bl10 = bl7 = n2 >= 0;
                    }
                    if (this.m_controller != null && !this.m_controller.canMoveDown(object)) break block10;
                    n3 = this.m_selectableComponent.getNextIndex(n);
                    n2 = this.m_selectableComponent.getLastIndex(n);
                    bl3 = n3 > 0;
                    bl6 = n2 > 0;
                    break block10;
                }
                if (((int[])object2).length > 1) {
                    bl5 = true;
                    if (this.m_controller != null && this.m_controller.canRemove()) {
                        for (n = 0; bl5 && n < ((Object)object2).length; ++n) {
                            object = this.m_selectableComponent.get((int)object2[n]);
                            bl5 = this.m_controller.canRemove(object);
                        }
                    }
                }
            }
            if (this.m_controller != null) {
                Integer n = this.m_controller.getMaxListSize();
                boolean bl11 = bl2 = this.m_controller.canAdd() && (n == null || n > this.m_selectableComponent.size());
            }
        }
        if (this.m_upButton != null) {
            this.m_topButton.setEnabled(bl4);
            this.m_upButton.setEnabled(bl4);
            this.m_downButton.setEnabled(bl3);
            this.m_bottomButton.setEnabled(bl3);
        }
        if (this.m_addButton != null) {
            this.m_addButton.setEnabled(bl2);
            this.m_removeButton.setEnabled(bl5);
        }
        if (this.m_controller != null) {
            object2 = this.m_toolButtons.entrySet().iterator();
            while (object2.hasNext()) {
                Map.Entry entry = (Map.Entry)object2.next();
                object = (String)entry.getKey();
                ((AbstractButton)entry.getValue()).setEnabled(!bl && this.m_controller.isButtonEnabled((String)object));
            }
        }
    }

    private Object swap(int n, int n2) {
        Object object = this.m_selectableComponent.get(n);
        if (!this.m_selectableComponent.swap(n, n2)) {
            object = null;
        }
        return object;
    }

    private JButton createButton(Icon icon, String string, final String string2) {
        Object object;
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListButtons.this.handleButton(string2);
            }
        };
        abstractAction.putValue("SmallIcon", icon);
        abstractAction.putValue("ShortDescription", string);
        JButton jButton = new JButton(abstractAction);
        Object object2 = object = this.m_controller == null ? "ListButtons" : this.m_controller.getBaseName();
        if (!((String)object).endsWith(".")) {
            object = (String)object + ".";
        }
        jButton.setName((String)object + string2);
        return jButton;
    }

    private void handleButton(String string) {
        if (this.m_controller != null) {
            if (ModelUtil.areEqual((Object)string, (Object)ADD)) {
                this.m_controller.addToList();
            } else if (ModelUtil.areEqual((Object)string, (Object)REMOVE)) {
                this.m_controller.removeFromList();
                if (this.m_selectableComponent.size() > 0) {
                    this.m_removeButton.requestFocusInWindow();
                } else if (this.m_addButton != null) {
                    this.m_addButton.requestFocusInWindow();
                }
            } else if (ModelUtil.areEqual((Object)string, (Object)UP)) {
                int n = this.m_selectableComponent.getSelectedIndex();
                if (n > 0) {
                    Object object = this.m_selectableComponent.get(n);
                    if (this.m_selectableComponent.moveUp(n)) {
                        this.m_selectableComponent.setSelectedIndices(this.m_selectableComponent.indexOf(object));
                        this.m_controller.objectMovedUp(object);
                    }
                }
            } else if (ModelUtil.areEqual((Object)string, (Object)DOWN)) {
                int n = this.m_selectableComponent.getSelectedIndex();
                if (n < this.m_selectableComponent.size() - 1) {
                    Object object = this.m_selectableComponent.get(n);
                    if (this.m_selectableComponent.moveDown(n)) {
                        this.m_selectableComponent.setSelectedIndices(this.m_selectableComponent.indexOf(object));
                        this.m_controller.objectMovedDown(object);
                    }
                }
            } else if (ModelUtil.areEqual((Object)string, (Object)TOP)) {
                int n = this.m_selectableComponent.getSelectedIndex();
                if (n > 0) {
                    Object object = this.m_selectableComponent.get(n);
                    this.m_selectableComponent.setSelectedIndices(new int[0]);
                    if (this.m_selectableComponent.moveFirst(n)) {
                        this.m_selectableComponent.setSelectedIndices(this.m_selectableComponent.indexOf(object));
                        this.m_controller.objectMovedUp(object);
                    }
                }
            } else if (ModelUtil.areEqual((Object)string, (Object)BOTTOM)) {
                int n = this.m_selectableComponent.getSelectedIndex();
                if (n < this.m_selectableComponent.size() - 1) {
                    this.m_selectableComponent.setSelectedIndices(new int[0]);
                    Object object = this.m_selectableComponent.get(n);
                    if (this.m_selectableComponent.moveLast(n)) {
                        this.m_selectableComponent.setSelectedIndices(this.m_selectableComponent.indexOf(object));
                        this.m_controller.objectMovedDown(object);
                    }
                }
            } else {
                this.m_controller.customButtonPressed(string);
            }
        }
    }

    public void setEnabled(boolean bl) {
        this.getComponent().setEnabled(bl);
        if (this.m_listLabel != null) {
            this.m_listLabel.setEnabled(bl);
        }
        this.enableButtonsImpl(!bl);
    }

    @Deprecated
    public static abstract class HelperAdapter
    extends Controller
    implements Helper {
    }

    @Deprecated
    public static interface Helper {
        public boolean includeAddRemoveButtons();

        public boolean includeReorderButtons();

        public boolean canRemove();

        public boolean canRemove(Object var1);

        public boolean canAdd();

        public boolean canReorder();

        public boolean canMoveUp(Object var1);

        public boolean canMoveDown(Object var1);

        public String getUpTooltipText();

        public String getDownTooltipText();

        public String getAddTooltipText();

        public String getRemoveTooltipText();

        public void addToList();

        public void removeFromList();

        public void objectMovedUp(Object var1);

        public void objectMovedDown(Object var1);
    }

    public static abstract class Controller {
        private SelectableComponent m_selectableComponent;

        protected final SelectableComponent getSelectableComponent() {
            return this.m_selectableComponent;
        }

        public abstract void addToList();

        public void removeFromList() {
            SelectableComponent selectableComponent = this.getSelectableComponent();
            int[] nArray = selectableComponent.getSelectedIndices();
            if (nArray != null && nArray.length > 0) {
                int n;
                int n2;
                Arrays.sort(nArray);
                for (n2 = nArray.length - 1; n2 >= 0; --n2) {
                    n = nArray[n2];
                    selectableComponent.remove(n);
                }
                n2 = nArray[nArray.length - 1] - nArray.length + 1;
                n = selectableComponent.size();
                if (n2 < 0 || n2 >= n) {
                    n2 = n - 1;
                }
                if (n2 >= 0) {
                    selectableComponent.setSelectedIndices(n2);
                }
            }
        }

        public String getBaseName() {
            return "ListButtons";
        }

        public String getListLabel() {
            return null;
        }

        public boolean useResizeComponent() {
            return false;
        }

        public void customButtonPressed(String string) {
            DBLog.getLogger((Object)this).warning("Unhandled button " + string);
        }

        public boolean isButtonEnabled(String string) {
            return true;
        }

        public boolean includeAddRemoveButtons() {
            return true;
        }

        public boolean includeReorderButtons() {
            return true;
        }

        public boolean canRemove(Object object) {
            return true;
        }

        public boolean canRemove() {
            return true;
        }

        public boolean canAdd() {
            return true;
        }

        public Integer getMaxListSize() {
            return null;
        }

        public boolean canMoveUp(Object object) {
            return true;
        }

        public boolean canMoveDown(Object object) {
            return true;
        }

        public boolean canReorder() {
            return true;
        }

        public String getAddTooltipText() {
            return UIBundle.get("LIST_BUTTONS_ADD");
        }

        public String getRemoveTooltipText() {
            return UIBundle.get("LIST_BUTTONS_REMOVE");
        }

        public String getUpTooltipText() {
            return UIBundle.get("LIST_BUTTONS_UP");
        }

        public String getDownTooltipText() {
            return UIBundle.get("LIST_BUTTONS_DOWN");
        }

        public String getTopTooltipText() {
            return UIBundle.get("LIST_BUTTONS_TOP");
        }

        public String getBottomTooltipText() {
            return UIBundle.get("LIST_BUTTONS_BOTTOM");
        }

        public void objectMovedUp(Object object) {
        }

        public void objectMovedDown(Object object) {
        }
    }
}

