/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.util.ModelUtil;

public class SearchableTextArea
extends JPanel {
    public static final String PREFS_KEY = "oracle.ide.db.controls.SearchableTextArea";
    public static final String PREFS_CASE_KEY = "oracle.ide.db.controls.SearchableTextArea.CASE";
    private final SearchField m_searchField = new SearchField();
    private final JTextArea m_textArea;
    private boolean m_textHadFocus = false;

    public SearchableTextArea() {
        this(new JTextArea());
    }

    public SearchableTextArea(JTextArea jTextArea) {
        this(null, jTextArea);
    }

    public SearchableTextArea(String string, JTextArea jTextArea) {
        this.m_textArea = jTextArea;
        this.initialisePanel(string);
    }

    public SearchableTextArea(String string) {
        this(string, new JTextArea());
    }

    public void initialisePanel(String string) {
        this.m_textArea.setText(string);
        this.m_textArea.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SearchableTextArea.this.m_textHadFocus = true;
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_searchField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createHorizontalStrut(200), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JScrollPane(this.m_textArea, 20, 31), new GridBagConstraints(1, 3, 2, 1, 1.0, 1.0, 17, 1, new Insets(4, 0, 0, 0), 0, 0));
        this.m_searchField.setStyle(SearchField.Style.FIND);
        this.m_searchField.setAutoFind(true);
        this.m_searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                if (searchEvent.isFromClear() || !ModelUtil.hasLength((String)searchEvent.getSearchText())) {
                    SearchableTextArea.this.m_textArea.setSelectionEnd(SearchableTextArea.this.m_textArea.getSelectionStart() - 1);
                } else {
                    int n;
                    boolean bl = searchEvent.getDirection() == SearchEvent.Direction.FORWARD;
                    boolean bl2 = false;
                    String string = searchEvent.getSearchText();
                    String string2 = SearchableTextArea.this.m_textArea.getText();
                    if (!bl2) {
                        string = string.toUpperCase();
                        string2 = string2.toUpperCase();
                    }
                    int n2 = -1;
                    if (bl) {
                        n = searchEvent.isTriggeredByKeypress() ? 0 : 1;
                        int n3 = SearchableTextArea.this.m_textArea.getSelectionStart();
                        if (n3 < 0) {
                            n3 = SearchableTextArea.this.m_textArea.getCaretPosition();
                        }
                        n2 = string2.indexOf(string, n3 + n);
                    } else {
                        n = SearchableTextArea.this.m_textArea.getSelectionStart() - 1;
                        if (n < 0) {
                            n = SearchableTextArea.this.m_textArea.getCaretPosition() - 1;
                        }
                        n2 = n >= 0 ? string2.lastIndexOf(string, n) : -1;
                    }
                    if (n2 == -1 && string2.indexOf(string) != -1) {
                        n2 = bl ? string2.indexOf(string) : string2.lastIndexOf(string);
                    }
                    if (n2 >= 0) {
                        SearchableTextArea.this.m_textArea.setCaretPosition(n2);
                        SearchableTextArea.this.m_textArea.setSelectionStart(n2);
                        SearchableTextArea.this.m_textArea.setSelectionEnd(n2 + string.length());
                    } else {
                        n = 0;
                        if (bl) {
                            n = string2.length();
                        }
                        SearchableTextArea.this.m_textArea.setCaretPosition(n);
                        SearchableTextArea.this.m_textArea.setSelectionStart(n);
                        SearchableTextArea.this.m_textArea.setSelectionEnd(n);
                    }
                    SearchableTextArea.this.m_textArea.getCaret().setSelectionVisible(true);
                }
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
        this.m_textArea.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getModifiers() == 2 && keyEvent.getKeyCode() == 70) {
                    SearchableTextArea.this.m_searchField.setText(SearchableTextArea.this.m_textArea.getSelectedText());
                    SearchableTextArea.this.m_searchField.requestFocus();
                }
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
    }

    public JTextComponent getTextComponent() {
        return this.m_textArea;
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.m_searchField.setName(string + "Search");
        this.m_textArea.setName(string + "Text");
    }
}

