/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import oracle.ide.db.panels.TabbedEditorPanel;
import oracle.ide.panels.MDDPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;

public class MDDEditorPanel
extends TabbedEditorPanel {
    private int m_simpleAdvancedPanelThreshold = 2;
    private MDDPanel m_mddPanel;

    public MDDEditorPanel(Traversable traversable, Navigable[] navigableArray, String string, int n) {
        this(traversable, navigableArray, string);
        this.m_simpleAdvancedPanelThreshold = n;
    }

    public MDDEditorPanel(Traversable traversable, Navigable[] navigableArray, String string) {
        super(traversable, navigableArray, string);
    }

    @Override
    protected Traversable createPanel(Navigable[] navigableArray) {
        MDDPanel mDDPanel = null;
        if (navigableArray != null) {
            boolean bl = false;
            for (int i = 0; i < navigableArray.length; ++i) {
                Navigable[] navigableArray2 = navigableArray[i].getChildren();
                if (navigableArray2 == null || navigableArray2.length <= 0) continue;
                bl = true;
                break;
            }
            if (!bl && navigableArray.length <= this.m_simpleAdvancedPanelThreshold) {
                return super.createPanel(navigableArray);
            }
            if (this.m_mddPanel == null) {
                this.m_mddPanel = new MDDP(navigableArray);
                this.m_mddPanel.setChildComparator(null);
                this.m_mddPanel.setDefaultChildComparator(Navigable.NAVIGABLE_COMPARATOR);
                this.m_mddPanel.setTitleDepth(0);
            } else {
                this.m_mddPanel.setRootNavigables(navigableArray);
            }
            mDDPanel = this.m_mddPanel;
        }
        return mDDPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void enterMiddlePanel(Traversable traversable, String string, boolean bl) {
        if (traversable instanceof MDDPanel) {
            MDDPanel mDDPanel = (MDDPanel)traversable;
            boolean bl2 = mDDPanel.enableSelectionDelay(false);
            try {
                super.enterMiddlePanel(traversable, string, bl);
                mDDPanel.expandTree1ToDepth(2);
                if (!bl || string == null) return;
                String[] stringArray = string.split("/");
                mDDPanel.setTree1SelectionPath(stringArray);
                return;
            }
            finally {
                mDDPanel.enableSelectionDelay(bl2);
            }
        } else {
            super.enterMiddlePanel(traversable, string, bl);
        }
    }

    @Override
    public Navigable getCurrentNavigable() {
        Navigable navigable = this.m_mddPanel instanceof MDDP ? ((MDDP)this.m_mddPanel).getCurrentNavigable() : super.getCurrentNavigable();
        return navigable;
    }

    private static class MDDP
    extends MDDPanel {
        public MDDP(Navigable[] navigableArray) {
            super(navigableArray);
        }

        public Navigable getCurrentNavigable() {
            return super.getCurrentNavigable();
        }
    }
}

