/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.TabbedPaneUI;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.panels.DBTraversable;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.MetaTraversable;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TabbedPanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.DBTabbedPanel;
import oracle.javatools.db.DBLog;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.plaf.FlatTabbedPaneUI;
import oracle.javatools.util.ModelUtil;

public class TabbedEditorPanel
extends DefaultTraversablePanel
implements DBTraversable {
    private final Traversable m_top;
    private Navigable[] m_navs;
    private String m_startPage;
    private final Map<String, Navigable> m_allNavs = new HashMap<String, Navigable>();
    private final PanelLibrary.PanelSetChanger m_changer = (navigableArray, panelSetChangeValidator) -> this.changeNavigables(navigableArray, panelSetChangeValidator);
    private Traversable m_middle;
    private TraversableContext m_data;
    private boolean m_firstEntry = true;
    private boolean m_entered;

    public TabbedEditorPanel(Traversable traversable, Navigable[] navigableArray2, String string) {
        this.m_top = traversable;
        this.m_navs = navigableArray2;
        this.setStartPage(string);
        this.setLayout(new BorderLayout(0, 10));
    }

    private boolean areDifferent(Navigable[] navigableArray, Navigable[] navigableArray2) {
        boolean bl = true;
        if (navigableArray.length == navigableArray2.length) {
            bl = false;
            for (int i = 0; i < navigableArray.length; ++i) {
                if (!ModelUtil.areDifferent((Object)navigableArray[i].getShortLabel(), (Object)navigableArray2[i].getShortLabel())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    @Override
    public Component getDefaultFocusComponent() {
        Component component;
        if (this.m_top instanceof DBTraversable && (component = ((DBTraversable)this.m_top).getDefaultFocusComponent()) != null && component.isEnabled()) {
            return component;
        }
        if (this.m_middle instanceof DBTraversable && (component = ((DBTraversable)this.m_middle).getDefaultFocusComponent()) != null && component.isEnabled()) {
            return component;
        }
        return null;
    }

    @Override
    public boolean requestFocusForEditorConfig() {
        boolean bl = false;
        if (this.m_top instanceof DBTraversable) {
            bl = ((DBTraversable)this.m_top).requestFocusForEditorConfig();
        }
        if (!bl && this.m_middle instanceof DBTraversable) {
            bl = ((DBTraversable)this.m_middle).requestFocusForEditorConfig();
        }
        return bl;
    }

    protected Traversable createPanel(Navigable[] navigableArray) {
        Traversable traversable = null;
        if (navigableArray != null) {
            if (navigableArray.length == 1) {
                traversable = navigableArray[0].newTraversable(null);
                if (traversable instanceof DefaultTraversablePanel) {
                    ((DefaultTraversablePanel)traversable).setHelpID(MetaTraversable.findHelpID((MetaTraversable)navigableArray[0], (Traversable)traversable));
                }
            } else if (navigableArray.length > 0) {
                traversable = this.isInFlatEditor() ? new DBTabbedPanel(navigableArray, (TabbedPaneUI)new FlatTabbedPaneUI()) : new DBTabbedPanel(navigableArray);
            }
        }
        return traversable;
    }

    private boolean isInModalDialog() {
        boolean bl = false;
        DBEditorConfig dBEditorConfig = (DBEditorConfig)this.m_data.find(DBEditorConfig.class);
        if (dBEditorConfig != null) {
            DBEditorFactory.EditorType editorType = dBEditorConfig.getEditorType();
            bl = editorType == DBEditorFactory.EditorType.EDIT_MODAL || editorType == DBEditorFactory.EditorType.CREATE_MODAL;
        }
        return bl;
    }

    private boolean isInFlatEditor() {
        DBEditorConfig dBEditorConfig;
        boolean bl = false;
        if (this.m_data != null && (dBEditorConfig = (DBEditorConfig)this.m_data.find(DBEditorConfig.class)) != null) {
            bl = dBEditorConfig.isInFlatEditor();
        }
        return bl;
    }

    public String getHelpID() {
        if (this.m_middle != null) {
            return this.m_middle.getHelpID();
        }
        return super.getHelpID();
    }

    private void layoutComponents() {
        DBEditorConfig dBEditorConfig = (DBEditorConfig)this.m_data.find(DBEditorConfig.class);
        String string = (dBEditorConfig.isEdit() ? "edit" : "create") + dBEditorConfig.getObjectType();
        this.setName(string);
        if (this.m_navs != null) {
            this.layoutMiddle(this.m_navs);
        }
        if (this.m_top != null) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setName(string + ".header");
            jPanel.add(this.m_top.getComponent(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 5), 0, 0));
            if (this.isInModalDialog()) {
                JLabel jLabel = new JLabel();
                jLabel.setIcon(OracleIcons.getIcon((String)"header/database.png"));
                jPanel.add((Component)jLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
            if (this.m_middle == null) {
                this.add(jPanel, "Center");
            } else {
                this.add(jPanel, "North");
            }
        }
    }

    private void changeNavigables(Navigable[] navigableArray, PanelLibrary.PanelSetChangeValidator panelSetChangeValidator) throws TraversalException {
        boolean bl;
        Navigable navigable = this.getCurrentNavigable();
        boolean bl2 = bl = navigableArray != null && (this.m_navs == null || this.areDifferent(navigableArray, this.m_navs));
        if (bl && this.m_middle != null && this.m_entered) {
            try {
                this.m_middle.onExit(this.m_data);
            }
            catch (TraversalException traversalException) {
                this.m_middle.onEntry(this.m_data);
                throw traversalException;
            }
        }
        if (panelSetChangeValidator != null) {
            panelSetChangeValidator.validatePanelChange(this.m_data);
        }
        if (bl) {
            this.m_navs = navigableArray;
            if (navigable != null) {
                this.setStartPage(navigable.getShortLabel());
            }
            this.layoutMiddle(navigableArray);
            if (this.m_entered) {
                this.enterPanel(this.m_middle);
                this.revalidate();
            }
        }
    }

    private void layoutMiddle(Navigable[] navigableArray) {
        for (int i = 0; i < navigableArray.length; ++i) {
            Navigable navigable = navigableArray[i];
            String string = navigable.getShortLabel();
            Navigable navigable2 = this.m_allNavs.get(string);
            if (navigable2 == null) {
                this.m_allNavs.put(string, navigable);
                continue;
            }
            navigableArray[i] = navigable2;
        }
        if (this.m_middle != null) {
            this.remove(this.m_middle.getComponent());
        }
        this.m_middle = this.createPanel(navigableArray);
        if (this.m_middle != null) {
            Component component = this.m_middle.getComponent();
            component.setName("DEFAULT_PANEL");
            this.add(component, "Center");
        }
    }

    protected void enterPanel(Traversable traversable) {
        if (traversable != null) {
            if (traversable == this.m_middle) {
                this.enterMiddlePanel(this.m_middle, this.m_startPage, this.m_firstEntry);
                this.m_firstEntry = false;
            } else {
                traversable.onEntry(this.m_data);
            }
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_data = traversableContext;
        this.m_data.put(PanelLibrary.PanelSetChanger.class.getName(), (Object)this.m_changer);
        if (this.m_firstEntry) {
            this.layoutComponents();
        }
        this.enterPanel(this.m_top);
        this.enterPanel(this.m_middle);
        this.m_firstEntry = false;
        this.m_entered = true;
    }

    public void setStartPage(String string) {
        this.m_startPage = string;
        this.m_firstEntry = true;
    }

    protected void enterMiddlePanel(Traversable traversable, String string, boolean bl) {
        if (bl && string != null && traversable instanceof TabbedPanel) {
            Integer n = null;
            for (int i = 0; i < this.m_navs.length; ++i) {
                if (!ModelUtil.areEqual((Object)string, (Object)this.m_navs[i].getShortLabel())) continue;
                n = i;
                break;
            }
            if (n != null) {
                this.m_data.putDesignTimeObject("TabbedPanel.DEFAULT_TAB_INDEX", n);
            }
            traversable.onEntry(this.m_data);
            this.m_data.putDesignTimeObject("TabbedPanel.DEFAULT_TAB_INDEX", null);
        } else {
            traversable.onEntry(this.m_data);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        try {
            if (this.m_middle != null) {
                this.m_middle.onExit(traversableContext);
            }
            if (this.m_top != null) {
                this.m_top.onExit(traversableContext);
            }
            if (!this.isInFlatEditor()) {
                this.commitToProvider(traversableContext);
            }
            this.m_entered = false;
        }
        catch (TraversalException traversalException) {
            this.enterPanel(this.m_top);
            this.enterPanel(this.m_middle);
            throw traversalException;
        }
    }

    protected final void commitToProvider(TraversableContext traversableContext) throws TraversalException {
        DBEditorConfig dBEditorConfig = (DBEditorConfig)traversableContext.find(DBEditorConfig.class);
        if (!dBEditorConfig.isUseBackgroundTask()) {
            PanelLibrary panelLibrary = (PanelLibrary)traversableContext.find(PanelLibrary.class);
            if (panelLibrary == null) {
                DBLog.getLogger((Object)this).severe("No PanelLibrary in context, cannot commit");
            } else {
                try {
                    panelLibrary.commitToProvider(dBEditorConfig);
                }
                catch (Exception exception) {
                    DBLog.getLogger((Object)panelLibrary).log(Level.SEVERE, "Unexpected error commiting to provider: " + exception.getMessage(), exception);
                }
            }
            if (dBEditorConfig.getResult() != DBEditorConfig.Result.SUCCESS) {
                throw new TraversalException(null);
            }
        }
    }

    public final Traversable getTop() {
        return this.m_top;
    }

    protected final Traversable getMiddle() {
        return this.m_middle;
    }

    public Navigable getCurrentNavigable() {
        Navigable navigable = null;
        if (this.m_middle instanceof DBTabbedPanel) {
            navigable = ((DBTabbedPanel)this.m_middle).getCurrentNavigable();
        }
        return navigable;
    }
}

