/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql.tester;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.db.panels.sql.tester.DCNTesterComponent;
import oracle.ide.db.panels.sql.tester.TesterComponent;
import oracle.ide.db.panels.sql.tester.TesterPanel;
import oracle.ideimpl.db.extension.DatabaseUIExtensionHook;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.ideri.util.Product;
import oracle.javatools.db.Database;

public class SQLQueryTester {
    private static final String QUERY_RESULTS_ID = "queryResults";
    private static final String EXPLAIN_PLAN_ID = "explainPlan";
    private final Database m_db;
    private final Map<String, Object> m_bindVariables = new TreeMap<String, Object>();
    private final boolean m_dbOnly;
    private Context m_ideContext;
    private boolean m_showPicker = true;
    private String m_storeName;
    private Result m_result;

    public SQLQueryTester(Database database) {
        this(database, false);
    }

    public SQLQueryTester(Database database, boolean bl) {
        this.m_db = database;
        if (database != null) {
            this.setDefaultConnectionStore(database.getConnectionStore());
        }
        this.m_dbOnly = Product.isRaptor() || bl;
    }

    private String getTitle() {
        return UIBundle.get("TESTSQL_TITLE");
    }

    public void setBindVariables(Map<String, ?> map) {
        this.m_bindVariables.clear();
        if (map != null) {
            this.m_bindVariables.putAll(map);
        }
    }

    public Map<String, Object> getBindVariables() {
        return this.m_bindVariables;
    }

    public Context getContext() {
        return this.m_ideContext == null ? Context.newIdeContext() : this.m_ideContext;
    }

    public void setContext(Context context) {
        this.m_ideContext = context;
    }

    public void setShowConnectionPicker(boolean bl) {
        this.m_showPicker = bl;
    }

    public String getDefaultConnectionStore() {
        return this.m_storeName;
    }

    public void setDefaultConnectionStore(String string) {
        this.m_storeName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result showDialog(Component component, final String string) {
        final TesterPanel testerPanel = new TesterPanel(this);
        testerPanel.setBindVariables(this.m_bindVariables);
        testerPanel.setShowConnectionPicker(this.m_showPicker);
        DatabaseUIExtensionHook databaseUIExtensionHook = DatabaseUIExtensionHook.getHook();
        if (databaseUIExtensionHook != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(QUERY_RESULTS_ID);
            arrayList.add(EXPLAIN_PLAN_ID);
            if (!this.m_dbOnly) {
                for (String string2 : databaseUIExtensionHook.getSQLTesterComponentIDs()) {
                    if (arrayList.contains(string2)) continue;
                    arrayList.add(string2);
                }
            }
            for (String string2 : arrayList) {
                TesterComponent testerComponent = databaseUIExtensionHook.getSQLTesterComponent(string2);
                if (testerComponent == null) continue;
                testerComponent.setTester(this);
                testerPanel.addPanel(testerComponent);
            }
        }
        if (!this.m_dbOnly) {
            testerPanel.addPanel(new DCNTesterComponent());
        }
        final JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)component, (String)this.getTitle(), (int)20);
        jEWTDialog.setName("LiveSQLTestDialog");
        jEWTDialog.setMinimumSize(new Dimension(500, 400));
        jEWTDialog.setPreferredSize(new Dimension(500, 600));
        jEWTDialog.setResizable(true);
        jEWTDialog.setContent((Component)testerPanel);
        jEWTDialog.setButtonMask(20);
        jEWTDialog.setDefaultButton(16);
        jEWTDialog.setInitialFocus(testerPanel.getDefaultFocusComponent());
        jEWTDialog.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                testerPanel.testSQL(SQLQueryTester.this.m_db, string);
                jEWTDialog.removeWindowListener((WindowListener)this);
            }
        });
        try {
            jEWTDialog.runDialog();
        }
        finally {
            testerPanel.close();
            jEWTDialog.dispose();
        }
        return testerPanel.getResult();
    }

    @Deprecated
    public void setSQLText(String string) {
    }

    @Deprecated
    public static void registerComponent(Class<? extends TesterComponent> clazz) {
    }

    public static class Result {
        private String m_query;
        private boolean m_result;
        private String m_msg;
        private Integer m_offset;

        Result(String string, boolean bl, String string2, Integer n) {
            this.m_query = string;
            this.m_result = bl;
            this.m_msg = string2;
            this.m_offset = n;
        }

        public String getQuery() {
            return this.m_query;
        }

        public boolean getResult() {
            return this.m_result;
        }

        public String getMessage() {
            return this.m_msg;
        }

        public Integer getOffset() {
            return this.m_offset;
        }
    }
}

