/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.Map;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.event.SwingDBObjectListener;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.ConstraintIndexHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;

public class ConstraintIndexIDComponentWrapper
extends ComponentWrapper<DBObjectChooser> {
    private DBObjectID m_default;
    private final DBObjectListener m_objListener = new SwingDBObjectListener(){

        @Override
        protected void updateUI(DBObjectChange dBObjectChange) {
            if (ConstraintIndexIDComponentWrapper.this.isActive()) {
                PropertyChangeEvent propertyChangeEvent;
                Map map = dBObjectChange.getPropertiesChanged();
                PropertyChangeEvent propertyChangeEvent2 = (PropertyChangeEvent)map.get("indexID");
                if (propertyChangeEvent2 != null) {
                    ConstraintIndexIDComponentWrapper.this.reset();
                    ConstraintIndexIDComponentWrapper.this.setPropertyValue(propertyChangeEvent2.getNewValue());
                }
                if ((propertyChangeEvent = (PropertyChangeEvent)map.get("columnIDs")) != null) {
                    ConstraintIndexIDComponentWrapper.this.reset();
                    ConstraintIndexHelper.clearIndexIDIfInvalid((UniqueConstraint)((UniqueConstraint)dBObjectChange.getDBObject()), (DBObjectProvider)ConstraintIndexIDComponentWrapper.this.getProvider());
                }
                if (map.containsKey("enabled") || propertyChangeEvent != null) {
                    ConstraintIndexIDComponentWrapper.this.checkEnabled();
                }
            }
        }
    };
    private final DBObjectChooser.ChangeListener m_changeListener = new DBObjectChooser.ChangeListener(){

        @Override
        public void chooserChanged(DBObjectChooser dBObjectChooser, DBObjectID dBObjectID) {
            ConstraintIndexIDComponentWrapper.this.fireChangeEvent();
            if (dBObjectID != null && !dBObjectID.equals(ConstraintIndexIDComponentWrapper.this.m_default, true)) {
                ConstraintIndexIDComponentWrapper.this.m_default = null;
            }
        }
    };

    public ConstraintIndexIDComponentWrapper() {
        super(new DBObjectChooser("INDEX"));
    }

    @Override
    public Object getPropertyValue() {
        return this.m_default == null ? ((DBObjectChooser)this.getActiveComponent()).getDBObjectID() : this.m_default;
    }

    @Override
    public void setPropertyValue(Object object) {
        this.reset();
        DBObjectID dBObjectID = null;
        if (object instanceof DBObjectID) {
            dBObjectID = (DBObjectID)object;
        }
        DBObjectChooser dBObjectChooser = (DBObjectChooser)this.getActiveComponent();
        if (dBObjectID == null) {
            dBObjectChooser.setNullText(UIBundle.get("STRING_DEFAULT_PROMPT"));
        } else {
            dBObjectChooser.setNullText(null);
        }
        ((DBObjectChooser)this.getActiveComponent()).removeChangeListener(this.m_changeListener);
        dBObjectChooser.setDBObjectID(dBObjectID);
        ((DBObjectChooser)this.getActiveComponent()).addChangeListener(this.m_changeListener);
        this.checkEnabled();
    }

    private void checkEnabled() {
        DBObject dBObject = this.getUpdatedObject();
        if (dBObject instanceof UniqueConstraint) {
            this.setEnabled(((UniqueConstraint)dBObject).isEnabled() && ((UniqueConstraint)dBObject).getColumnIDs().length > 0);
        }
    }

    @Override
    protected void initialiseComponentListener() {
        ((DBObjectChooser)this.getActiveComponent()).addChangeListener(this.m_changeListener);
    }

    @Override
    protected void initialiseComponent() {
        DBObjectFilter dBObjectFilter = new DBObjectFilter(){

            public boolean accept(DBObject dBObject) {
                DBObject dBObject2 = ConstraintIndexIDComponentWrapper.this.getUpdatedObject();
                if (dBObject2 instanceof UniqueConstraint && dBObject instanceof Index) {
                    return ConstraintIndexHelper.indexValidForConstraint((Index)((Index)dBObject), (UniqueConstraint)((UniqueConstraint)dBObject2), (DBObjectProvider)ConstraintIndexIDComponentWrapper.this.getProvider());
                }
                return false;
            }
        };
        DBObjectChooser dBObjectChooser = (DBObjectChooser)this.getActiveComponent();
        dBObjectChooser.setProvider(this.getProvider());
        dBObjectChooser.setFilter(dBObjectFilter);
    }

    private void reset() {
        DBObjectChooser dBObjectChooser = (DBObjectChooser)this.getActiveComponent();
        dBObjectChooser.resetCaches();
        dBObjectChooser.setContextDBObjectID(this.getComponentContext().getUpdatedSystemObject().getID());
        this.m_default = null;
    }

    @Override
    protected void setActiveImpl(boolean bl) {
        DBObject dBObject = this.getUpdatedObject();
        if (dBObject instanceof UniqueConstraint) {
            dBObject.removeObjectListener(this.m_objListener);
            if (bl) {
                dBObject.addObjectListener(this.m_objListener);
            }
        }
        if (!bl) {
            ((DBObjectChooser)this.getActiveComponent()).cancel();
        }
    }

    @Override
    public Component getDefaultFocusComponent() {
        return ((DBObjectChooser)this.getActiveComponent()).getDefaultFocusComponent();
    }
}

