/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.ideimpl.db.components.IdArrayWrapper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.event.DBObjectProviderListener;

public class SystemObjectIdArrayWrapper
extends IdArrayWrapper {
    private final DBObjectCriteria m_criteria;

    public SystemObjectIdArrayWrapper(Class<? extends DBObject> clazz, DBObjectFilter dBObjectFilter, boolean bl, DBObjectCriteria dBObjectCriteria) {
        super(clazz, dBObjectFilter, bl, null);
        this.m_criteria = dBObjectCriteria;
    }

    @Override
    protected List<DBObject> getAvailableList() {
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        try {
            arrayList.addAll(this.getProvider().listObjects(this.m_criteria));
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return arrayList;
    }

    @Override
    protected DBObjectProviderListener createProviderListenerForRefresh() {
        return new DBObjectProviderListener(){

            private void refreshIfRequired(Collection<? extends SystemObject> collection) {
                for (SystemObject systemObject : collection) {
                    if (!SystemObjectIdArrayWrapper.this.m_criteria.accept(systemObject)) continue;
                    SystemObjectIdArrayWrapper.this.refreshUI();
                    break;
                }
            }

            public void schemaObjectsAdded(DBObjectProvider dBObjectProvider, Schema schema, Collection<? extends SchemaObject> collection) {
                this.refreshIfRequired(collection);
            }

            public void schemaObjectsRemoved(DBObjectProvider dBObjectProvider, Schema schema, Collection<? extends SchemaObject> collection) {
                this.refreshIfRequired(collection);
            }

            public void systemObjectsAdded(DBObjectProvider dBObjectProvider, Collection<? extends SystemObject> collection) {
                this.refreshIfRequired(collection);
            }

            public void systemObjectsRemoved(DBObjectProvider dBObjectProvider, Collection<? extends SystemObject> collection) {
                this.refreshIfRequired(collection);
            }
        };
    }
}

