/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.controls.BigDataValueCellEditor;
import oracle.ideimpl.db.controls.ExtendedTable;
import oracle.ideimpl.db.controls.KeyValueTable;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameter;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameterMetadata;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameters;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.util.ModelUtil;

public class BigDataAccessParamsTable
extends KeyValueTable {
    public BigDataAccessParamsTable() {
        super(PropertyDisplayRegistry.getDisplayName("accessParameters"), "BigDataAccessParametersTable");
    }

    public void setAccessParameters(BigDataAccessParameters bigDataAccessParameters, Relation relation, DBObjectProvider dBObjectProvider) {
        this.stopCellEditing();
        Vector<Vector> vector = new Vector<Vector>();
        if (bigDataAccessParameters != null) {
            for (BigDataAccessParameter bigDataAccessParameter : bigDataAccessParameters.getBigDataAccessParameters()) {
                Vector<String> vector2 = new Vector<String>();
                vector2.add(bigDataAccessParameter.getName());
                vector2.add(bigDataAccessParameter.getParameterValue());
                vector.add(vector2);
            }
        }
        this.setModel(new ExtendedTable.StringTableModel(this, vector, this.getPropertyColumnNames("name", "parameterValue")));
        TableColumn tableColumn = this.getTable().getColumnModel().getColumn(0);
        TableColumn tableColumn2 = this.getTable().getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(50);
        tableColumn2.setPreferredWidth(200);
        tableColumn2.setCellEditor(new BigDataValueCellEditor(this, dBObjectProvider, relation));
        tableColumn2.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (object instanceof String) {
                    object = BigDataAccessParameterMetadata.stripLineEscapes((String)((String)object)).replace("\n", " ");
                }
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
    }

    public BigDataAccessParameters getAccessParameters() {
        this.stopCellEditing();
        ExtendedTable.StringTableModel stringTableModel = this.getModel();
        ArrayList<BigDataAccessParameter> arrayList = new ArrayList<BigDataAccessParameter>();
        for (int i = 0; i < stringTableModel.getRowCount(); ++i) {
            Object object;
            BigDataAccessParameter bigDataAccessParameter = new BigDataAccessParameter();
            Object object2 = stringTableModel.getValueAt(i, 0);
            if (object2 != null) {
                bigDataAccessParameter.setName(object2.toString());
            }
            if ((object = stringTableModel.getValueAt(i, 1)) != null) {
                bigDataAccessParameter.setParameterValue(object.toString());
            }
            if (object2 == null && object == null) continue;
            arrayList.add(bigDataAccessParameter);
        }
        BigDataAccessParameters bigDataAccessParameters = new BigDataAccessParameters();
        bigDataAccessParameters.setBigDataAccessParameters(arrayList.toArray(new BigDataAccessParameter[arrayList.size()]));
        return bigDataAccessParameters;
    }

    @Override
    protected void keyChanged(String string, int n) {
        String string2;
        GenericTable genericTable = this.getTable();
        boolean bl = genericTable.getModel().getRowCount() > n;
        String string3 = string2 = bl ? (String)genericTable.getValueAt(n, 0) : null;
        if (ModelUtil.areDifferent((Object)string2, (Object)string)) {
            BigDataAccessParameterMetadata.TemplateValue templateValue = BigDataAccessParameterMetadata.getParameterTemplateValue((String)string);
            String string4 = bl ? (String)genericTable.getValueAt(n, 1) : null;
            BigDataAccessParameterMetadata.TemplateValue templateValue2 = BigDataAccessParameterMetadata.getParameterTemplateValue((String)string2);
            if (templateValue != null) {
                if (string4 == null || "".equals(string4) || templateValue2 != null) {
                    genericTable.setValueAt((Object)templateValue.toString(), n, 1);
                }
            } else if (templateValue2 != null && string4 != null) {
                String string5 = templateValue2.getBefore();
                String string6 = templateValue2.getAfter();
                StringBuilder stringBuilder = new StringBuilder();
                if (string5 != null) {
                    stringBuilder.append(Pattern.quote(string5));
                }
                stringBuilder.append(".*");
                if (string6 != null) {
                    stringBuilder.append(Pattern.quote(string6));
                }
                if (string4.matches(stringBuilder.toString())) {
                    genericTable.setValueAt(null, n, 1);
                }
            }
        }
    }
}

