/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.table.GenericBaseTableModel;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.ui.table.TableToolbar;
import oracle.javatools.util.ModelUtil;

public class ExtendedTable {
    private static final String CLIENT_KEY = "oracle.ideimpl.db.controls.ExtendedTable";
    private final DBUIResourceHelper m_resHelp;
    private final ReorderableTableWithTitleBar m_component;
    private final GenericTable m_table;
    private StringTableModel m_tableModel;
    private final JButton m_addButton;
    private final JButton m_deleteButton;
    private Collection<Document> m_cellEditorDocument;
    private boolean m_dirtyModel;
    private boolean m_enabled = true;
    private final Collection<Document> m_documents = new CopyOnWriteArrayList<Document>();
    private final DocumentListener m_docListener = new CellDocumentListener();
    private final Collection<TableModelListener> m_listeners = new CopyOnWriteArrayList<TableModelListener>();

    public ExtendedTable(String object, String string) {
        this.m_resHelp = new DBUIResourceHelper(string);
        this.m_table = this.createTable();
        this.m_table.setColumnSelectorAvailable(false);
        if (this.shouldTerminateEditOnFocusLost()) {
            this.m_table.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        }
        this.m_table.putClientProperty((Object)CLIENT_KEY, (Object)this);
        this.m_resHelp.setName((Component)this.m_table, "Table");
        this.m_table.setDefaultEditor(String.class, (TableCellEditor)new StringCellEditor());
        JScrollPane jScrollPane = new JScrollPane((Component)this.m_table);
        jScrollPane.putClientProperty(CLIENT_KEY, this);
        this.m_component = new ReorderableTableWithTitleBar((JTable)this.m_table, this.isReorderable(), false);
        if (ModelUtil.hasLength((String)object) && !((String)object).endsWith(":")) {
            object = (String)object + ":";
        }
        TableToolbar tableToolbar = new TableToolbar((JTable)this.m_table, (String)object);
        this.m_addButton = this.createAddButton();
        this.m_deleteButton = this.createDeleteButton();
        ListSelectionModel listSelectionModel = this.m_table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        this.setSelectionModel(listSelectionModel);
        this.m_component.setTableToolbar(tableToolbar);
        this.setButtonsVisible(true);
        this.m_component.putClientProperty((Object)CLIENT_KEY, (Object)this);
        this.m_resHelp.setName((Component)this.m_component, "TableWithToolbar");
        this.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                ExtendedTable.this.m_dirtyModel = true;
                ExtendedTable.this.checkButtons();
            }
        });
    }

    protected final DBUIResourceHelper getResourceHelper() {
        return this.m_resHelp;
    }

    protected boolean isReorderable() {
        return false;
    }

    public void setEnabled(boolean bl) {
        this.m_enabled = bl;
        if (this.m_component != null) {
            this.setEnabled((Component)this.m_component.getReorderableBar(), bl);
            this.checkButtons();
        }
    }

    private void checkButtons() {
        this.setEnabled(this.m_addButton, this.m_enabled && this.m_table.getColumnCount() > 0);
        this.setEnabled(this.m_deleteButton, this.m_enabled && this.canRemoveRow(this.m_table.getSelectedRowInModel()));
    }

    private void setEnabled(Component component, boolean bl) {
        if (component != null) {
            component.setEnabled(bl);
        }
    }

    protected boolean canRemoveRow(int n) {
        return n >= 0;
    }

    public final void addTableModelListener(TableModelListener tableModelListener) {
        if (!this.m_listeners.contains(tableModelListener)) {
            this.m_listeners.add(tableModelListener);
            if (this.m_tableModel != null) {
                this.m_tableModel.addTableModelListener(tableModelListener);
            }
        }
    }

    public final void removeTableModelListener(TableModelListener tableModelListener) {
        this.m_listeners.remove(tableModelListener);
        if (this.m_tableModel != null) {
            this.m_tableModel.removeTableModelListener(tableModelListener);
        }
    }

    private GenericTable createTable() {
        return new GenericTable(){

            public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
                Component component = super.prepareEditor(tableCellEditor, n, n2);
                ExtendedTable.this.prepareEditorComponent(component, tableCellEditor, n, n2);
                return component;
            }

            public void editingCanceled(ChangeEvent changeEvent) {
                ExtendedTable.this.clearCellEditorDocuments();
                super.editingCanceled(changeEvent);
            }

            public void editingStopped(ChangeEvent changeEvent) {
                ExtendedTable.this.clearCellEditorDocuments();
                super.editingStopped(changeEvent);
            }
        };
    }

    protected void prepareEditorComponent(Component component, TableCellEditor tableCellEditor, int n, int n2) {
        this.clearCellEditorDocuments();
        this.registerDocumentListener(component);
        if (tableCellEditor instanceof ExtendedTableCellEditor) {
            ((ExtendedTableCellEditor)tableCellEditor).prepareComponent(component);
        }
    }

    private void registerDocumentListener(Component component) {
        if (component instanceof JTextComponent) {
            this.registerCellEditorDocument(((JTextComponent)component).getDocument());
        } else if (component instanceof JComboBox) {
            ComboBoxEditor comboBoxEditor = ((JComboBox)component).getEditor();
            if (comboBoxEditor != null) {
                this.registerDocumentListener(comboBoxEditor.getEditorComponent());
            }
        } else if (component instanceof JPanel) {
            for (Component component2 : ((JPanel)component).getComponents()) {
                this.registerDocumentListener(component2);
            }
        }
    }

    private void clearCellEditorDocuments() {
        for (Document document : this.m_documents) {
            document.removeDocumentListener(this.m_docListener);
        }
        this.m_documents.clear();
    }

    private void registerCellEditorDocument(Document document) {
        if (!this.m_documents.contains(document)) {
            this.m_documents.add(document);
            document.addDocumentListener(this.m_docListener);
        }
    }

    protected final void fireCellEditedEvent() {
        if (this.m_tableModel != null && !this.m_listeners.isEmpty()) {
            GenericTable genericTable = this.getTable();
            int n = genericTable.getEditingColumn();
            int n2 = genericTable.getEditingRow();
            TableModelEvent tableModelEvent = new TableModelEvent((TableModel)((Object)this.m_tableModel), n2, n2, n, 0);
            for (TableModelListener tableModelListener : this.m_listeners) {
                if (!(tableModelListener instanceof ExtendedTableModelListener)) continue;
                ((ExtendedTableModelListener)tableModelListener).cellValueEdited(tableModelEvent);
            }
        }
    }

    protected boolean shouldTerminateEditOnFocusLost() {
        return false;
    }

    private JButton createAddButton() {
        JButton jButton = new JButton();
        this.m_resHelp.resIconicButton(jButton, OracleIcons.getIcon((String)"add.png"), this.getAddActionText(), "Add");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedTable.this.stopCellEditing();
                ExtendedTable.this.addNewRow();
                int n = ExtendedTable.this.m_tableModel.getRowCount() - 1;
                ExtendedTable.this.m_table.setSelectedRowInModel(n);
                ExtendedTable.this.m_table.scrollToSelection();
                if (ExtendedTable.this.m_table.editCellAt(n, 0)) {
                    ExtendedTable.this.m_table.getEditorComponent().requestFocusInWindow();
                }
            }
        });
        return jButton;
    }

    protected void addNewRow() {
        this.m_tableModel.addRow(new Vector(this.m_tableModel.getColumnCount()));
    }

    public void setButtonsVisible(boolean bl) {
        TableToolbar tableToolbar = this.m_component.getTableToolbar();
        if (tableToolbar != null) {
            tableToolbar.removeActionControl((Component)this.m_addButton);
            tableToolbar.removeActionControl((Component)this.m_deleteButton);
            if (bl) {
                tableToolbar.addActionControl((Component)this.m_addButton, true);
                tableToolbar.addActionControl((Component)this.m_deleteButton, true);
            }
        }
    }

    private JButton createDeleteButton() {
        JButton jButton = new JButton();
        this.m_resHelp.resIconicButton(jButton, OracleIcons.getIcon((String)"delete.png"), this.getDeleteActionText(), "Delete");
        jButton.setEnabled(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedTable.this.stopCellEditing();
                int n = ExtendedTable.this.m_table.getSelectedRowInModel();
                if (n >= 0) {
                    ExtendedTable.this.m_tableModel.removeRow(n);
                    int n2 = ExtendedTable.this.m_table.getRowCount();
                    if (n2 > 0) {
                        ExtendedTable.this.m_table.setSelectedRowInModel(n < n2 ? n : n2 - 1);
                    }
                }
            }
        });
        return jButton;
    }

    protected String getDeleteActionText() {
        return UIBundle.get("LIST_BUTTONS_REMOVE");
    }

    protected String getAddActionText() {
        return UIBundle.get("LIST_BUTTONS_ADD");
    }

    public final ReorderableTableWithTitleBar getComponent() {
        return this.m_component;
    }

    public final GenericTable getTable() {
        return this.m_table;
    }

    public final void setSelectionModel(ListSelectionModel listSelectionModel) {
        this.getTable().setSelectionModel(listSelectionModel);
        listSelectionModel.addListSelectionListener(listSelectionEvent -> this.checkButtons());
    }

    public void setModel(StringTableModel stringTableModel) {
        if (this.m_tableModel != null) {
            for (TableModelListener tableModelListener : this.m_listeners) {
                this.m_tableModel.removeTableModelListener(tableModelListener);
            }
        }
        this.m_tableModel = stringTableModel;
        this.m_table.setModel((TableModel)((Object)this.m_tableModel));
        this.modelReplaced();
        this.m_dirtyModel = false;
        this.checkButtons();
        for (TableModelListener tableModelListener : this.m_listeners) {
            stringTableModel.addTableModelListener(tableModelListener);
        }
    }

    public final boolean isModelDirty() {
        return this.m_dirtyModel;
    }

    protected void modelReplaced() {
    }

    public final StringTableModel getModel() {
        return this.m_tableModel;
    }

    public void stopCellEditing() {
        TableCellEditor tableCellEditor = this.m_table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        this.clearCellEditorDocuments();
    }

    public static ExtendedTable getExtendedTable(JComponent jComponent) {
        return (ExtendedTable)jComponent.getClientProperty(CLIENT_KEY);
    }

    public Vector<String> getPropertyColumnNames(String ... stringArray) {
        Vector<String> vector = new Vector<String>();
        for (String string : stringArray) {
            vector.add(PropertyDisplayRegistry.getDisplayName(string));
        }
        return vector;
    }

    public class StringTableModel
    extends GenericBaseTableModel {
        public StringTableModel(Vector<Vector> vector, Vector<String> vector2) {
            super(vector, vector2);
        }

        public boolean canHide(int n) {
            return false;
        }

        public boolean isCellEditable(int n, int n2) {
            return ExtendedTable.this.m_enabled;
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public void setValueAt(Object object, int n, int n2) {
            Object object2 = this.getValueAt(n, n2);
            if (ModelUtil.areDifferent((Object)object, (Object)object2) && (object2 != null || !"".equals(object))) {
                super.setValueAt(object, n, n2);
            }
        }
    }

    public static interface ExtendedTableCellEditor
    extends TableCellEditor {
        public void prepareComponent(Component var1);
    }

    public static interface ExtendedTableModelListener
    extends TableModelListener {
        public void cellValueEdited(TableModelEvent var1);
    }

    protected class EditableComboCellEditor
    extends DefaultCellEditor {
        public EditableComboCellEditor(String string, String ... stringArray) {
            this(new JComboBox(), string);
            for (String string2 : stringArray) {
                ((JComboBox)this.getComponent()).addItem(string2);
            }
        }

        public EditableComboCellEditor(JComboBox jComboBox, String string) {
            super(jComboBox);
            jComboBox.setEditable(true);
            ExtendedTable.this.getResourceHelper().setName(jComboBox, string);
            jComboBox.getEditor().getEditorComponent().setName(jComboBox.getName() + "-editor");
        }

        protected final JComboBox getCombo() {
            return (JComboBox)this.getComponent();
        }

        @Override
        public Object getCellEditorValue() {
            return this.getCombo().getEditor().getItem();
        }

        protected final JTextComponent getEditorComponent() {
            return (JTextComponent)this.getCombo().getEditor().getEditorComponent();
        }
    }

    private class StringCellEditor
    extends DefaultCellEditor {
        StringCellEditor() {
            super(new JTextField());
            ExtendedTable.this.getResourceHelper().setName(this.getComponent(), "StringCellEditor");
            this.setClickCountToStart(1);
        }
    }

    private class CellDocumentListener
    implements DocumentListener {
        private CellDocumentListener() {
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            ExtendedTable.this.fireCellEditedEvent();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            ExtendedTable.this.fireCellEditedEvent();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

