/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.text.Document;
import oracle.bali.ewt.text.NumberTextField;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.resource.UIBundle;

public class NumberTextFieldUnlimited
extends JPanel {
    private final JCheckBox m_chkUnlimited = new JCheckBox();
    private final NumberTextField m_numberField = new NumberTextField();
    public static final String CHECK_SUFFIX = "Check";
    public static final String TEXT_SUFFIX = "Text";
    private final int m_unlimitedValue;

    public NumberTextFieldUnlimited() {
        this(0);
    }

    public NumberTextFieldUnlimited(int n) {
        this.m_unlimitedValue = n;
        this.init();
    }

    private void init() {
        this.m_chkUnlimited.setText(UIBundle.get("FILE_SPECS_INFO_LABEL_UNLIMITED_MAX_SIZE"));
        this.m_chkUnlimited.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                NumberTextFieldUnlimited.this.m_numberField.setEnabled(!((JCheckBox)object).isSelected());
            }
        });
        DBUILayoutHelper dBUILayoutHelper = new DBUILayoutHelper(this);
        dBUILayoutHelper.setMargins(0);
        dBUILayoutHelper.add((Component)this.m_numberField);
        dBUILayoutHelper.add(this.m_chkUnlimited);
        dBUILayoutHelper.layout();
    }

    @Override
    public final void setName(String string) {
        super.setName(string);
        this.m_numberField.setName(string + TEXT_SUFFIX);
        this.m_chkUnlimited.setName(string + CHECK_SUFFIX);
    }

    public void setNumber(Number number) {
        if (number != null && number.intValue() == this.m_unlimitedValue) {
            this.m_chkUnlimited.setSelected(true);
            this.m_numberField.setNumber(null);
            this.m_numberField.setEnabled(false);
        } else {
            this.m_chkUnlimited.setSelected(false);
            this.m_numberField.setNumber(number);
            this.m_numberField.setEnabled(true);
        }
    }

    public Number getNumber() {
        Number number = this.m_chkUnlimited.isSelected() ? (Number)(BigInteger.class.isAssignableFrom(this.m_numberField.getDataType()) ? BigInteger.valueOf(this.m_unlimitedValue) : Integer.valueOf(this.m_unlimitedValue)) : (Number)this.m_numberField.getNumber();
        return number;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_chkUnlimited.setEnabled(bl);
        this.m_numberField.setEnabled(bl && !this.m_chkUnlimited.isSelected());
    }

    @Override
    public boolean isEnabled() {
        return this.m_numberField.isEnabled();
    }

    public Document getDocument() {
        return this.m_numberField.getDocument();
    }

    public NumberTextField getNumberTextField() {
        return this.m_numberField;
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_chkUnlimited.addActionListener(actionListener);
    }

    public void setCheckBoxLabel(String string) {
        this.m_chkUnlimited.setText(string);
    }
}

