/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.ide.util.StringComparator;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.ui.StatusIndicator;
import oracle.javatools.ui.plaf.IconicButtonUI;

public class ShuttlePanel<T>
extends JPanel {
    private final Shuttle m_shuttle = new Shuttle();
    private final JList m_availableJList = new JList();
    private final JList m_selectedJList = new JList();
    private final JLabel m_lblFrom;
    private final JComponent m_lblTo;

    public ShuttlePanel(boolean bl, String string, String string2) {
        this(bl, null, string, null, string2);
    }

    public ShuttlePanel(boolean bl, Integer n, String string, ListCellRenderer listCellRenderer, String string2) {
        ListPicker listPicker = new ListPicker(this.m_availableJList);
        Object object = bl ? new ReorderableListPicker(this.m_selectedJList) : new ListPicker(this.m_selectedJList);
        this.m_shuttle.setFromPicker((ItemPicker)listPicker);
        this.m_shuttle.setToPicker((ItemPicker)object);
        if (n != null) {
            this.m_shuttle.setButtonsShown(n.intValue());
        }
        this.m_lblFrom = new JLabel(UIBundle.format("SHUTTLE_AVAILABLE_GENERIC_TITLE", string));
        this.m_lblFrom.setLabelFor(this.m_availableJList);
        JLabel jLabel = new JLabel(UIBundle.format("SHUTTLE_SELECTED_GENERIC_TITLE", string));
        jLabel.setLabelFor(this.m_selectedJList);
        StatusIndicator statusIndicator = new StatusIndicator();
        statusIndicator.setStatus(StatusIndicator.Status.OK);
        this.m_lblTo = statusIndicator.configureLabel(jLabel, StatusIndicator.Location.LEADING);
        this.m_shuttle.add((Component)this.m_lblFrom, (Object)"FromHeader");
        this.m_shuttle.add((Component)this.m_lblTo, (Object)"ToHeader");
        if (listCellRenderer != null) {
            this.m_availableJList.setCellRenderer(listCellRenderer);
            this.m_selectedJList.setCellRenderer(listCellRenderer);
        }
        for (Component component : this.m_shuttle.getComponents()) {
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(false);
            }
            if (!component.getClass().equals(JPanel.class)) continue;
            this.installIconicButtonUI((JPanel)component);
        }
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_shuttle, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        DBUIResourceHelper dBUIResourceHelper = new DBUIResourceHelper(string2);
        this.setName(string2);
        dBUIResourceHelper.setName((Component)this.m_shuttle, "Shuttle");
        dBUIResourceHelper.setName(this.m_availableJList, "Available");
        dBUIResourceHelper.setName(this.m_selectedJList, "Selected");
    }

    private void installIconicButtonUI(JPanel jPanel) {
        for (Component component : jPanel.getComponents()) {
            if (!(component instanceof AbstractButton)) continue;
            IconicButtonUI.install((AbstractButton)((AbstractButton)component));
        }
    }

    public synchronized void addShuttleListener(ShuttleListener shuttleListener) {
        this.m_shuttle.addShuttleListener(shuttleListener);
    }

    public synchronized void removeShuttleListener(ShuttleListener shuttleListener) {
        this.m_shuttle.removeShuttleListener(shuttleListener);
    }

    public Component getToComponent() {
        return this.m_shuttle.getToPicker().getComponent();
    }

    public Component getToLabel() {
        return this.m_lblTo;
    }

    public Component getFromComponent() {
        return this.m_shuttle.getFromPicker().getComponent();
    }

    public Component getFromLabel() {
        return this.m_lblFrom;
    }

    public List<T> getSelected() {
        DefaultListModel defaultListModel = this.getModel(true);
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            arrayList.add(defaultListModel.get(i));
        }
        return arrayList;
    }

    public void setSelected(List<T> list) {
        int n;
        DefaultListModel defaultListModel = this.getModel(false);
        DefaultListModel defaultListModel2 = this.getModel(true);
        Set set = this.getSet();
        for (n = 0; n < defaultListModel.getSize(); ++n) {
            set.add(defaultListModel.get(n));
        }
        for (n = 0; n < defaultListModel2.getSize(); ++n) {
            set.add(defaultListModel2.get(n));
        }
        defaultListModel.removeAllElements();
        defaultListModel2.removeAllElements();
        for (Object e : set) {
            if (list.contains(e)) {
                defaultListModel2.addElement(e);
                continue;
            }
            defaultListModel.addElement(e);
        }
    }

    protected Set getSet() {
        return new TreeSet(new StringComparator());
    }

    public void initialise(List list) {
        this.clearList(false);
        this.clearList(true);
        DefaultListModel defaultListModel = this.getModel(false);
        Set set = this.getSet();
        set.addAll(list);
        for (Object e : set) {
            defaultListModel.addElement(e);
        }
    }

    protected void clearList(boolean bl) {
        DefaultListModel defaultListModel = this.getModel(bl);
        defaultListModel.removeAllElements();
    }

    protected DefaultListModel getModel(boolean bl) {
        ListPicker listPicker = bl ? (ListPicker)this.m_shuttle.getToPicker() : (ListPicker)this.m_shuttle.getFromPicker();
        return (DefaultListModel)listPicker.getList().getModel();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_shuttle.setEnabled(bl);
        this.m_availableJList.setEnabled(bl);
        this.m_selectedJList.setEnabled(bl);
        this.m_lblFrom.setEnabled(bl);
        this.m_lblTo.setEnabled(bl);
    }
}

