/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.hive.components;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.components.ExtendedTableComponentWrapper;
import oracle.ideimpl.db.controls.ExtendedTable;
import oracle.ideimpl.db.controls.KeyValueTable;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.hive.TblProperty;
import oracle.javatools.db.property.Property;

public class TblPropertiesComponentWrapper
extends ExtendedTableComponentWrapper<TblPropertiesJTable> {
    public TblPropertiesComponentWrapper(String string) {
        super(new TblPropertiesJTable(string));
    }

    @Override
    protected void initialiseComponent() {
        Object object;
        super.initialiseComponent();
        if (this.getComponentContext().isInFlatEditor()) {
            this.getComponent().setPreferredSize(new Dimension(200, 100));
        }
        if (this.getProvider() instanceof Database && "serDeProperties".equals(Property.getLastProperty((String)this.getPropertyName())) && (object = this.getOriginalPropertyValue()) instanceof TblProperty[]) {
            HashSet<String> hashSet = new HashSet<String>();
            for (TblProperty tblProperty : (TblProperty[])object) {
                hashSet.add(tblProperty.getName());
            }
            ((TblPropertiesJTable)this.getExtendedTable()).setNonRemoveableProperties(hashSet);
        }
    }

    @Override
    public Object getPropertyValue() {
        return ((TblPropertiesJTable)this.getExtendedTable()).getTblProperties();
    }

    @Override
    public void setPropertyValue(Object object) {
        ((TblPropertiesJTable)this.getExtendedTable()).setTblProperties((TblProperty[])object);
    }

    static class TblPropertiesJTable
    extends KeyValueTable {
        private Collection<String> m_noRemove;

        public TblPropertiesJTable(String string) {
            super(PropertyDisplayRegistry.getDisplayName(string), string);
        }

        public void setNonRemoveableProperties(Collection<String> collection) {
            this.m_noRemove = collection;
        }

        public void setTblProperties(TblProperty[] tblPropertyArray) {
            Vector<Vector> vector = new Vector<Vector>();
            if (tblPropertyArray != null) {
                for (TblProperty tblProperty : tblPropertyArray) {
                    Vector<String> vector2 = new Vector<String>();
                    vector2.add(tblProperty.getName());
                    vector2.add(tblProperty.getTablePropertyValue());
                    vector.add(vector2);
                }
            }
            this.setModel(new ExtendedTable.StringTableModel(vector, this.getPropertyColumnNames("name", "tablePropertyValue")));
        }

        public TblProperty[] getTblProperties() {
            this.stopCellEditing();
            Vector vector = this.getModel().getDataVector();
            TblProperty[] tblPropertyArray = null;
            if (!vector.isEmpty()) {
                tblPropertyArray = new TblProperty[vector.size()];
                int n = 0;
                for (Vector vector2 : vector) {
                    tblPropertyArray[n++] = new TblProperty((String)vector2.get(0), (String)vector2.get(1));
                }
            }
            return tblPropertyArray;
        }

        @Override
        protected void addNewRow() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Object e : this.getModel().getDataVector()) {
                arrayList.add((String)((Vector)e).get(0));
            }
            String string = DBUtil.getUniqueName(arrayList, (String)"property1");
            this.getModel().addRow(new Object[]{string, null});
        }

        @Override
        protected boolean isReorderable() {
            return false;
        }

        @Override
        protected boolean canRemoveRow(int n) {
            Vector vector;
            boolean bl = super.canRemoveRow(n);
            if (bl && this.m_noRemove != null && (vector = this.getModel().getDataVector()).size() > n) {
                Vector vector2 = (Vector)vector.get(n);
                bl = !this.m_noRemove.contains(vector2.get(0));
            }
            return bl;
        }
    }
}

