/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.swing.text.JTextComponent;
import oracle.ide.db.components.ComponentContext;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.Property;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public abstract class ChildObjectEditorPanel<C extends ChildDBObject, P extends DBObject>
extends BaseEditorPanel<P> {
    private boolean m_childComponentsExist;
    private C m_currentChild;
    private boolean m_singleChild;
    private String m_extraPropPath;

    protected ChildObjectEditorPanel(String string) {
        this(null, string);
    }

    protected ChildObjectEditorPanel(String string, String string2) {
        this(string, string2, false);
    }

    protected ChildObjectEditorPanel(String string, String string2, boolean bl) {
        super(string);
        this.getComponentFactory().setBasePath(string2);
        this.m_singleChild = bl;
    }

    protected final C getChildObject() {
        ChildDBObject childDBObject = null;
        if (this.m_singleChild) {
            DBObject dBObject = this.getComponentFactoryUpdatedObject();
            if (dBObject != null) {
                childDBObject = (ChildDBObject)this.getPropertyHelper().getPropertyValue((Object)dBObject, this.getPropertyPath());
            }
        } else {
            childDBObject = (ChildDBObject)this.getChildObjectFromDataContext();
        }
        return (C)childDBObject;
    }

    private C getChildObjectFromDataContext() {
        return (C)((ChildDBObject)this.getDataContext().get("NewChildObject"));
    }

    protected C getOriginalChildObject() {
        return (C)((ChildDBObject)TemporaryObjectID.findOriginalObject(this.getChildObject()));
    }

    @Override
    protected DBObject getComponentFactoryUpdatedObject() {
        Object object;
        if (this.m_singleChild) {
            Object object2;
            Namespace namespace;
            String string = this.getPropertyPath();
            if (string == null) {
                throw new IllegalStateException("Expecting a single child edit but we have no property path");
            }
            Namespace namespace2 = namespace = this.getDataContext();
            Holder holder = null;
            while (true) {
                if (namespace2.contains("NewChildObject")) {
                    object2 = (DBObject)namespace2.get("NewChildObject");
                    holder = new Holder(object2);
                    break;
                }
                object2 = namespace2.getParent();
                if (object2 == null || namespace2 == object2) break;
                namespace2 = object2;
            }
            object2 = this.getComponentFactory().getBasePath();
            if (holder == null) {
                object = this.getUpdatedObject();
                if (ModelUtil.hasLength((String)object2)) {
                    throw new IllegalStateException("Not expecting a base path if we're editing directly on the top object.");
                }
            } else {
                object = (DBObject)holder.get();
            }
        } else {
            object = this.getChildObjectFromDataContext();
        }
        return object;
    }

    @Override
    protected DBObject getComponentFactoryOriginalObject() {
        return TemporaryObjectID.findOriginalObject((DBObject)this.getComponentFactoryUpdatedObject());
    }

    protected JTextComponent getNameField() {
        JTextComponent jTextComponent = null;
        ComponentWrapper componentWrapper = this.getComponentFactory().findComponentWrapper("name");
        if (componentWrapper != null) {
            jTextComponent = (JTextComponent)componentWrapper.getActiveComponent();
        }
        return jTextComponent;
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this.getNameField();
    }

    @Override
    protected String getComponentPath(String string) {
        String string2 = this.m_singleChild ? Property.createPath((String[])new String[]{this.getPropertyPath(), string}) : string;
        return string2;
    }

    private void initialiseChildWrappers() {
        if (this.usesComponentWrappers()) {
            Boolean bl = null;
            C c = this.getChildObject();
            if (c != this.m_currentChild) {
                this.m_currentChild = c;
                bl = c != null;
            } else if (this.m_singleChild && !this.m_childComponentsExist) {
                bl = true;
            }
            if (bl != null) {
                if (!this.m_singleChild) {
                    if (bl.booleanValue()) {
                        this.setVisible(true);
                    } else {
                        this.setVisible(false);
                    }
                }
                if (!this.m_childComponentsExist && bl.booleanValue()) {
                    this.initialiseChildComponents();
                    this.getComponentFactory().processComponents();
                    this.m_childComponentsExist = true;
                }
                this.validate();
                this.repaint();
            }
        }
    }

    @Override
    protected final void canCommit() throws TraversalException {
        if (!this.m_singleChild) {
            super.canCommit();
        }
    }

    protected void initialiseChildComponents() {
    }

    @Override
    protected void initialisePanel() {
        this.initialiseChildWrappers();
    }

    private boolean usesComponentWrappers() {
        boolean bl = false;
        for (Class<?> clazz = this.getClass(); clazz != null && !ChildObjectEditorPanel.class.equals(clazz); clazz = clazz.getSuperclass()) {
            try {
                Method method = clazz.getDeclaredMethod("initialiseChildComponents", new Class[0]);
                bl = true;
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        return bl;
    }

    protected final void setChildOnParent(C c) {
        String string = this.getPropertyPath();
        if (string == null) {
            throw new IllegalStateException("setChildOnParent only valid if getPropertyPath() returns a path.");
        }
        DBObject dBObject = this.getComponentFactoryUpdatedObject();
        if (dBObject != null) {
            try {
                this.getPropertyHelper().setPropertyValueOrFail((Object)dBObject, string, c);
            }
            catch (MissingPropertyException missingPropertyException) {
                DBLog.getLogger((Object)this).log(Level.WARNING, missingPropertyException.getMessage(), missingPropertyException);
            }
        }
    }

    protected String getPropertyPath() {
        return this.m_extraPropPath;
    }

    @Override
    protected boolean shouldValidateOnExit() {
        boolean bl = false;
        C c = this.getChildObject();
        if (c != null && c.getParent() != null) {
            bl = super.shouldValidateOnExit();
        }
        return bl;
    }

    @Override
    protected void refreshComponents() {
        String string = this.getComponentFactory().getBasePath();
        for (ComponentWrapper componentWrapper : this.getComponentFactory().getComponentWrappers()) {
            componentWrapper.getComponentContext().setBasePath(string);
        }
        super.refreshComponents();
    }

    @Override
    protected void initialiseWrappedPanel(ComponentContext componentContext) {
        super.initialiseWrappedPanel(componentContext);
        this.getComponentFactory().setBasePath(componentContext.getBasePath());
        this.m_extraPropPath = componentContext.getPropertyName();
    }
}

